//
//    Copyright 2007 Andreas Pfeiffer
//
/*
 *  This file is part of iAIDA.
 *
 *  iAIDA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as 
 *  published by the Free Software Foundation, either version 3 of 
 *  the License.
 *
 *  iAIDA is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public 
 *  License along with iAIDA.  If not, see <http://www.gnu.org/licenses/>.
 */

// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_Dev_IDEVFUNCTION_H
#define AIDA_Dev_IDEVFUNCTION_H 1

#include <string>
#include <vector>

#include "AIDA/IAnnotation.h"
#include "AIDA/IFunction.h"
#include "AIDA_Dev/IDevManagedObject.h"

namespace AIDA {
namespace Dev {

/** 
 * @interface IDevFunction
 *
 * Developers interface for AIDA function.
 *
 * @author Jakub Moscicki, Max Turri, Victor Serbo
 * @author Andreas Pfeiffer, Max Sang, Tony Johnson, Lorenzo Moneta
 *
 * @stereotype developer
 */    

class IDevFunction : virtual public AIDA::IFunction,
		     virtual public IDevManagedObject {

public: 
    /// Destructor.
    virtual ~IDevFunction() { /* nop */; }

    virtual void setCodeletString(std::string codelet) = 0;

    virtual void setDimension(int dim) = 0;

    virtual void setProvidesGradient(bool yes) = 0;

    /// Fails if dimension not set or size of the vector is different than
    /// dimension.
    virtual bool setVariableNames(const std::vector<std::string>  & names) = 0;

    virtual void setNumberOfParameters(int parnum) = 0;

    /// Fails if number of params not set or size of the vector is 
    /// different than number of params.
    virtual bool setParameterNames(const std::vector<std::string>  & names) = 0;

    /// Annotation pointer must be allocated dynamically (new) and
    /// ownership is transfered to the function (annotation is
    /// automatically deleted by function).
    virtual void setAnnotation(AIDA::IAnnotation * ptr) = 0;
}; // class
} // namespace Dev
} // namespace AIDA
#endif /* ifndef AIDA_Dev_IDEVFUNCTION_H */
