//
//    Copyright 2007 Andreas Pfeiffer
//
/*
 *  This file is part of iAIDA.
 *
 *  iAIDA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as 
 *  published by the Free Software Foundation, either version 3 of 
 *  the License.
 *
 *  iAIDA is distributed in the hope that it will be useful, but 
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public 
 *  License along with iAIDA.  If not, see <http://www.gnu.org/licenses/>.
 */

// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_CPP_DUMMYTREE_H
#define AIDA_CPP_DUMMYITREE_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include "AIDA/ITree.h"

#include <iostream>
#include <string>
#include <vector>


namespace AIDA_CPP {


class DummyTree : public AIDA::ITree {

public: 
  /// Destructor.
  virtual ~DummyTree() { /* nop */; }
  
  std::string  storeName() const {  
    static std::string local;
    return local;
  }
  
  AIDA::IManagedObject * find(const std::string & path){ return 0;}
  
  bool cd(const std::string & path){ return true;}
  
  std::string  pwd() const{ 
    static std::string local;
    return local;
  }
  AIDA::ITree * findTree(const std::string & path) { return 0; } 
  
  bool ls(const std::string & path = ".", bool recursive = false, std::ostream & os = std::cout) const
  { return true;}
  
  
  std::vector<std::string>  listObjectNames(const std::string & path = ".", bool recursive = false) const
  { return std::vector<std::string>();}

  std::vector<std::string>  listObjectTypes(const std::string & path = ".", bool recursive = false) 
    const{ return std::vector<std::string>();}
  
  bool mkdir(const std::string & path){ return true;}
  
  bool mkdirs(const std::string & path){ return true;}
  
  bool rmdir(const std::string & path){ return true;}
  
  bool rm(const std::string & path){ return true;}
  
  std::string findPath(const AIDA::IManagedObject & object) const{ return std::string();}
  
  bool mv(const std::string & oldPath, const std::string & newPath){ return 0;}
  
  bool commit(){ return true;}
  
  void setOverwrite(bool overwrite = true){}
  
  bool cp(const std::string & oldPath, const std::string & newPath, bool recursive = false){ return true;}

  bool symlink(const std::string & path, const std::string & alias){ return true;}
  
  bool mount(const std::string & path, ITree & tree, const std::string & treePath){ return true;}
  
  bool unmount(const std::string & path){ return true;}
  
  bool close(){ return true;}

  void * cast(const std::string & className) const { return 0; } 
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_ITREE_H */
