// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IPROFILE_H
#define AIDA_IPROFILE_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include "AIDA/IBaseHistogram.h"

namespace AIDA {

/**
 * User level interface to a Profile histogram
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
class IProfile : virtual public IBaseHistogram {

public: 
    /// Destructor.
    virtual ~IProfile() { /* nop */; }

    /**
     * Get the number or all the entries, both in range and 
     * underflow/overflow bins of the IProfile.
     * @return The sum of all the entries.
     *
     */
    virtual int allEntries() const = 0;

    /**
     * Get the number of entries in the underflow and overflow bins.
     * @return The numer of entries in the out-of-range bins.
     *
     */
    virtual int extraEntries() const = 0;

    /**
     * Get the sum of in range bin heights in the IProfile.
     * @return The sum of all the in-range bins heights.
     *
     */
    virtual double sumBinHeights() const = 0;

    /**
     * Get the sum of all the bins heights (including underflow and overflow bin).
     * @return The sum of all the bins heights.
     *
     */
    virtual double sumAllBinHeights() const = 0;

    /**
     * Get the sum of the underflow and overflow bin height.
     * @return The sum of the out-of-range bins heights.
     *
     */
    virtual double sumExtraBinHeights() const = 0;

    /**
     * Get the minimum height of the in-range bins.
     * @return The minimum height among the in-range bins.
     *
     */
    virtual double minBinHeight() const = 0;

    /**
     * Get the maximum height of the in-range bins.
     * @return The maximum height among the in-range bins.
     *
     */
    virtual double maxBinHeight() const = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IPROFILE_H */
