// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IEVALUATOR_H
#define AIDA_IEVALUATOR_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

#include <string>

namespace AIDA {

class ITuple;

/**
 * User's level interface of an IEvaluator.
 *
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */
 
class IEvaluator {

public: 
    /// Destructor.
    virtual ~IEvaluator() { /* nop */; }

  /**
   * Initialize the IEvaluator and associate it to an ITuple.
   * @param tuple The ITuple to which the IEvaluator is sssociated.
   * @return false If the IEvaluator and 
   *              the ITuple are not compatible.
   *
   */ 
    virtual bool initialize(ITuple & tuple) = 0;

  /**
   * Evaluate the IEvaluator from the data in the 
   * current row of the ITuple it is associated to.
   * @return The current value of the Evaluator.
   *
   */ 
    virtual double evaluateDouble() const = 0;

   /**
    * Get the expression that defined the IEvaluator.
    * @return The expression.
    *
    */
    virtual std::string expression() const = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IEVALUATOR_H */
