// -*- C++ -*-
// AID-GENERATED
// =========================================================================
// This class was generated by AID - Abstract Interface Definition          
// DO NOT MODIFY, but use the org.freehep.aid.Aid utility to regenerate it. 
// =========================================================================
#ifndef AIDA_IDATAPOINT_H
#define AIDA_IDATAPOINT_H 1

//  This file is part of the AIDA library
//  Copyright (C) 2002 by the AIDA team.  All rights reserved.
//  This library is free software and under the terms of the
//  GNU Library General Public License described in the LGPL.txt 

namespace AIDA {

class IMeasurement;

/**
 * Basic user-level interface class for holding and managing
 * a single set of "measurements".
 * 
 * @author The AIDA team (http://aida.freehep.org/)
 *
 */

class IDataPoint {

public: 
    /// Destructor.
    virtual ~IDataPoint() { /* nop */; }

    /**
     * Get the dimension of the IDataPoint, i.e. the number
     * of coordinates the point has.
     * @return The dimension.
     *
     */
    virtual int dimension() const = 0;

    /**
     * Get the IMeasurement for a given coordinate.
     * @param coord The coordinate.
     * @return      The corresponding IMeasurement.
     *
     */
    virtual IMeasurement * coordinate(int coord) = 0;

    virtual const IMeasurement * coordinate(int coord) const = 0;
}; // class
} // namespace AIDA
#endif /* ifndef AIDA_IDATAPOINT_H */
