#!/usr/bin/env python
#
# Copyright (c) 2001-2004 Vaclav Slavik
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE. 
#
# $Id: generate.py,v 1.9 2004/12/26 12:21:17 vaclavslavik Exp $
#

import string
import os


# ------------------------------------------------------------
def writeStub(template, name, size, dll, number):
    if size == '': asize = ''
    else: asize = '@' + size
    s = template.replace('NAME', name).\
                 replace('@SIZE', asize).\
                 replace('DLL', dll)
    f = open('src/gen_asm/mslu%04i.asm' % number, 'wt');
    f.write(s)
    f.close()


# ------------------------------------------------------------
def writeDllWrapper(symbols):
    f = open('src/gen_asm/dll_wrapper.asm', 'wt');
    template = 'extern _NAME@SIZE\nexport NAME@SIZE\n'
    for name,size,dll in symbols:
        if size == '': asize = ''
        else: asize = '@' + size
        f.write(template.replace('NAME',name).replace('@SIZE',asize))
    f.close()



# ------------------------------------------------------------

def writeMakefiles(names):

    # MINGW ------------------------------------------------------
    objectFiles = ''
    for n in names:
        objectFiles += '\\\n           build/mingw32/mslu%04i.o ' % n;

    f = open('src/makefile.mingw32.include', 'wt')
    f.write("""# This file was automatically generated by generate.py

WRAPPERS = """ + objectFiles + """
""")
    f.close()

    # MSVC 6 ------------------------------------------------------
    objectFiles = ''
    for n in names:
        objectFiles += '\\\n           build\\msvc6\\mslu%04i.obj ' % n;

    f = open('src/makefile.vc6.include', 'wt')
    f.write("""# This file was automatically generated by generate.py

WRAPPERS = """ + objectFiles + """
""")
    f.close()
    
    # DigitalMars /w nmake ----------------------------------------
    objectFiles = ''
    for n in names:
        objectFiles += '\\\n           build\\dmc\\mslu%04i.obj ' % n;

    f = open('src/makefile.dmc.nmake.include', 'wt')
    f.write("""# This file was automatically generated by generate.py

WRAPPERS = """ + objectFiles + """
""")
    f.close()
    
    # LCC-Win32 ---------------------------------------------------
    objectFiles = ''
    for n in names:
        objectFiles += '\\\n           build\\lcc\\mslu%04i.obj ' % n;

    f = open('src/makefile.lcc.nmake.include', 'wt')
    f.write("""# This file was automatically generated by generate.py

WRAPPERS = """ + objectFiles + """
""")
    f.close()
    
    # Borland C++ -------------------------------------------------
    objectFiles = ''
    for n in names:
        objectFiles += '\\\n           build\\bcc32\\mslu%04i.obj ' % n;

    f = open('src/makefile.bcc.include', 'wt')
    f.write("""# This file was automatically generated by generate.py

WRAPPERS = """ + objectFiles + """
""")
    f.close()
    
    # Watcom C++ -------------------------------------------------
    objectFiles = ''
    for n in names:
        objectFiles += '&\n           build\\watcom\\mslu%04i.obj ' % n;

    f = open('src/makefile.wat.include', 'wt')
    f.write("""# This file was automatically generated by generate.py

WRAPPERS = """ + objectFiles + """
""")
    f.close()

# ------------------------------------------------------------

def loadSymbols():
    f = open('symbols.txt', 'rt')
    s = f.readlines()
    f.close()
    sym = []
    for i in s:
        dll = i[:10].split(' ')[-1].upper()
        sp = i[11:-1].split('@')
        if (len(sp) < 2): sp.append('')
        sym.append((sp[0],sp[1],dll))
    return sym


symbols = loadSymbols()
names = []

f = open('src/template.asm', 'rt')
template = f.read()
f.close()

number = 1
for sn,ss,sd in symbols:
    writeStub(template,sn,ss,sd,number)
    names.append(number)
    number += 1

writeMakefiles(names)
writeDllWrapper(symbols)
