/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.test;

import java.util.Date;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.test.SigarTestCase;

public class TestProcTime
extends SigarTestCase {
    public TestProcTime(String name) {
        super(name);
    }

    public void testCreate() throws Exception {
        Sigar sigar = this.getSigar();
        try {
            sigar.getProcTime(this.getInvalidPid());
        }
        catch (SigarException e) {
            // empty catch block
        }
        ProcCpu procTime = sigar.getProcCpu(sigar.getPid());
        this.assertGtEqZeroTrace("StartTime", procTime.getStartTime());
        this.traceln("StartDate=" + new Date(procTime.getStartTime()));
        this.assertGtEqZeroTrace("User", procTime.getUser());
        this.assertGtEqZeroTrace("Sys", procTime.getSys());
        this.assertGtEqZeroTrace("Total", procTime.getTotal());
        double value = procTime.getPercent() * 100.0;
        this.traceln("Percent=" + value);
        TestProcTime.assertTrue((value >= 0.0 ? 1 : 0) != 0);
        TestProcTime.assertTrue((value <= 100.0 ? 1 : 0) != 0);
    }
}

