#!/usr/bin/env ruby

require 'test/unit'
require 'HyperEstraier'

class TC_Condition < Test::Unit::TestCase
	def setup
		@cond = HyperEstraier::Condition.new()
	end

	def test_const_vars
		HyperEstraier::Condition::CONDSURE
		HyperEstraier::Condition::CONDUSU
		HyperEstraier::Condition::CONDFAST
		HyperEstraier::Condition::CONDAGIT
		HyperEstraier::Condition::CONDNOIDF
		HyperEstraier::Condition::CONDSIMPLE
	end

	def test_set_phrase
		@cond.set_phrase("foo")
	end
	
	def test_add_attr
		@cond.add_attr('@uri ISTREW .txt')
	end
	
	def test_set_order
		@cond.set_order('@id')
	end
	
	def test_set_max
		@cond.set_max(30)
	end
	
	def test_set_options
		@cond.set_options(HyperEstraier::Condition::CONDSURE)
	end
end

class TC_Document < Test::Unit::TestCase
	def setup
		@doc = HyperEstraier::Document.new()
	end

	def test_add_attr
		@doc.add_attr('@uri', 'http://tokuhirom.dnsalias.org/')
	end
	
	def test_add_text
		@doc.add_text('Hyper Estraier')
		@doc.add_text('QDBM')
	end
	
	def test_add_hidden_text
		@doc.add_hidden_text('a full-text search system for communities')
	end
	
	def test_id
		@doc.id()
	end
	
	def test_attr_names
		@doc.attr_names()
	end
	
	def test_attr
		#assert_equal(@doc.attr('@foo'), nil)
		@doc.add_attr('@foo', 'bar')
		assert_equal(@doc.attr('@foo'), 'bar')
	end
	
	def test_texts
		assert_equal(@doc.texts().to_a, [])
		@doc.add_text('foo')
		@doc.add_text('bar')
		assert_equal(@doc.texts().to_a, ['foo', 'bar'])
	end
	
=begin
	def test_cat_texts
		assert_equal(@doc.cat_texts(), '')
		@doc.add_text('foo')
		@doc.add_text('bar')
		assert_equal(@doc.cat_texts(), 'foobar')
	end
=end
	
	def test_dump_draft
		@doc.add_text('foo')
		@doc.add_text('bar')
		assert_equal(@doc.dump_draft(), "\nfoo\nbar\n")
	end
	
	def test_make_snippet
		@doc.add_text('foo')
		@doc.add_text('bar')
		@doc.add_text('baz')
		assert_equal(
				@doc.make_snippet(['foo', 'baz'], 30, 30, 20),
				"foo\tfoo\n bar \nbaz\tbaz\n\n")
	end
	
	def test_scan_words
		@doc.add_text('foo')
		assert_equal(@doc.scan_words(['foo']), true)
		assert_equal(@doc.scan_words(['bar']), false)
	end
end

class TC_Database < Test::Unit::TestCase
	def setup
		@db = HyperEstraier::Database.new()
		assert_equal(@db.open('casket',
				HyperEstraier::Database::DBWRITER | HyperEstraier::Database::DBCREAT),
				true)
		@doc = HyperEstraier::Document.new()
		@doc.add_attr('@uri', 'http://www.example.com/')
		@doc.add_text('foo')
		assert_equal(@db.put_doc(@doc, 0), true)
	end

	def test_const_vars
		HyperEstraier::Database::ERRNOERR
		HyperEstraier::Database::ERRINVAL
		HyperEstraier::Database::ERRACCES
		HyperEstraier::Database::ERRLOCK
		HyperEstraier::Database::ERRDB
		HyperEstraier::Database::ERRIO
		HyperEstraier::Database::ERRNOITEM
		HyperEstraier::Database::ERRMISC
		HyperEstraier::Database::DBREADER
		HyperEstraier::Database::DBWRITER
		HyperEstraier::Database::DBCREAT
		HyperEstraier::Database::DBTRUNC
		HyperEstraier::Database::DBNOLCK
		HyperEstraier::Database::DBLCKNB
		HyperEstraier::Database::DBPERFNG
		HyperEstraier::Database::PDCLEAN
		HyperEstraier::Database::ODCLEAN
		HyperEstraier::Database::OPTNOPURGE
		HyperEstraier::Database::OPTNODBOPT
		HyperEstraier::Database::GDNOATTR
		HyperEstraier::Database::GDNOTEXT
		@db.close
	end

	def test_err_msg
		HyperEstraier::Database::err_msg(0)
		@db.close
	end

	def test_error
		assert_equal(@db.error(), HyperEstraier::Database::ERRNOERR)
		@db.close()
	end
	def test_fatal
		assert_equal(@db.fatal(), false)
		@db.close()
	end

	def test_flush
		assert_equal(@db.flush(0), true)
		@db.close()
	end

	def test_sync
		assert_equal(@db.sync(), true)
		@db.close()
	end

	def test_optimize
		assert_equal(@db.optimize(0), true)
		@db.close()
	end

	def test_PutDoc
		doc = HyperEstraier::Document.new()
		doc.add_attr('@uri', 'http://www.example.com/')
		doc.add_text('foo')
		assert_equal(@db.put_doc(doc, 0), true)
		@db.close()
	end
	
	def test_OutDoc
		assert_equal(@db.out_doc(@doc.id(), 0), true)
		@db.close()
	end

	def test_GetDoc
		assert_not_equal(@db.get_doc(@doc.id(), 0), nil)
		@db.close()
	end

	def test_UriToID
		assert_equal(@db.uri_to_id('http://www.example.com/'), @doc.id())
		@db.close()
	end

	def test_EtchDoc
		assert_equal(@db.etch_doc(@doc, 10).keys(), ['foo'])
		@db.close()
	end
	
	def test_IterInit
		assert_equal(@db.iter_init(), true)
		@db.close()
	end
	
	def test_IterNext
		assert_equal(@db.iter_init(), true)
		@db.iter_next()
		@db.close()
	end

	def test_Name
		assert_equal(@db.name(), 'casket')
		@db.close()
	end
	
	def test_DocNum
		assert_equal(@db.doc_num(), 1)
		@db.close()
	end

	def test_WordNum
		assert_equal(@db.word_num(), 1)
		@db.close()
	end

	def test_Size
		assert(@db.size()>0)
		@db.close()
	end
	
	def test_Search
		cond = HyperEstraier::Condition.new()
		cond.set_phrase('foo')
		assert_not_equal(@db.search(cond, 0).to_a.length, 0)
		@db.close()
	end

	def test_SetCacheSize
		@db.set_cache_size(100, 100, 100)
		@db.close()
	end
	
	def test_SetSpecialCache
		@db.set_special_cache('hoge', 100)
		@db.close()
	end
end
