%module HyperEstraier

%include exception.i
%include "stl.i"

%exception {
	try {
		$action
	} catch (const char *msg) {
		SWIG_exception(SWIG_RuntimeError, msg);
	}
}

namespace std {
	%template(StrVector)	vector<string>;
	%template(IntVector)	vector<int>;
	%template()				pair<string,string>;
	%template(StrStrMap)	map<string,string>;
};

%newobject Document::get_dump_draft();
%newobject Document::get_attr_names();
%newobject Database::search();
%newobject Database::etch_doc();
%newobject Document::make_snippet();
%newobject Document::texts();

%{
#include "HyperEstraierWrapper.cpp"
%}

%include "HyperEstraierWrapper.cpp"
