/*
 * Decompiled with CFR 0.152.
 */
package jnt.scimark2;

public class Stopwatch {
    private boolean running;
    private double last_time;
    private double total;

    public Stopwatch() {
        this.reset();
    }

    public double read() {
        if (this.running) {
            this.total += Stopwatch.seconds() - this.last_time;
            this.last_time = Stopwatch.seconds();
        }
        return this.total;
    }

    public void reset() {
        this.running = false;
        this.last_time = 0.0;
        this.total = 0.0;
    }

    public void resume() {
        if (!this.running) {
            this.last_time = Stopwatch.seconds();
            this.running = true;
        }
    }

    public static final double seconds() {
        return (double)System.currentTimeMillis() * 0.001;
    }

    public void start() {
        if (!this.running) {
            this.running = true;
            this.total = 0.0;
            this.last_time = Stopwatch.seconds();
        }
    }

    public double stop() {
        if (this.running) {
            this.total += Stopwatch.seconds() - this.last_time;
            this.running = false;
        }
        return this.total;
    }
}

