/***************************************************************
 *
 * Copyright (C) 1990-2007, Condor Team, Computer Sciences Department,
 * University of Wisconsin-Madison, WI.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you
 * may not use this file except in compliance with the License.  You may
 * obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ***************************************************************/


#ifndef _CONDOR_FSYNC_H
#define _CONDOR_FSYNC_H

/*
 * Conditionally fsyncs/fdatasyncs based on configuration knob.
 * path parameter is currently not used but may be used
 * in the future to further conditionalize fsyncs based
 * on location of file.
 */
int condor_fsync( int fd, const char* path = NULL );
int condor_fdatasync( int fd, const char* path = NULL );

#endif 
