module Data.List.HT (
   -- * Improved standard functions
   L.inits,
   L.tails,
   L.groupBy,
   L.group,
   L.unzip,
   L.partition,
   L.span,
   L.break,
   -- * Split
   L.chop,
   L.breakAfter,
   L.segmentAfter,
   L.segmentBefore,
   L.removeEach,
   L.splitEverywhere,
   --  * inspect ends of a list
   L.splitLast,
   L.viewL,
   L.viewR,
   L.switchL,
   L.switchR,
   -- * List processing starting at the end
   L.dropWhileRev,
   L.takeWhileRev,
   -- * List processing with Maybe and Either
   L.maybePrefixOf,
   L.partitionMaybe,
   L.takeWhileJust,
   L.unzipEithers,
   -- * Sieve and slice
   L.sieve,
   L.sliceHorizontal,
   L.sliceVertical,
   -- * Search&replace
   L.search,
   L.replace,
   L.multiReplace,
   -- * Lists of lists
   L.shear,
   L.shearTranspose,
   L.outerProduct,
   -- * Miscellaneous
   L.takeWhileMulti,
   L.rotate,
   L.mergeBy,
   L.allEqual,
   L.isAscending,
   L.isAscendingLazy,
   L.mapAdjacent,
   L.range,
   L.padLeft,
   L.padRight,
   L.iterateAssociative,
   L.iterateLeaky,
   L.lengthAtLeast,
   ) where

import qualified Data.List.HT.Private as L
