{-# OPTIONS -cpp #-}
--
-- Copyright (c) 2004 Don Stewart - http://www.cse.unsw.edu.au/~dons
-- GPL version 2 or later (see http://www.gnu.org/copyleft/gpl.html)
--

import Eval.Haskell
import System.Exit              ( ExitCode(..), exitWith )
import System.IO
import System.Posix.Resource

rlimit = ResourceLimit 10

context = dataB ++ ghcB

dataB = map (\x -> "Data."++ x) [
        "Array", "Bits", "Bool", "Char", "Complex", "Dynamic", "Either", 
        "Generics", "Graph", "HashTable", "IORef", "Int", 
        "Ix", "List", "Maybe", "Monoid", "PackedString", "Ratio", "STRef", 
        "Set", "Tree", "Tuple", "Typeable", "Unique", "Word" 
#if __GLASGOW_HASKELL__ < 604
        ,"FiniteMap"
#else
        ,"Map"
#endif
        ]

ghcB = map (\x -> "GHC."++ x) [
        "Arr", "Base", "Enum", "Exts", "Float", "Int", "List", "Num", 
        "PArr", "Read", "Real", "ST", "STRef", "Show", "Unicode", "Word"
        ]

main = do
        setResourceLimit ResourceCPUTime (ResourceLimits rlimit rlimit)
        s <- getContents
        when (not . null $ s) $ do
                s <- unsafeEval ("show $ "++s) context
                when (isJust s) (putStrLn (fromJust s))
        exitWith ExitSuccess

