import Text.CSV.ByteString
import Data.ByteString.Lex.Double

import Data.Maybe
import Data.List
import System.Environment
import qualified Data.ByteString as S

-- input of form
-- "IG2 US,43,45,NULL,2007-09-28 00:00:00,2007-09-28 16:32:00"

data T = T !Double
           !Double
           !Time
           !Time

type Time = S.ByteString

ppr (T a b _ _) = print (a,b)

main = do
    [f] <- getArgs
    r <- parseCSV `fmap` S.readFile f
    case r of
         Nothing  -> error "unable to parse file"
         Just csv -> mapM_ ppr [ T (parse a) (parse b) c d | [_,a,b,_,c,d] <- csv ]

 where
    parse = fst . fromJust . readDouble
