## incomestatement

(is)

This command displays an
[income statement](http://en.wikipedia.org/wiki/Income_statement), 
showing revenues and expenses during one or more periods. 
Amounts are shown with normal positive sign, as in conventional
financial statements.

_FLAGS

This report shows accounts declared with the `Revenue` or `Expense` type
(see [account types](https://hledger.org/hledger.html#account-types)).
Or if no such accounts are declared, it shows top-level accounts named
`revenue` or `income` or `expense` (case insensitive, plurals allowed) and their subaccounts.

Example:
```cli
$ hledger incomestatement
Income Statement 2008

                   || 2008 
===================++======
 Revenues          ||      
-------------------++------
 income:gifts      ||   $1 
 income:salary     ||   $1 
-------------------++------
                   ||   $2 
===================++======
 Expenses          ||      
-------------------++------
 expenses:food     ||   $1 
 expenses:supplies ||   $1 
-------------------++------
                   ||   $2 
===================++======
 Net:              ||    0 
```

This command is a higher-level variant of the [`balance`](#balance) command,
and supports many of that command's features, such as multi-period reports.
It is similar to `hledger balance '(revenues|income)' expenses`,
but with smarter account detection, and revenues/income displayed with
their sign flipped.

This command also supports the
[output destination](hledger.html#output-destination) and
[output format](hledger.html#output-format) options
The output formats supported are
`txt`, `csv`, `tsv` (*Added in 1.32*), `html`, and `json`.
