## balancesheetequity

(bse)

This command displays a [balance sheet](https://en.wikipedia.org/wiki/Balance_sheet), 
showing historical ending balances of asset, liability and equity accounts.
Amounts are shown with normal positive sign, as in conventional
financial statements.

_FLAGS

This report shows accounts declared with the `Asset`, `Cash`, `Liability` or `Equity` type
(see [account types](https://hledger.org/hledger.html#account-types)).
Or if no such accounts are declared, it shows top-level accounts named
`asset`, `liability` or `equity` (case insensitive, plurals allowed) and their subaccounts.

Example:
```cli
$ hledger balancesheetequity
Balance Sheet With Equity 2008-12-31

                    || 2008-12-31 
====================++============
 Assets             ||            
--------------------++------------
 assets:bank:saving ||         $1 
 assets:cash        ||        $-2 
--------------------++------------
                    ||        $-1 
====================++============
 Liabilities        ||            
--------------------++------------
 liabilities:debts  ||        $-1 
--------------------++------------
                    ||        $-1 
====================++============
 Equity             ||            
--------------------++------------
--------------------++------------
                    ||          0 
====================++============
 Net:               ||          0 
```

This command is a higher-level variant of the [`balance`](#balance) command,
and supports many of that command's features, such as multi-period reports.
It is similar to `hledger balance -H assets liabilities equity`,
but with smarter account detection, and liabilities/equity displayed with
their sign flipped.

This report is the easiest way to see if the [accounting equation] (A+L+E = 0) is satisfied
(after you have done a [`close --retain`](#close---retain) to merge revenues and expenses with equity,
and perhaps added [`--infer-equity`](#inferring-equity-conversion-postings) to balance your commodity conversions).

This command also supports the
[output destination](hledger.html#output-destination) and
[output format](hledger.html#output-format) options
The output formats supported are
`txt`, `csv`, `tsv`, `html`, and `json`.

[accounting equation]: https://plaintextaccounting.org/FAQ#what-is-the-accounting-equation