<!--
       _              _             _            
  __ _| |__  _ __ ___| |_ __   ___ | |_ ___  ___ 
 / _` | '_ \| '__/ _ \ | '_ \ / _ \| __/ _ \/ __|
| (_| | | | | | |  __/ | | | | (_) | ||  __/\__ \
 \__, |_| |_|_|  \___|_|_| |_|\___/ \__\___||___/
 |___/                                           

-->
<details>
<summary>

## Release notes (https://hledger.org/release-notes.html#2024-04-18-hledger-133)

</summary>

### hledger 1.33

Breaking changes

- `expr:` boolean queries, introduced in hledger 1.30 (2023),
  no longer allow `date:` to be used within an `OR` expression,
  avoiding unclear semantics which confuse our reports.
  If you'd like to improve this, see #2178. [#2177] [#2178]

- Some error messages (date parse errors, balance assertion failures) have changed,
  which might affect error-parsing add-ons like flycheck-hledger.



Fixes

- `add`, `import`, `web`:
  On MS Windows, don't allow writing to files whose name ends with a period,
  since it can cause data loss; raise an error instead.
  I made this change in hledger 1.15 (2019), but it never worked; now it does.
  [#1056]

- `balance --budget`:
  The budget report in tree mode was omitting parent accounts with no actual or goal amounts
  and a single child, instead of showing them as a prefix of the child's name.
  Now it always shows them, on a line of their own (a bit like `--no-elide`).
  It's not a perfect fix, but the budget report code is twisty.
  [#2071]

- `check tags`:
  The special `date` and `date2` tags,
  and the `modified` and `_modified` tags generated by `--auto`,
  are now also implicitly declared.
  [#2148], [#2119]

- Regular expression match group references in CSV `if` rules,
  added in hledger 1.32, did not work right when multiple if conditions matched a CSV record.
  This is now fixed; match group references are now scoped to their local `if` block.
  [#2158] (Jonathan Dowland)

- `roi` now correctly interacts with `--value`.
  [#2190] (Dmitry Astapov)

- hledger now requires process-1.6.19.0+ to avoid any vulnerabilities on Windows from
  [HSEC-2024-0003](https://haskell.github.io/security-advisories/advisory/HSEC-2024-0003.html).



Features

- `close` has had some enhancements for usability ([#2151]):

  - It now excludes equity accounts by default; and always excludes the balancing account.

  - It has new `--assert` and `--assign` modes, for generating transactions which
    make balance assertions or balance assignments.
    There is also a `--assertion-type` option for changing the assertion/assignment type.

  - It adds a tag to generated transactions, named `start`, `assert` or `retain`
    depending on the mode.

  - The `start` tag's value will be a guess of the new file's name,
    inferred by incrementing a year number in the current file name.
    Eg, `hledger close --migrate` on `2024.journal` will add the tag
    `start:2025.journal` to both transactions.
    Tags like this can be helpful when reading multiple files,
    for excluding closing and opening balances transactions
    (eg with `not:tag:start=2025`).

  - You can set different tag values by writing the mode option with an argument.
    Eg: `hledger close --migrate=NEWFILENAME`.

  - `close` now supports `--round` for controlling display of decimal places, like `print`.

  - `examples/multi-year/` is examples/tutorial for managing multiple files with the `close` command.



Improvements

- `stats` has had some improvements:

  - It now also shows some information about memory usage, when hledger is built or is running
    with the GHC Run Time System available. (Try `hledger stats +RTS -T`.)

  - The default output is now more private, hiding file paths and commodity symbols.
    Those can be added by the new `-v/--verbose` flag.

  - Output is now more compact and more likely to fit in 80-character lines.

  - When generating multiple outputs with a report interval, reports are now
    separated by an empty line.

- Several more kinds of Unicode space are allowed for separating digit groups in numbers.
  We now support (my guess of the ones that might show up in real world CSV files):
  space,
  no-break space,
  en space,
  em space,
  punctuation space,
  thin space,
  narrow no-break space,
  medium mathematical space.

- Glob patterns in `$LEDGER_FILE` are now respected.
  Eg, setting it to `*.journal'` or `2???.journal` now works as expected.

- When hledger is reading a symbolically-linked journal file,
  relative paths in include directives are now evaluated
  relative to the directory of the real linked file,
  not the directory containing the symbolic link.

- Date parse errors are now simpler and clearer.
  They no longer try to repeat (a reconstruction of) the problem date,
  since the actual problem date is already visible in the highlighted file excerpt.

- Balance assertion error messages are clearer,
  and show the difference between expected and actual balance again.
  With --debug=2 they also show costs.

- `tsv:` and `ssv:` file name prefixes are now supported in addition to `csv:`.
  They force the file to be read as a .tsv (tab separated values) or .ssv (semicolon-separated values) file.
  [#2164] (Michael Rees)

- In CSV rules files, commented lines are now allowed within "if tables". (Dmitry Astapov)

- `balance --budget`'s CSV and TSV output now shows zeroes instead of nothing when there's no amount.

- `bs`,`bse`,`cf`,`is`:
  Report sections which are empty now show zero as their subtotal. (aragaer)

- `print` and `close` add a trailing decimal mark when needed to disambiguate a single digit group mark.
  They now also do this for balance assertion and balance assignment amounts.
  [#2176]

- hledger can now be built with GHC 9.8.

- hledger now requires safe >=0.3.20.



Docs

- add version annotations for features added in 1.32 (hamzashezad)
- add Text encoding section, mention UTF-8 BOM support [#2189]
- journal: note that `payee` and `tag` directives can't have tags in comments, unlike `account`.
- journal: clarify how auto postings work.
- journal: list built-in special tag names
- journal: description/payee/note: clarify
- journal: amounts/commodities/numbers: cleanups
- journal: move intro before cheatsheet
- journal: transactions: explain transaction balancing [#2135]
- journal: transactions: mention debits, credits and sign
- journal: commodity directive: clarify & fix scope of effects [#2135]
- journal: D directive: clarify scope [#2191]
- journal: split Decimal marks, Digit group marks
- journal: move complex commodity styles, lot notation topics later
- journal: drop redundant/wrong Querying with cost or value section
- journal: cheatsheet: cleanups
- journal: assertions and ordering/commodities/subaccounts: cleanups
- csv: matchers: clarify, mention !/& limitation [#2088]
- csv: if tables: explain comments and order of application (Dmitry Astapov)
- add: document the effect of D default commodity directive [#815]
- balance: cleanups
- balance: budget report: moved "Budgets and subaccounts" to the Cookbook.
- bs,bse,cf,is: update sample output
- bse: note requirements for checking the accounting equation
- close: rewrite, give a better technique for excluding opening/closing balance txns [#2151]
- import: rename "deduplication" to "skipping", and rewrite
- examples: expand READMEs, clarify status for examples
- examples: invoicing: cleanups, renames
- examples: invoicing: pandoc-make-invoice: don't write to $LEDGER_FILE; remove the REMOVE THIS LINE line
- examples: csv: daedalus-transactions: update for current daedalus [#2171]



Scripts/addons

- hledger-bar, hledger-simplebal: shellcheck fixes, cleanups (Colin Dean)

- hledger-bar: Fix an error when NO_COLOR is not defined [#2159].
  Also, it's now more compliant with the no-color.org spec:

    Command-line software which adds ANSI color to its output by default
    should check for a NO_COLOR environment variable that, when present
    and not an empty string (regardless of its value), prevents the
    addition of ANSI color.

  so one can now temporarily override $NO_COLOR=1 in the environment by
  setting it empty: NO_COLOR= hledger ...

- hledger-txnsbycat: added



[#2191]: https://github.com/simonmichael/issue/2191
[#2190]: https://github.com/simonmichael/issue/2190
[#2189]: https://github.com/simonmichael/issue/2189
[#2178]: https://github.com/simonmichael/issue/2178
[#2177]: https://github.com/simonmichael/issue/2177
[#2176]: https://github.com/simonmichael/issue/2176
[#2164]: https://github.com/simonmichael/issue/2164
[#2151]: https://github.com/simonmichael/issue/2151
[#2135]: https://github.com/simonmichael/issue/2135
[#2088]: https://github.com/simonmichael/issue/2088
[#2071]: https://github.com/simonmichael/issue/2071
[#1056]: https://github.com/simonmichael/issue/1056
[#815]:  https://github.com/simonmichael/issue/815



### hledger-ui 1.33

Fixes

- Require process 1.6.19.0+ to avoid any vulnerabilities on Windows from
  [HSEC-2024-0003](https://haskell.github.io/security-advisories/advisory/HSEC-2024-0003.html).

Features

- Add a `dark` theme. (Jonathan Dowland)

Improvements

- Allow building with GHC 9.8.

- Require safe >=0.3.20.



### hledger-web 1.33

Fixes

- Exclude base64 >=1.0 to avoid compilation failure. [#2166]

- Preserve line breaks when showing an error message. [#2163] (Martijn van der Ven)

Improvements

- Zero amounts are now shown with their commodity symbol.
  This was mainly to make the sidebar more informative,
  but also affects and hopefully helps amounts displayed elsewhere.
  [#2140]

- Amounts in the sidebar now also have the `amount` HTML class.

- Allow building with GHC 9.8.

- Require safe >=0.3.20.

Docs

- Mention the `-E/--empty` flag for hiding zeros,
  the non-display of costs,
  and non-zeros that look like zero because of hidden costs.



### project changes 1.33

Misc

- Apple ARM binaries are now included in github releases.

Docs

- REGRESSIONS: we now split the bounty between finder and fixer
- move Developer docs, MOCKUPS, investment-accounting-features to main repo
- merge LINKS into dev docs page; cleanup
- drop unused BACKLOG, TODO pages



### credits 1.33

Simon Michael,
Jonathan Dowland, 
Ilja Kocken, 
Colin Dean, 
Dmitry Astapov, 
Vekhir,
ShrykeWindgrace, 
Martijn van der Ven, 
Michael Rees, 
aragaer, 
hamzashezad.



</details>

## Install

At <https://hledger.org/install>, binary packages should be available for this release within a few days (look for green badges). 

Or, you can build from source as described there, after cloning at tag `1.33`:
`git clone https://github.com/simonmichael/hledger --depth 1 -b 1.33`

Or, if under "Assets" below there are release binaries suitable for your OS and hardware, you can use those.
<!--
Note: release binaries have been updated:
- YYYY-MM-DD: description. [#NNNN](https://github.com/simonmichael/hledger/issues/NNNN)
-->
Here are platform-specific instructions for the release binaries.
(You can copy & paste each block of commands as a unit to save time.):

<details>
<summary>

### GNU/Linux on 64-bit Intel

</summary>

At the command line,

```
cd /usr/local/bin
curl -LOC- https://github.com/simonmichael/hledger/releases/download/1.33/hledger-linux-x64.zip   # can rerun if interrupted
unzip hledger-linux-x64.zip; tar xvf hledger-linux-x64.tar; rm hledger-linux-x64.{zip,tar}        # github workaround, preserves permissions
cd -
hledger --version  # should show the new version
touch $HOME/.hledger.journal   # ensure a default journal file exists
```

</details>

<details>
<summary>

### Mac on 64-bit Intel

</summary>

In a terminal window,

```
cd /usr/local/bin
curl -LOC- https://github.com/simonmichael/hledger/releases/download/1.33/hledger-mac-x64.zip
unzip hledger-mac-x64.zip; tar xvf hledger-mac-x64.tar; rm hledger-mac-x64.{zip,tar}              # github workaround, preserves permissions
open .
# for the hledger, hledger-ui, hledger-web icons: right-click, Open, confirm it's ok to run
cd -
hledger --version  # should show the new version
touch $HOME/.hledger.journal   # ensure a default journal file exists
```

</details>

<details>
<summary>

### Windows 64-bit Intel (or ARM, using emulation)

</summary>

In a powershell window (press Windows-r, type powershell, press enter),

1. Make a place to keep hledger binaries, and add it to your PATH; this makes running hledger easier. You only need to do this once, not for every release:
```
mkdir -force $HOME\bin >$null
$ENV:PATH += ";"+$HOME+"\bin"
[Environment]::SetEnvironmentVariable("Path", [Environment]::GetEnvironmentVariable("Path", [EnvironmentVariableTarget]::User)+";"+$HOME+"\bin", [EnvironmentVariableTarget]::User)
```

2. Download and install the release binaries:
```
cd $HOME\bin
curl https://github.com/simonmichael/hledger/releases/download/1.33/hledger-windows-x64.zip -OutFile hledger-windows-x64.zip
Expand-Archive hledger-windows-x64.zip -DestinationPath .
rm hledger-windows-x64.zip
cd $HOME
hledger --version           # should show the new version
```

3. Ensure a default journal file exists, and without a problematic encoding. 
(Not sure why "ascii" is needed here - hledger likes utf8 and understands utf8 BOM headers..
but the state of [our unicode support on Windows](https://github.com/simonmichael/hledger/issues?q=is%3Aissue+label%3A%22platform%3A+windows%22+label%3Ai18n)
is really unknown, your input welcome.)
```
out-file -append -encoding ascii $HOME/.hledger.journal
```

Once that journal file exists, you can start hledger-web by double-clicking on the icon if you wish.

</details>

<details>
<summary>

### Windows 7 on 64-bit Intel

</summary>

- click hledger-windows-x64.zip below
- choose Open with Windows Explorer, OK
- click Extract all files
- choose a destination folder - ideally one that appears in `echo %PATH%`, like `C:\Windows` (though that one will require administrator permission); otherwise, your home directory (`C:\Users\YOURNAME`)
- check "Show extracted files when complete"
- click Extract, wait for the destination folder to open
- find the hledger, hledger-web icons (if you extracted to `\Windows`, you'll need to scroll down)
- for each icon: double-click, uncheck "Always ask before opening this file", click Run
- close those Explorer windows
- open a command window (press Windows-r, type CMD, press enter)
- `hledger --version` should show the new version
- `echo # >> .hledger.journal` to ensure a default journal file exists. (Important: the doubled **>>** is needed to avoid overwriting existing data.)

Problems:
- Starting hledger by double-clicking its icon won't work because it needs arguments; run it from the command window instead.
- Starting hledger-web by double-clicking its icon may fail eg because Explorer's command window is too small;
  configure that to be larger, or run hledger-web from a command window instead.
- hledger or hledger-web may fail to run if there is not enough memory available.

</details>

## Next steps

- https://hledger.org/#quick-start

<!-- ## Updates -->
<!-- 2022-06-08: windows-x64 binaries fixed. [#1869](https://github.com/simonmichael/hledger/issues/1869) -->
