# Contributor Quick Start

<div class=pagetoc>

<!-- toc -->
</div>

New contributors are always welcome in the hledger project. Jump in!
Browse the ideas below, or say hello in the chat and we'll help find you a job.

## First steps

- Join the [#hledger chat](support.md), best place for quick help and feedback
- Skim the [FAQs](faq.md)

## Ideas for contributing as a ...

### Visitor

- Give feedback on the site and your impressions of the project

### New user

- Give feedback on your new user experience

### Developer

- See the [Developer workflows](DEVWORKFLOWS.md) 
- and other [Developer docs](dev.md)

### Developer using the hledger libraries

- Give feedback on your experience using the hledger packages
- Suggest API improvements

### Packager

- Improve hledger's packaging on one or more platforms

### Communicator

Marketing and market understanding is vital.

- clarify project goals, value proposition, brand, mission, story
- monitor product-market fit
- identify new opportunities
- influence developer priorities
- spread the word!

### Funder

Become a financial backer to
sustain and grow this project,
increase your influence,
express gratitude,
build prosperity consciousness,
and help transform world finance!

- Use the donate links on the [home page](https://hledger.org)
- Configure a recurring donation
- Contribute or pledge bounties on issues you care about
- Ask your organization to contribute
- Work on project sustainability, accountability, fundraising

### Tester

- Test installation on platforms you have access to
- Test examples, advice, and links in the docs
- Run the latest release or developer build in daily use
- Run [tests](#run-package-tests)
- Run [benchmarks](#run-package-benchmarks)
- Report packaging, documentation, UX, functional, performance issues
- Report and help analyse problems via irc/mail list/bug tracker

When reporting bugs, don't forget to search the tracker for a similar bug report.
Otherwise, open a new bug by clicking "New issue", or <http://bugs.hledger.org/new>.

Enhancement requests are sometimes added to the tracker,but for these consider using
the IRC channel and mail list (see [Getting help](index.md#getting-help)).
Both are archived and linkable, so the idea won't be lost.
There is also a collection of wishes at the old [trello board](http://trello.hledger.org).

### Bug wrangler

### Tech support provider

### Technical Writer

- get familiar with the website and documentation online, review and test
- get familiar with the site/doc source files (see [Shake.hs](#shake))
- get the latest hledger source
- send patches with names prefixed with "doc: " (or "site: ")

### Graphics Designer

- more/better logos & graphics
- illustrations and diagrams
- web design mockups for home page, site, hledger-web UI

<!-- ### Product Designer -->

### Maintainer

#### Help with issue management

- watch tracker activity, report status
- apply/update labels where needed
- follow up on dormant issues
- facilitate a consistently good bug-reporting & PR-contributing experience

#### Help with packaging

- package hledger for linux distros, macports, etc.
- develop mac/windows installers
- find and assist distro packagers/installer developers

#### Help with project management

- clarify/update goals and principles
- monitor, report on project progress and performance
- research, compare and report on successful projects, related projects
- identify collaboration opportunities
- marketing, communication, outreach
- release management, roadmap planning
