# REGRESSIONS

<div class=pagetoc>

<!-- toc -->
</div>

Short url for this page: [hledger.org/regressions](https://hledger.org/regressions)

A regression is "something that used to work, that broke", or "an unintended not-good change"
in a released version of hledger.

We don't like regressions. We want to detect them quickly, repair them quickly, and reduce their frequency.

## Regression bounty

You can help!
We offer a standard bounty ($100 USD) for each new regression reported in hledger releases.
([original discussion](https://github.com/simonmichael/hledger/issues/1570)).
To claim the bounty:

1. Discover a new regression yourself (and don't be the one who caused it, generally)
2. Report it in the [hledger bug tracker](http://bugs.hledger.org)
3. Wait for the issue manager ([SM](https://joyful.com)) to apply the REGRESSION label
4. Submit an expense to our Open Collective. (Note: this might reveal your real name, on opencollective.com and here on hledger.org):
   - [Submit Expense](https://opencollective.com/hledger/expenses/new)
     (if you are logged in, it will be under the ACTIONS menu) 
   - choose Invoice
   - choose a Payout method; Next
   - Expense title: Regression bounty for #NNNN
   - Description: "QA", and the WORK DATE or WORK PERIOD
   - Date: today's date
   - Amount: USD 100
     (or if you choose another currency, convert with that day's conversion rate
      and mention the rate in Description)
   - Next; Submit Expense
5. Announce on the issue page or in chat that you've submitted (to help ensure it is not overlooked)
6. Wait for the finance manager (SM) to approve it. This should not take more than a day or two.
7. Then wait for Open Collective to pay it. Payouts happen twice a week.

## Regressions reported

| By                                                                    | Issue                                                        | Bounty paid |
|-----------------------------------------------------------------------|--------------------------------------------------------------|-------------|
| **2021**                                                              |                                                              |             |
| [Simon Michael](https://opencollective.com/hledger/expenses/44939)    | [#1597](https://github.com/simonmichael/hledger/issues/1597) | 2021-07-08  |
| [Simon Michael](https://opencollective.com/hledger/expenses/45547)    | [#1607](https://github.com/simonmichael/hledger/issues/1607) | 2021-07-16  |
| [Julian Klode](https://opencollective.com/hledger/expenses/46431)     | [#1625](https://github.com/simonmichael/hledger/issues/1625) | 2021-07-30  |
| [Yann Büchau](https://opencollective.com/hledger/expenses/46918)      | [#1638](https://github.com/simonmichael/hledger/issues/1638) | 2021-08-03  |
| [Stephen Morgan](https://opencollective.com/hledger/expenses/48246)   | [#1656](https://github.com/simonmichael/hledger/issues/1656) | 2021-08-22  |
| [David Lowe](https://opencollective.com/hledger/expenses/50380)       | [#1698](https://github.com/simonmichael/hledger/issues/1698) | 2021-09-18  |
| [Arne Schlüter](https://opencollective.com/hledger/expenses/54446)    | [#1745](https://github.com/simonmichael/hledger/issues/1745) | 2021-11-02  |
| [Romain Gehrig](https://opencollective.com/hledger/expenses/55510)    | [#1736](https://github.com/simonmichael/hledger/issues/1736) | 2021-11-14  |
| **2022**                                                              |                                                              |             |
| [Chuck Holmes](https://opencollective.com/hledger/expenses/61802)     | [#1800](https://github.com/simonmichael/hledger/issues/1800) | 2022-01-21  |
| [Eric Langlois](https://opencollective.com/hledger/expenses/72187)    | [#1851](https://github.com/simonmichael/hledger/issues/1851) | 2022-04-11  |
| [Simon Michael](https://opencollective.com/hledger/expenses/95068)    | [#1933](https://github.com/simonmichael/hledger/issues/1933) | 2022-09-14  |
| [Andras Fabian](https://opencollective.com/hledger/expenses/95112)    | [#1932](https://github.com/simonmichael/hledger/issues/1932) | 2022-09-15  |
| **2023**                                                              |                                                              |             |
| [Allan Odgaard](https://opencollective.com/hledger/expenses/130591)   | [#2018](https://github.com/simonmichael/hledger/issues/2018) | 2023-03-28  |
| [Pablo Mora](https://opencollective.com/hledger/expenses/131350)      | [#2020](https://github.com/simonmichael/hledger/issues/2020) | 2023-03-31  |
| [Simon Michael](https://opencollective.com/hledger/expenses/132635)   | [#2023](https://github.com/simonmichael/hledger/issues/2023) | 2023-04-06  |
| [Simon Michael](https://opencollective.com/hledger/expenses/137410)   | [#2032](https://github.com/simonmichael/hledger/issues/2032) | 2023-05-03  |
| Simon Michael                                                         | [#2034](https://github.com/simonmichael/hledger/issues/2034) | -           |
| [Pranesh Prakash](https://opencollective.com/hledger/expenses/150171) | [#2045](https://github.com/simonmichael/hledger/issues/2045) | 2023-10-17  |
| [Petr Slansky](https://opencollective.com/hledger/expenses/166632)    | [#2091](https://github.com/simonmichael/hledger/issues/2091) | 2023-10-16  |
| pepe_pecas[](https://opencollective.com/hledger/expenses/?)           | [#2115](https://github.com/simonmichael/hledger/issues/2115) |             |
| Simon Michael                                                         | [#2125](https://github.com/simonmichael/hledger/issues/2125) | -           |
|                                                                       |                                                              |             |


All regression issues: [bugs.hledger.org/regressions](https://bugs.hledger.org/regressions)


## Regression bounty payments

<https://opencollective.com/hledger/transactions?kind=EXPENSE&amount=50-500>

