#!/bin/sh
cat EXAMPLES | \
grep -v '^export HIST' | \
gawk '

     /^expo/ { print "<td><img src=",$2,"/></td>" }  
     /^rm/   { print "<td><pre>" ,$0, "</pre></td>" }
     /^$/    { print "</tr><tr>" }

     BEGIN   { 
     print "<html><body><p>Some of the examples need an input stream of (approximately) normally distributed random numbers.  Here is an example of a script able to generate such a stream:</p><p><pre>";
     print "cat &lt;&lt; EOF > ./normalDist.sh";
     print "#!/bin/sh";
     print "gawk €function gaussian() { tot=0; num=20;for(i=0; i&lt;num; ++i) { tot+=(2.*rand()-1)}; return tot*sqrt(3./num) }  BEGIN{while (1==1) {print gaussian()}}€";
     print "EOF";
     print "";
     print "chmod +x ./normalDist.sh";
     print "</pre><table><tr>";
}
     END     { print "</tr></table></body></html>" }

' | \
sed 's/ FILE=\(.*png\)/"\1"/g' | \
sed 's/rm -f \$FILE ; //g' | \
sed 's/\$FILE/out.png/g' | \
sed 's/ ; display out.png//g' | \
sed 's/ quit//g' | \
tr € \' | \
cat > examplesFragment.html

scp *.png examplesFragment.html lester@pclu:/usera/lester/public_html/hist/
ssh lester@pclu chmod a+r /usera/lester/public_html/hist/*.png
