package org.hibernate.envers.test.integration.naming;

import javax.persistence.EntityManager;

import ee.estonia.entities.Child;
import ee.estonia.entities.Parent;
import org.junit.Assert;
import org.junit.Test;

import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.envers.test.AbstractEntityTest;
import org.hibernate.envers.test.Priority;
import org.hibernate.envers.test.tools.TestTools;
import org.hibernate.testing.TestForIssue;

/**
 * @author Lukasz Antoniak (lukasz dot antoniak at gmail dot com)
 */
@TestForIssue(jiraKey = "HHH-6738")
public class EstonianTableAlias extends AbstractEntityTest {
    private Long parentId = null;
    private Long childId = null;

    public void configure(Ejb3Configuration cfg) {
        cfg.addAnnotatedClass(Parent.class);
        cfg.addAnnotatedClass(Child.class);
    }

    @Test
    @Priority(10)
    public void initData() {
        EntityManager em = getEntityManager();

        // Revision 1
        em.getTransaction().begin();
        Parent parent = new Parent("parent");
        Child child = new Child("child");
        parent.getCollection().add(child);
        em.persist(child);
        em.persist(parent);
        em.getTransaction().commit();

        parentId = parent.getId();
        childId = child.getId();
    }

    @Test
    public void testAuditChildTableAlias() {
        Parent parent = new Parent("parent", parentId);
        Child child = new Child("child", childId);

        Parent ver1 = getAuditReader().find(Parent.class, parentId, 1);

        Assert.assertEquals(parent, ver1);
        Assert.assertEquals(TestTools.makeSet(child), ver1.getCollection());
    }
}