/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.wrapper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;
import org.gradle.wrapper.BootstrapMainStarter;
import org.gradle.wrapper.Install;

public class Wrapper {
    public static final String WRAPPER_PROPERTIES_PROPERTY = "org.gradle.wrapper.properties";
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String DISTRIBUTION_BASE_PROPERTY = "distributionBase";
    public static final String ZIP_STORE_BASE_PROPERTY = "zipStoreBase";
    public static final String DISTRIBUTION_PATH_PROPERTY = "distributionPath";
    public static final String ZIP_STORE_PATH_PROPERTY = "zipStorePath";
    private final Properties properties;
    private final URI distribution;
    private final File propertiesFile;

    public Wrapper() {
        this(new File(System.getProperty(WRAPPER_PROPERTIES_PROPERTY)), new Properties());
    }

    public Wrapper(File projectDir) {
        this(new File(projectDir, "gradle/wrapper/gradle-wrapper.properties"), new Properties());
    }

    private Wrapper(File propertiesFile, Properties properties) {
        this.properties = properties;
        this.propertiesFile = propertiesFile;
        if (propertiesFile.exists()) {
            try {
                Wrapper.loadProperties(propertiesFile, properties);
                this.distribution = new URI(this.getProperty(DISTRIBUTION_URL_PROPERTY));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Could not load wrapper properties from '%s'.", propertiesFile), e);
            }
        } else {
            this.distribution = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(File propertiesFile, Properties properties) throws IOException {
        FileInputStream inStream = new FileInputStream(propertiesFile);
        try {
            properties.load(inStream);
        }
        finally {
            ((InputStream)inStream).close();
        }
    }

    public URI getDistribution() {
        return this.distribution;
    }

    public void execute(String[] args, Install install, BootstrapMainStarter bootstrapMainStarter) throws Exception {
        if (this.distribution == null) {
            throw new FileNotFoundException(String.format("Wrapper properties file '%s' does not exist.", this.propertiesFile));
        }
        File gradleHome = install.createDist(this.getDistribution(), this.getProperty(DISTRIBUTION_BASE_PROPERTY), this.getProperty(DISTRIBUTION_PATH_PROPERTY), this.getProperty(ZIP_STORE_BASE_PROPERTY), this.getProperty(ZIP_STORE_PATH_PROPERTY));
        bootstrapMainStarter.start(args, gradleHome);
    }

    private String getProperty(String propertyName) {
        String value = this.properties.getProperty(propertyName);
        if (value == null) {
            throw new RuntimeException(String.format("No value with key '%s' specified in wrapper properties file '%s'.", propertyName, this.propertiesFile));
        }
        return value;
    }
}

