/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.distexec.DistributedExecutionCompletionService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.marshall.Marshaller;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.FutureListener;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.infinispan.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DefaultExecutorService
extends AbstractExecutorService
implements DistributedExecutorService {
    private static final Log log = LogFactory.getLog(DefaultExecutorService.class);
    protected final AtomicBoolean isShutdown = new AtomicBoolean(false);
    protected final AdvancedCache cache;
    protected final RpcManager rpc;
    protected final InterceptorChain invoker;
    protected final CommandsFactory factory;
    protected final Marshaller marshaller;
    protected final ExecutorService localExecutorService;

    public DefaultExecutorService(Cache masterCacheNode) {
        this(masterCacheNode, new WithinThreadExecutor());
    }

    public DefaultExecutorService(Cache masterCacheNode, ExecutorService localExecutorService) {
        if (masterCacheNode == null) {
            throw new IllegalArgumentException("Can not use null cache for DefaultExecutorService");
        }
        if (localExecutorService == null) {
            throw new IllegalArgumentException("Can not use null instance of ExecutorService");
        }
        if (localExecutorService.isShutdown()) {
            throw new IllegalArgumentException("Can not use an instance of ExecutorService which is shutdown");
        }
        this.ensureProperCacheState(masterCacheNode.getAdvancedCache());
        this.cache = masterCacheNode.getAdvancedCache();
        ComponentRegistry registry = this.cache.getComponentRegistry();
        this.rpc = this.cache.getRpcManager();
        this.invoker = registry.getComponent(InterceptorChain.class);
        this.factory = registry.getComponent(CommandsFactory.class);
        this.marshaller = registry.getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        this.localExecutorService = localExecutorService;
    }

    public <T> NotifyingFuture<T> submit(Runnable task, T result) {
        return (NotifyingFuture)super.submit(task, result);
    }

    public <T> NotifyingFuture<T> submit(Callable<T> task) {
        return (NotifyingFuture)super.submit(task);
    }

    @Override
    public void shutdown() {
        this.realShutdown(false);
    }

    private List<Runnable> realShutdown(boolean interrupt) {
        this.isShutdown.set(true);
        this.localExecutorService.shutdownNow();
        return Collections.emptyList();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.realShutdown(true);
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown.get();
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown.get();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    private <T> T doInvokeAny(Collection<? extends Callable<T>> tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionException ee;
        ArrayList<Future<T>> futures;
        block18: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            int ntasks = tasks.size();
            if (ntasks == 0) {
                throw new IllegalArgumentException();
            }
            futures = new ArrayList<Future<T>>(ntasks);
            DistributedExecutionCompletionService<T> ecs = new DistributedExecutionCompletionService<T>(this);
            ee = null;
            long lastTime = timed ? System.nanoTime() : 0L;
            Iterator<Callable<T>> it = tasks.iterator();
            futures.add(ecs.submit(it.next()));
            --ntasks;
            int active = 1;
            while (true) {
                Object now22;
                Future f;
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit(it.next()));
                        ++active;
                    } else {
                        if (active == 0) break;
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now22 = System.nanoTime();
                            nanos -= now22 - lastTime;
                            lastTime = now22;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now22 = f.get();
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (ExecutionException eex) {
                    ee = eex;
                    continue;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                return (T)now22;
                break;
            }
            if (ee != null) break block18;
            ee = new ExecutionException(){
                private static final long serialVersionUID = 200818694545553992L;
            };
        }
        throw ee;
        finally {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(Runnable command) {
        DistributedRunnableFuture cmd;
        if (this.isShutdown.get()) throw new RejectedExecutionException();
        if (command instanceof DistributedRunnableFuture) {
            cmd = (DistributedRunnableFuture)command;
        } else {
            if (!(command instanceof Serializable)) throw new IllegalArgumentException("Runnable command is not Serializable  " + command);
            cmd = (DistributedRunnableFuture)this.newTaskFor(command, null);
        }
        this.executeFuture(this.selectExecutionNode(), cmd);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        DistributedExecuteCommand<T> executeCommand = this.factory.buildDistributedExecuteCommand(new RunnableAdapter<T>(runnable, value), this.rpc.getAddress(), null);
        return new DistributedRunnableFuture<T>(executeCommand);
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException();
        }
        DistributedExecuteCommand<T> executeCommand = this.factory.buildDistributedExecuteCommand(callable, this.rpc.getAddress(), null);
        return new DistributedRunnableFuture<T>(executeCommand);
    }

    @Override
    public <T, K> Future<T> submit(Callable<T> task, K ... input) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.inputKeysSpecified(input)) {
            Map<Address, List<K>> nodesKeysMap = this.mapKeysToNodes(input);
            Address me = this.rpc.getAddress();
            DistributedExecuteCommand<T> c = this.factory.buildDistributedExecuteCommand(task, me, Arrays.asList(input));
            DistributedRunnableFuture<T> f = new DistributedRunnableFuture<T>(c);
            ArrayList<Address> nodes = new ArrayList<Address>(nodesKeysMap.keySet());
            this.executeFuture(this.selectExecutionNode(nodes), f);
            return f;
        }
        return this.submit((Callable)task);
    }

    @Override
    public <T> List<Future<T>> submitEverywhere(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        List<Address> members = this.rpc.getTransport().getMembers();
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(members.size() - 1);
        Address me = this.rpc.getAddress();
        for (Address target : members) {
            DistributedExecuteCommand<T> c = null;
            c = target.equals(me) ? this.factory.buildDistributedExecuteCommand(this.clone(task), me, null) : this.factory.buildDistributedExecuteCommand(task, me, null);
            DistributedRunnableFuture<T> f = new DistributedRunnableFuture<T>(c);
            futures.add(f);
            this.executeFuture(target, f);
        }
        return futures;
    }

    @Override
    public <T, K> List<Future<T>> submitEverywhere(Callable<T> task, K ... input) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.inputKeysSpecified(input)) {
            ArrayList<Future<T>> futures = new ArrayList<Future<T>>(input.length * 2);
            Address me = this.rpc.getAddress();
            Map<Address, List<K>> nodesKeysMap = this.mapKeysToNodes(input);
            for (Map.Entry<Address, List<K>> e : nodesKeysMap.entrySet()) {
                Address target = e.getKey();
                DistributedExecuteCommand<T> c = null;
                c = target.equals(me) ? this.factory.buildDistributedExecuteCommand(this.clone(task), me, e.getValue()) : this.factory.buildDistributedExecuteCommand(task, me, e.getValue());
                DistributedRunnableFuture<T> f = new DistributedRunnableFuture<T>(c);
                futures.add(f);
                this.executeFuture(target, f);
            }
            return futures;
        }
        return this.submitEverywhere(task);
    }

    protected <T> Callable<T> clone(Callable<T> task) {
        return Util.cloneWithMarshaller(this.marshaller, task);
    }

    protected <T> void executeFuture(Address address, DistributedRunnableFuture<T> f) {
        if (this.rpc.getAddress().equals(address)) {
            this.invokeLocally(f);
        } else {
            log.tracef("Sending %s to remote execution at node %s", f, address);
            try {
                this.rpc.invokeRemotelyInFuture(Collections.singletonList(address), f.getCommand(), f);
            }
            catch (Throwable e) {
                log.remoteExecutionFailed(address, e);
            }
        }
    }

    private <K> boolean inputKeysSpecified(K ... input) {
        return input != null && input.length > 0;
    }

    protected <T> void invokeLocally(final DistributedRunnableFuture<T> future) {
        log.debugf("Sending %s to self", future);
        try {
            Callable<Object> call = new Callable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object call() throws Exception {
                    Object result = null;
                    future.getCommand().init(DefaultExecutorService.this.cache);
                    try {
                        result = future.getCommand().perform(null);
                        Map<Address, SuccessfulResponse> map = Collections.singletonMap(DefaultExecutorService.this.rpc.getAddress(), SuccessfulResponse.create(result));
                        return map;
                    }
                    catch (Throwable e) {
                        Throwable throwable = e;
                        return throwable;
                    }
                    finally {
                        future.notifyDone();
                    }
                }
            };
            FutureTask<Object> task = new FutureTask<Object>(call);
            future.setNetworkFuture((Future<T>)task);
            this.localExecutorService.submit(task);
        }
        catch (Throwable e1) {
            log.localExecutionFailed(e1);
        }
    }

    protected <K> Map<Address, List<K>> mapKeysToNodes(K ... input) {
        DistributionManager dm = this.cache.getDistributionManager();
        HashMap<Address, List<Address>> addressToKey = new HashMap<Address, List<Address>>(input.length * 2);
        boolean usingREPLMode = dm == null;
        ArrayList<Address> members = null;
        if (usingREPLMode) {
            members = new ArrayList<Address>(this.cache.getRpcManager().getTransport().getMembers());
        }
        for (K key : input) {
            Address ownerOfKey = null;
            if (usingREPLMode) {
                Collections.shuffle(members);
                ownerOfKey = (Address)members.get(0);
            } else {
                ownerOfKey = dm.getPrimaryLocation(key);
            }
            LinkedList<K> keysAtNode = (LinkedList<K>)addressToKey.get(ownerOfKey);
            if (keysAtNode == null) {
                keysAtNode = new LinkedList<K>();
                addressToKey.put(ownerOfKey, keysAtNode);
            }
            keysAtNode.add(key);
        }
        return addressToKey;
    }

    protected Address selectExecutionNode(List<Address> candidates) {
        List<Address> list = this.randomClusterMembers(candidates, 1);
        return list.get(0);
    }

    protected Address selectExecutionNode() {
        return this.selectExecutionNode(this.rpc.getTransport().getMembers());
    }

    protected List<Address> randomClusterMembers(List<Address> members, int numNeeded) {
        if (members == null || members.isEmpty()) {
            throw new IllegalArgumentException("Invalid member list " + members);
        }
        if (members.size() < numNeeded) {
            log.cannotSelectRandomMembers(numNeeded, members);
            numNeeded = members.size();
        }
        ArrayList<Address> membersCopy = new ArrayList<Address>(members);
        ArrayList<Address> chosen = new ArrayList<Address>(numNeeded);
        Random r = new Random();
        while (!membersCopy.isEmpty() && numNeeded >= chosen.size()) {
            int count = membersCopy.size();
            Address address = (Address)membersCopy.remove(r.nextInt(count));
            chosen.add(address);
        }
        return chosen;
    }

    private void ensureProperCacheState(AdvancedCache cache) throws NullPointerException, IllegalStateException {
        if (cache.getRpcManager() == null) {
            throw new IllegalStateException("Can not use non-clustered cache for DefaultExecutorService");
        }
        if (cache.getStatus() != ComponentStatus.RUNNING) {
            throw new IllegalStateException("Invalid cache state " + (Object)((Object)cache.getStatus()));
        }
    }

    private static final class RunnableAdapter<T>
    implements Callable<T>,
    Serializable {
        private static final long serialVersionUID = 6629286923873531028L;
        protected Runnable task;
        protected T result;

        protected RunnableAdapter() {
        }

        protected RunnableAdapter(Runnable task, T result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public T call() {
            this.task.run();
            return this.result;
        }
    }

    private static class DistributedRunnableFuture<V>
    implements RunnableFuture<V>,
    NotifyingNotifiableFuture<V> {
        private final DistributedExecuteCommand<V> distCommand;
        private volatile Future<V> f;
        private volatile boolean callCompleted = false;
        private final Set<FutureListener<V>> listeners = new CopyOnWriteArraySet<FutureListener<V>>();
        private final ReadWriteLock listenerLock = new ReentrantReadWriteLock();

        public DistributedRunnableFuture(DistributedExecuteCommand<V> command) {
            this.distCommand = command;
        }

        public DistributedExecuteCommand<V> getCommand() {
            return this.distCommand;
        }

        @Override
        public boolean isCancelled() {
            return this.f.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.f.isDone();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.f.cancel(mayInterruptIfRunning);
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            V response = this.f.get();
            return this.retrieveResult(response);
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            V response = this.f.get(timeout, unit);
            return this.retrieveResult(response);
        }

        @Override
        public void run() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyDone() {
            this.listenerLock.writeLock().lock();
            try {
                this.callCompleted = true;
                for (FutureListener<V> l : this.listeners) {
                    l.futureDone(this);
                }
            }
            finally {
                this.listenerLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NotifyingFuture<V> attachListener(FutureListener<V> listener) {
            this.listenerLock.readLock().lock();
            try {
                if (!this.callCompleted) {
                    this.listeners.add(listener);
                }
                if (this.callCompleted) {
                    listener.futureDone(this);
                }
                DistributedRunnableFuture distributedRunnableFuture = this;
                return distributedRunnableFuture;
            }
            finally {
                this.listenerLock.readLock().unlock();
            }
        }

        @Override
        public void setNetworkFuture(Future<V> future) {
            this.f = future;
        }

        private V retrieveResult(Object response) throws ExecutionException {
            if (response instanceof Exception) {
                throw new ExecutionException((Exception)response);
            }
            Map mapResult = (Map)response;
            for (Map.Entry e : mapResult.entrySet()) {
                if (!(e.getValue() instanceof SuccessfulResponse)) continue;
                return (V)((SuccessfulResponse)e.getValue()).getResponseValue();
            }
            throw new ExecutionException(new IllegalStateException("Invalid response " + response));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DistributedRunnableFuture)) {
                return false;
            }
            DistributedRunnableFuture that = (DistributedRunnableFuture)o;
            return that.getCommand().equals(this.getCommand());
        }

        public int hashCode() {
            return this.getCommand().hashCode();
        }
    }
}

