/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.infinispan.atomic.Operation;
import org.infinispan.marshall.Marshallable;
import org.infinispan.util.FastCopyHashMap;

@Marshallable(externalizer=Externalizer.class, id=49)
public class ClearOperation<K, V>
extends Operation<K, V> {
    FastCopyHashMap<K, V> originalEntries;

    ClearOperation() {
    }

    ClearOperation(FastCopyHashMap<K, V> originalEntries) {
        this.originalEntries = originalEntries;
    }

    @Override
    public void rollback(Map<K, V> delegate) {
        if (!this.originalEntries.isEmpty()) {
            delegate.putAll(this.originalEntries);
        }
    }

    @Override
    public void replay(Map<K, V> delegate) {
        delegate.clear();
    }

    public static class Externalizer
    implements org.infinispan.marshall.Externalizer {
        @Override
        public void writeObject(ObjectOutput output, Object object) throws IOException {
        }

        @Override
        public Object readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new ClearOperation();
        }
    }
}

