/********************************************************************************************
 * Little File Compressor for *nix systems.
 *
 * Copyright (C) 2002 Claudio Scordino , Linda Martorini, Francesco Lelli
 *
 * ******************************************************************************************
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ********************************************************************************************/

/*albero.h*/

#define N 256

struct nodo;

void inizializzazione(struct nodo* tab); 
/*crea un albero per la compressione come da algoritmo*/

void calcola_frequenza(struct nodo* tab, FILE* fdes); 
/*Calcola la frequenza dei simboli.
fdes e' il descrittore del file che vogliamo analizzare (si suppone che il file passato sia
gia' aperto).*/

void visita_dec(struct nodo* tab, unsigned int nod, char byte, unsigned int* successivo);
/*serve per la decodifica; in ingresso (parametro byte) ha il valore del bit e se il nodo
(parametro nod) non e' una foglia, modifica successivo per poter ripartire.
Il parametro byte puo' essere 0 o 1.
Nel caso in cui sia una foglia il paramentro successivo contiene l'indice della
foglia. Questa funzione viene invocata dalla funzione decompressore*/

void codifica (struct nodo* tab, int indice_nodo);
/*rempie i campi codifica e lunghezza della tabella.
Deve essere invocata dal compressore ma non dal decompressore*/

int leggi_frequenze_da_file(struct nodo* tab,struct bitIO* file);
/*leggo dal file compresso per poter ricostruire l'albero*/

struct nodo* crea_tabella(int num_elem);

void distruggi_tabella(struct nodo *tab);

int ritorno_freq(struct nodo *tab, int i);

int ritorno_lung(struct nodo *tab, int i);

char* ritorno_cod(struct nodo *tab, int i);
