OBJ = regexp.o vfontedpr.o vgrindefs.o version.o

FLAGS = $(EUC) -DLIBDIR='"$(LIBDIR)"' $(DEFINES) -I../include

.c.o:
	$(CC) $(_CFLAGS) $(FLAGS) -c $<

all: vgrind vfontedpr vgrind.1

vfontedpr: $(OBJ)
	$(CC) $(_CFLAGS) $(_LDFLAGS) $(OBJ) $(LIBS) -o vfontedpr

vgrind: vgrind.sh
	rm -f $@
	echo "#!$(SHELL)" >>$@
	echo "_TROFF=$(BINDIR)/troff" >>$@
	echo "_VFONTEDPR=$(LIBDIR)/vfontedpr" >>$@
	echo "_TMAC_VGRIND=$(MACDIR)/vgrind" >>$@
	echo "_DPOST=$(BINDIR)/dpost" >>$@
	cat vgrind.sh >>$@
	chmod 755 $@

install:
	$(INSTALL) -c vgrind $(ROOT)$(BINDIR)/vgrind
	test -d $(ROOT)$(LIBDIR) || mkdir -p $(ROOT)$(LIBDIR)
	$(INSTALL) -c vfontedpr $(ROOT)$(LIBDIR)/vfontedpr
	$(STRIP) $(ROOT)$(LIBDIR)/vfontedpr
	$(INSTALL) -c -m 644 vgrindefs.src $(ROOT)$(LIBDIR)/vgrindefs
	$(INSTALL) -c -m 644 vgrind.1 $(ROOT)$(MANDIR)/man1/vgrind.1

clean:
	rm -f $(OBJ) vfontedpr vgrind retest retest.o core log *~ vgrind.1

mrproper: clean

vgrind.1: vgrind.1.in
	sed -e 's"/usr/ucblib/tmac/"$(ROOT)$(MACDIR)/"' \
	    -e 's"/usr/ucblib/"$(ROOT)$(LIBDIR)/"' vgrind.1.in > $@
