/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.util.Date;
import nom.tam.fits.FitsDate;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.header.IFitsHeader;

public class HeaderCardBuilder {
    private final Header header;
    private HeaderCard card;
    private IFitsHeader key;

    protected HeaderCardBuilder(Header header, IFitsHeader key) {
        this.header = header;
        this.card(key);
    }

    public HeaderCard card() {
        return this.card;
    }

    public HeaderCardBuilder card(IFitsHeader newKey) {
        this.key = newKey;
        this.card = this.header.findCard(this.key);
        return this;
    }

    public HeaderCardBuilder comment(String newComment) throws HeaderCardException {
        if (this.card == null) {
            this.card = new HeaderCard(this.key.key(), (String)null, null);
            this.header.addLine(this.card);
        }
        this.card.setComment(newComment);
        return this;
    }

    public HeaderCardBuilder value(boolean newValue) throws HeaderCardException {
        if (this.card == null) {
            this.card = new HeaderCard(this.key.key(), newValue, null);
            this.header.addLine(this.card);
        } else {
            this.card.setValue(newValue);
        }
        return this;
    }

    public HeaderCardBuilder value(Date newValue) throws HeaderCardException {
        return this.value(FitsDate.getFitsDateString(newValue));
    }

    public HeaderCardBuilder value(double newValue) throws HeaderCardException {
        if (this.card == null) {
            this.card = new HeaderCard(this.key.key(), newValue, null);
            this.header.addLine(this.card);
        } else {
            this.card.setValue(newValue);
        }
        return this;
    }

    public HeaderCardBuilder value(float newValue) throws HeaderCardException {
        if (this.card == null) {
            this.card = new HeaderCard(this.key.key(), newValue, null);
            this.header.addLine(this.card);
        } else {
            this.card.setValue(newValue);
        }
        return this;
    }

    public HeaderCardBuilder value(int newValue) throws HeaderCardException {
        if (this.card == null) {
            this.card = new HeaderCard(this.key.key(), newValue, null);
            this.header.addLine(this.card);
        } else {
            this.card.setValue(newValue);
        }
        return this;
    }

    public HeaderCardBuilder value(long newValue) throws HeaderCardException {
        if (this.card == null) {
            this.card = new HeaderCard(this.key.key(), newValue, null);
            this.header.addLine(this.card);
        } else {
            this.card.setValue(newValue);
        }
        return this;
    }

    public HeaderCardBuilder value(String newValue) throws HeaderCardException {
        if (this.card == null) {
            this.card = new HeaderCard(this.key.key(), newValue, null);
            this.header.addLine(this.card);
        } else {
            this.card.setValue(newValue);
        }
        return this;
    }
}

