/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import nom.tam.fits.Fits;
import nom.tam.fits.ImageHDU;
import nom.tam.image.ImageTiler;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.Test;

public class TilerTest {
    void doTile(String test, float[][] data, ImageTiler t, int x, int y, int nx, int ny) throws Exception {
        float[] tile = new float[nx * ny];
        t.getTile(tile, new int[]{y, x}, new int[]{ny, nx});
        float sum0 = 0.0f;
        float sum1 = 0.0f;
        for (int i = 0; i < nx; ++i) {
            for (int j = 0; j < ny; ++j) {
                sum0 += tile[i + j * nx];
                sum1 += data[j + y][i + x];
            }
        }
        Assert.assertEquals((String)("Tiler" + test), (double)sum0, (double)sum1, (double)0.0);
    }

    @Test
    public void test() throws Exception {
        float[][] data = new float[300][300];
        for (int i = 0; i < 300; ++i) {
            for (int j = 0; j < 300; ++j) {
                data[i][j] = 1000 * i + j;
            }
        }
        Fits f = new Fits();
        BufferedFile bf = new BufferedFile("tiler1.fits", "rw");
        f.addHDU(Fits.makeHDU(data));
        f.write(bf);
        bf.close();
        f = new Fits("tiler1.fits");
        ImageHDU h = (ImageHDU)f.readHDU();
        ImageTiler t = h.getTiler();
        this.doTile("t1", data, t, 200, 200, 50, 50);
        this.doTile("t2", data, t, 133, 133, 72, 26);
        Object o = h.getData().getKernel();
        this.doTile("t3", data, t, 200, 200, 50, 50);
        this.doTile("t4", data, t, 133, 133, 72, 26);
    }
}

