/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.test;

import nom.tam.fits.Fits;
import nom.tam.fits.FitsFactory;
import nom.tam.util.BufferedFile;
import org.junit.Assert;
import org.junit.Test;

public class JunkTest {
    @Test
    public void test() throws Exception {
        Fits f = new Fits();
        byte[] bimg = new byte[40];
        for (int i = 10; i < bimg.length; ++i) {
            bimg[i] = (byte)i;
        }
        f.addHDU(Fits.makeHDU(bimg));
        BufferedFile bf = new BufferedFile("j1.fits", "rw");
        f.write(bf);
        bf.flush();
        bf.close();
        bf = new BufferedFile("j2.fits", "rw");
        bf.write(new byte[10]);
        bf.close();
        bf = new BufferedFile("j3.fits", "rw");
        f.write(bf);
        bf.write("JUNKJUNK".getBytes());
        bf.close();
        bf = new BufferedFile("j4.fits", "rw");
        f.write(bf);
        for (int i = 0; i < 100; ++i) {
            bf.write("A random string".getBytes());
        }
        bf.close();
        boolean pos = false;
        try {
            f = new Fits("j1.fits");
            f.read();
        }
        catch (Exception e) {
            pos = true;
        }
        Assert.assertTrue((String)"Junk Test: Valid File OK,Dft", (boolean)this.readSuccess("j1.fits"));
        Assert.assertTrue((String)"Junk Test: Invalid File Fails, Dft", (!this.readSuccess("j2.fits") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Junk Test: Short junk fails, Dft", (!this.readSuccess("j3.fits") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Junk Test: Long junk fails, Dft", (!this.readSuccess("j4.fits") ? 1 : 0) != 0);
        FitsFactory.setAllowTerminalJunk(true);
        Assert.assertTrue((String)"Junk Test: Valid File OK,with junk", (boolean)this.readSuccess("j1.fits"));
        Assert.assertTrue((String)"Junk Test: Invalid File Fails, with junk", (!this.readSuccess("j2.fits") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Junk Test: Short junk OK, with junk", (boolean)this.readSuccess("j3.fits"));
        Assert.assertTrue((String)"Junk Test: Long junk OK, with junk", (boolean)this.readSuccess("j4.fits"));
        FitsFactory.setAllowTerminalJunk(false);
        Assert.assertTrue((String)"Junk Test: Valid File OK,No junk", (boolean)this.readSuccess("j1.fits"));
        Assert.assertTrue((String)"Junk Test: Invalid File Fails, No junk", (!this.readSuccess("j2.fits") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Junk Test: Short junk fails, No junk", (!this.readSuccess("j3.fits") ? 1 : 0) != 0);
        Assert.assertTrue((String)"Junk Test: Long junk fails, No junk", (!this.readSuccess("j4.fits") ? 1 : 0) != 0);
    }

    boolean readSuccess(String file) {
        try {
            Fits f = new Fits(file);
            f.read();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

