/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.util.Formatter;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.HeaderCommentsMap;

public class HeaderCard {
    private String key;
    private String value;
    private String comment;
    private boolean nullable;
    private boolean isString;
    public static final int MAX_KEYWORD_LENGTH = 8;
    public static final int MAX_VALUE_LENGTH = 70;
    private static String space80 = "                                                                                ";

    public HeaderCard(String key, double value, String comment) throws HeaderCardException {
        this(key, HeaderCard.dblString(value), comment);
        this.isString = false;
    }

    public HeaderCard(String key, boolean value, String comment) throws HeaderCardException {
        this(key, value ? "T" : "F", comment);
        this.isString = false;
    }

    public HeaderCard(String key, int value, String comment) throws HeaderCardException {
        this(key, String.valueOf(value), comment);
        this.isString = false;
    }

    public HeaderCard(String key, long value, String comment) throws HeaderCardException {
        this(key, String.valueOf(value), comment);
        this.isString = false;
    }

    public HeaderCard(String key, String value, String comment) throws HeaderCardException {
        this(key, value, comment, false);
    }

    public HeaderCard(String key, String comment, boolean nullable) throws HeaderCardException {
        this(key, null, comment, nullable);
    }

    private static String dblString(double input) {
        String value = String.valueOf(input);
        if (value.length() > 20) {
            value = new Formatter().format("%20.13G", input).out().toString();
        }
        return value;
    }

    public HeaderCard(String key, String value, String comment, boolean nullable) throws HeaderCardException {
        if (comment != null && comment.startsWith("ntf::")) {
            String ckey = comment.substring(5);
            comment = HeaderCommentsMap.getComment(ckey);
        }
        if (key == null && value != null) {
            throw new HeaderCardException("Null keyword with non-null value");
        }
        if (!(key == null || key.length() <= 8 || FitsFactory.getUseHierarch() && key.substring(0, 9).equals("HIERARCH."))) {
            throw new HeaderCardException("Keyword too long");
        }
        if (value != null) {
            if ((value = value.replaceAll(" *$", "")).length() > 70) {
                throw new HeaderCardException("Value too long");
            }
            if (value.startsWith("'")) {
                if (value.charAt(value.length() - 1) != '\'') {
                    throw new HeaderCardException("Missing end quote in string value");
                }
                value = value.substring(1, value.length() - 1).trim();
            }
        }
        this.key = key;
        this.value = value;
        this.comment = comment;
        this.nullable = nullable;
        this.isString = true;
    }

    public HeaderCard(String card) {
        this.key = null;
        this.value = null;
        this.comment = null;
        this.isString = false;
        if (card.length() > 80) {
            card = card.substring(0, 80);
        }
        if (FitsFactory.getUseHierarch() && card.length() > 9 && card.substring(0, 9).equals("HIERARCH ")) {
            this.hierarchCard(card);
            return;
        }
        if (card.length() < 9) {
            this.key = card;
            return;
        }
        this.key = card.substring(0, 8).trim();
        if (this.key.length() == 0) {
            this.key = "";
            this.comment = card.substring(8);
            return;
        }
        if (this.key.equals("COMMENT") || this.key.equals("HISTORY") || !card.substring(8, 10).equals("= ")) {
            this.comment = card.substring(8).trim();
            return;
        }
        String valueAndComment = card.substring(10).trim();
        if (valueAndComment.length() == 0) {
            this.value = "";
            return;
        }
        int vend = -1;
        boolean quote = false;
        if (valueAndComment.charAt(0) == '\'') {
            int offset = 1;
            while (offset < valueAndComment.length() && (vend = valueAndComment.indexOf("'", offset)) != valueAndComment.length() - 1) {
                if (vend == -1) {
                    this.key = null;
                    this.comment = card;
                    return;
                }
                if (valueAndComment.charAt(vend + 1) != '\'') break;
                offset = vend + 2;
            }
            this.value = valueAndComment.substring(1, vend).trim();
            this.value = this.value.replace("''", "'");
            if (vend + 1 >= valueAndComment.length()) {
                this.comment = null;
            } else {
                this.comment = valueAndComment.substring(vend + 1).trim();
                if (this.comment.charAt(0) == '/') {
                    this.comment = this.comment.length() > 1 ? this.comment.substring(1) : "";
                }
                if (this.comment.length() == 0) {
                    this.comment = null;
                }
            }
            this.isString = true;
        } else {
            int slashLoc = valueAndComment.indexOf(47);
            if (slashLoc != -1) {
                this.comment = valueAndComment.substring(slashLoc + 1).trim();
                this.value = valueAndComment.substring(0, slashLoc).trim();
            } else {
                this.value = valueAndComment;
            }
        }
    }

    private void hierarchCard(String card) {
        int[] tokLimits;
        String name = "";
        String token = null;
        String separator = "";
        int posit = 0;
        int commStart = -1;
        while ((tokLimits = this.getToken(card, posit)) != null) {
            token = card.substring(tokLimits[0], tokLimits[1]);
            if (token.equals("=")) {
                if ((tokLimits = this.getToken(card, tokLimits[1])) != null) {
                    token = card.substring(tokLimits[0], tokLimits[1]);
                    break;
                }
                this.key = name;
                this.value = null;
                this.comment = null;
                return;
            }
            name = name + separator + token;
            separator = ".";
            posit = tokLimits[1];
        }
        this.key = name;
        if (tokLimits == null) {
            this.value = null;
            this.comment = null;
            this.isString = false;
            return;
        }
        if (token.charAt(0) == '\'') {
            int i;
            this.isString = true;
            if (token.length() > 1 && token.charAt(1) == '\'' && (token.length() == 2 || token.charAt(2) != '\'')) {
                this.value = "";
                commStart = tokLimits[0] + 2;
            } else {
                if (card.length() < tokLimits[0] + 2) {
                    this.value = null;
                    this.comment = null;
                    this.isString = false;
                    return;
                }
                for (i = tokLimits[0] + 1; i < card.length(); ++i) {
                    if (card.charAt(i) != '\'') continue;
                    if (i == card.length() - 1) {
                        this.value = card.substring(tokLimits[0] + 1, i);
                        commStart = i + 1;
                        break;
                    }
                    if (card.charAt(i + 1) == '\'') {
                        ++i;
                        continue;
                    }
                    this.value = card.substring(tokLimits[0] + 1, i);
                    commStart = i + 1;
                    break;
                }
            }
            if (commStart < 0) {
                this.value = null;
                this.comment = null;
                this.isString = false;
                return;
            }
            for (i = commStart; i < card.length(); ++i) {
                if (card.charAt(i) == '/') {
                    this.comment = card.substring(i + 1).trim();
                } else {
                    if (card.charAt(i) == ' ') continue;
                    this.comment = null;
                }
                break;
            }
        } else {
            this.isString = false;
            int sl = token.indexOf(47);
            if (sl == 0) {
                this.value = null;
                this.comment = card.substring(tokLimits[0] + 1);
            } else if (sl > 0) {
                this.value = token.substring(0, sl);
                this.comment = card.substring(tokLimits[0] + sl + 1);
            } else {
                this.value = token;
                for (int i = tokLimits[1]; i < card.length(); ++i) {
                    if (card.charAt(i) == '/') {
                        this.comment = card.substring(i + 1).trim();
                    } else {
                        if (card.charAt(i) == ' ') continue;
                        this.comment = null;
                    }
                    break;
                }
            }
        }
    }

    private int[] getToken(String card, int posit) {
        int j;
        int i;
        for (i = posit; i < card.length() && card.charAt(i) == ' '; ++i) {
        }
        if (i >= card.length()) {
            return null;
        }
        if (card.charAt(i) == '=') {
            return new int[]{i, i + 1};
        }
        for (j = i + 1; j < card.length() && card.charAt(j) != ' ' && card.charAt(j) != '='; ++j) {
        }
        return new int[]{i, j};
    }

    public boolean isStringValue() {
        return this.isString;
    }

    public boolean isKeyValuePair() {
        return this.key != null && this.value != null;
    }

    void setKey(String newKey) {
        this.key = newKey;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String update) {
        this.value = update;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        if (this.key != null) {
            if (this.key.length() > 9 && this.key.substring(0, 9).equals("HIERARCH.")) {
                return this.hierarchToString();
            }
            buf.append(this.key);
            if (this.key.length() < 8) {
                buf.append(space80.substring(0, 8 - buf.length()));
            }
        }
        if (this.value != null || this.nullable) {
            buf.append("= ");
            if (this.value != null) {
                if (this.isString) {
                    buf.append('\'');
                    buf.append(this.value.replace("'", "''"));
                    if (buf.length() < 19) {
                        buf.append(space80.substring(0, 19 - buf.length()));
                    }
                    buf.append('\'');
                    if (buf.length() < 30) {
                        buf.append(space80.substring(0, 30 - buf.length()));
                    }
                } else {
                    int offset = buf.length();
                    if (this.value.length() < 20) {
                        buf.append(space80.substring(0, 20 - this.value.length()));
                    }
                    buf.append(this.value);
                }
            } else {
                buf.append(space80.substring(0, 20));
            }
            if (this.comment != null) {
                buf.append(" / ");
            }
        } else if (this.comment != null && this.comment.startsWith("= ")) {
            buf.append("  ");
        }
        if (this.comment != null) {
            buf.append(this.comment);
        }
        if (buf.length() > 80) {
            buf.setLength(80);
        } else if (buf.length() < 80) {
            buf.append(space80.substring(0, 80 - buf.length()));
        }
        return buf.toString();
    }

    private String hierarchToString() {
        String card;
        StringBuffer b = new StringBuffer(80);
        int p = 0;
        String space = "";
        while (p < this.key.length()) {
            int q = this.key.indexOf(46, p);
            if (q < 0) {
                b.append(space + this.key.substring(p));
                break;
            }
            b.append(space + this.key.substring(p, q));
            space = " ";
            p = q + 1;
        }
        if (this.value != null || this.nullable) {
            b.append("= ");
            if (this.value != null) {
                int avail = 80 - (b.length() + this.value.length());
                if (this.isString) {
                    avail -= 2;
                }
                if (this.comment != null) {
                    avail -= 3 + this.comment.length();
                }
                if (avail > 0 && b.length() < 29) {
                    b.append(space80.substring(0, Math.min(avail, 29 - b.length())));
                }
                if (this.isString) {
                    b.append('\'');
                } else if (avail > 0 && this.value.length() < 10) {
                    b.append(space80.substring(0, Math.min(avail, 10 - this.value.length())));
                }
                b.append(this.value);
                if (this.isString) {
                    b.append('\'');
                }
            } else if (b.length() < 30) {
                b.append(space80.substring(0, 30 - b.length()));
            }
        }
        if (this.comment != null) {
            b.append(" / " + this.comment);
        }
        if (b.length() < 80) {
            b.append(space80.substring(0, 80 - b.length()));
        }
        if ((card = new String(b)).length() > 80) {
            card = card.substring(0, 80);
        }
        return card;
    }
}

