/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.args4j;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.ExampleMode;
import org.kohsuke.args4j.FieldSetter;
import org.kohsuke.args4j.IllegalAnnotationError;
import org.kohsuke.args4j.Messages;
import org.kohsuke.args4j.MethodSetter;
import org.kohsuke.args4j.MultiValueFieldSetter;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.BooleanOptionHandler;
import org.kohsuke.args4j.spi.DoubleOptionHandler;
import org.kohsuke.args4j.spi.EnumOptionHandler;
import org.kohsuke.args4j.spi.FileOptionHandler;
import org.kohsuke.args4j.spi.IntOptionHandler;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.args4j.spi.StringOptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdLineParser {
    private final Object bean;
    private final Map<String, OptionHandler> options = new TreeMap<String, OptionHandler>();
    private Setter<String> argumentSetter;
    private int usageWidth = 80;
    private static final Map<Class, Constructor<? extends OptionHandler>> handlerClasses = Collections.synchronizedMap(new HashMap());

    public CmdLineParser(Object bean) {
        this.bean = bean;
        for (Class<?> c = bean.getClass(); c != null; c = c.getSuperclass()) {
            Argument a;
            Option o;
            for (Method method : c.getDeclaredMethods()) {
                o = method.getAnnotation(Option.class);
                if (o != null) {
                    this.addOption(new MethodSetter(bean, method), o);
                }
                if ((a = method.getAnnotation(Argument.class)) == null) continue;
                this.addArgument(new MethodSetter(bean, method));
            }
            for (AccessibleObject accessibleObject : c.getDeclaredFields()) {
                o = ((Field)accessibleObject).getAnnotation(Option.class);
                if (o != null) {
                    this.addOption(this.createFieldSetter((Field)accessibleObject), o);
                }
                if ((a = ((Field)accessibleObject).getAnnotation(Argument.class)) == null) continue;
                this.addArgument(this.createFieldSetter((Field)accessibleObject));
            }
        }
    }

    private Setter createFieldSetter(Field f) {
        if (List.class.isAssignableFrom(f.getType())) {
            return new MultiValueFieldSetter(this.bean, f);
        }
        return new FieldSetter(this.bean, f);
    }

    private void addArgument(Setter<String> setter) {
        if (this.argumentSetter != null) {
            throw new IllegalAnnotationError("@Argument is used more than once");
        }
        this.argumentSetter = setter;
    }

    private void addOption(Setter setter, Option o) {
        OptionHandler h = this.createOptionHandler(o, setter);
        if (this.options.put(h.option.name(), h) != null) {
            throw new IllegalAnnotationError("Option name " + h.option.name() + " is used more than once");
        }
    }

    protected OptionHandler createOptionHandler(Option o, Setter setter) {
        Constructor<? extends OptionHandler> handlerType;
        Class<? extends OptionHandler> h = o.handler();
        if (h == OptionHandler.class) {
            Class t = setter.getType();
            if (Enum.class.isAssignableFrom(t)) {
                return new EnumOptionHandler(this, o, setter, t);
            }
            handlerType = handlerClasses.get(t);
            if (handlerType == null) {
                throw new IllegalAnnotationError("No OptionHandler is registered to handle " + t);
            }
        } else {
            handlerType = CmdLineParser.getConstructor(h);
        }
        try {
            return handlerType.newInstance(this, o, setter);
        }
        catch (InstantiationException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAnnotationError(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalAnnotationError(e);
        }
    }

    public String printExample(ExampleMode mode) {
        return this.printExample(mode, null);
    }

    public String printExample(ExampleMode mode, ResourceBundle rb) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, OptionHandler> e : this.options.entrySet()) {
            Option option = e.getValue().option;
            if (option.usage().length() == 0 || !mode.print(option)) continue;
            buf.append(' ');
            buf.append(e.getKey());
            String metaVar = e.getValue().getMetaVariable(rb);
            if (metaVar == null) continue;
            buf.append(' ').append(metaVar);
        }
        return buf.toString();
    }

    public void printUsage(OutputStream out) {
        this.printUsage(new OutputStreamWriter(out), null);
    }

    public void printUsage(Writer out, ResourceBundle rb) {
        PrintWriter w = new PrintWriter(out);
        int len = 0;
        for (Map.Entry<String, OptionHandler> e : this.options.entrySet()) {
            String usage = e.getValue().option.usage();
            if (usage.length() == 0) continue;
            String metaVar = e.getValue().getMetaVariable(rb);
            int metaLen = metaVar != null ? metaVar.length() + 1 : 0;
            len = Math.max(len, e.getKey().length() + metaLen);
        }
        int descriptionWidth = this.usageWidth - len - 4;
        block1: for (Map.Entry<String, OptionHandler> e : this.options.entrySet()) {
            String usage = e.getValue().option.usage();
            if (usage.length() == 0) continue;
            String option = e.getKey();
            int headLen = option.length();
            w.print(' ');
            w.print(option);
            String metaVar = e.getValue().getMetaVariable(rb);
            if (metaVar != null) {
                w.print(' ');
                w.print(metaVar);
                headLen += metaVar.length() + 1;
            }
            while (headLen < len) {
                w.print(' ');
                ++headLen;
            }
            w.print(" : ");
            if (rb != null) {
                usage = rb.getString(usage);
            }
            while (usage != null && usage.length() > 0) {
                int idx = usage.indexOf(10);
                if (idx >= 0 && idx <= descriptionWidth) {
                    w.println(usage.substring(0, idx));
                    if ((usage = usage.substring(idx + 1)).length() <= 0) continue;
                    this.indent(w, len + 4);
                    continue;
                }
                if (usage.length() <= descriptionWidth) {
                    w.println(usage);
                    continue block1;
                }
                w.println(usage.substring(0, descriptionWidth));
                usage = usage.substring(descriptionWidth);
                this.indent(w, len + 4);
            }
        }
        w.flush();
    }

    private void indent(PrintWriter w, int i) {
        while (i > 0) {
            w.print(' ');
            --i;
        }
    }

    public void parseArgument(String ... args) throws CmdLineException {
        CmdLineImpl cmdLine = new CmdLineImpl(args);
        HashSet<OptionHandler> present = new HashSet<OptionHandler>();
        while (cmdLine.hasMore()) {
            String arg = cmdLine.getOptionName();
            if (this.isOption(arg)) {
                OptionHandler handler;
                OptionHandler optionHandler = handler = arg.indexOf(61) == -1 ? this.options.get(arg) : this.findOptionHandler(arg);
                if (handler != null) {
                    int diff = handler.parseArguments(cmdLine);
                    cmdLine.proceed(diff + 1);
                    present.add(handler);
                    continue;
                }
                throw new CmdLineException(Messages.UNDEFINED_OPTION.format(arg));
            }
            if (this.argumentSetter == null) {
                throw new CmdLineException(Messages.NO_ARGUMENT_ALLOWED.format(arg));
            }
            this.argumentSetter.addValue(arg);
            cmdLine.proceed(1);
        }
        for (OptionHandler handler : this.options.values()) {
            if (!handler.option.required() || present.contains(handler)) continue;
            throw new CmdLineException(Messages.REQUIRED_OPTION_MISSING.format(handler.option.name()));
        }
    }

    private OptionHandler findOptionHandler(String name) {
        OptionHandler handler = this.options.get(name);
        if (handler == null) {
            for (int i = name.length(); i > 1; --i) {
                String prefix = name.substring(0, i);
                Map<String, OptionHandler> possibleHandlers = this.filter(this.options, prefix);
                handler = possibleHandlers.get(prefix);
                if (handler == null) continue;
                return handler;
            }
        }
        return handler;
    }

    private Map<String, OptionHandler> filter(Map<String, OptionHandler> map, String keyFilter) {
        TreeMap<String, OptionHandler> rv = new TreeMap<String, OptionHandler>();
        for (String key : map.keySet()) {
            if (!key.startsWith(keyFilter)) continue;
            rv.put(key, map.get(key));
        }
        return rv;
    }

    protected boolean isOption(String arg) {
        return arg.startsWith("-");
    }

    public static void registerHandler(Class valueType, Class<? extends OptionHandler> handlerClass) {
        if (valueType == null || handlerClass == null) {
            throw new IllegalArgumentException();
        }
        if (!OptionHandler.class.isAssignableFrom(handlerClass)) {
            throw new IllegalArgumentException("Not an OptionHandler class");
        }
        Constructor<? extends OptionHandler> c = CmdLineParser.getConstructor(handlerClass);
        handlerClasses.put(valueType, c);
    }

    private static Constructor<? extends OptionHandler> getConstructor(Class<? extends OptionHandler> handlerClass) {
        try {
            return handlerClass.getConstructor(CmdLineParser.class, Option.class, Setter.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(handlerClass + " does not have the proper constructor");
        }
    }

    public void setUsageWidth(int usageWidth) {
        this.usageWidth = usageWidth;
    }

    static {
        CmdLineParser.registerHandler(Boolean.class, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(Boolean.TYPE, BooleanOptionHandler.class);
        CmdLineParser.registerHandler(File.class, FileOptionHandler.class);
        CmdLineParser.registerHandler(Integer.class, IntOptionHandler.class);
        CmdLineParser.registerHandler(Integer.TYPE, IntOptionHandler.class);
        CmdLineParser.registerHandler(Double.class, DoubleOptionHandler.class);
        CmdLineParser.registerHandler(Double.TYPE, DoubleOptionHandler.class);
        CmdLineParser.registerHandler(String.class, StringOptionHandler.class);
    }

    private class CmdLineImpl
    extends Parameters {
        private final String[] args;
        private int pos;

        CmdLineImpl(String[] args) {
            this.args = args;
            this.pos = 0;
        }

        private boolean hasMore() {
            return this.pos < this.args.length;
        }

        private String getCurrentToken() {
            return this.args[this.pos];
        }

        private void proceed(int n) {
            this.pos += n;
        }

        public String getOptionName() {
            return this.getCurrentToken();
        }

        public String getParameter(int idx) throws CmdLineException {
            if (this.pos + idx + 1 >= this.args.length) {
                throw new CmdLineException(Messages.MISSING_OPERAND.format(this.getOptionName()));
            }
            return this.args[this.pos + idx + 1];
        }

        public int getParameterCount() {
            return this.args.length - (this.pos + 1);
        }
    }
}

