/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.AbstractTypeVisitor6;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ShortNameVisitor
extends AbstractTypeVisitor6<String, Void> {
    public static final ShortNameVisitor INSTANCE = new ShortNameVisitor();

    private ShortNameVisitor() {
    }

    @Override
    public String visitPrimitive(PrimitiveType t, Void p) {
        return t.toString();
    }

    @Override
    public String visitNull(NullType t, Void p) {
        return t.toString();
    }

    @Override
    public String visitArray(ArrayType t, Void p) {
        return t.getComponentType().accept(this, null) + "[]";
    }

    @Override
    public String visitDeclared(DeclaredType t, Void p) {
        return t.asElement().getSimpleName().toString();
    }

    @Override
    public String visitError(ErrorType t, Void p) {
        return t.toString();
    }

    @Override
    public String visitTypeVariable(TypeVariable t, Void p) {
        return t.toString();
    }

    @Override
    public String visitWildcard(WildcardType t, Void p) {
        TypeMirror b = t.getExtendsBound();
        if (b != null) {
            return "? extends " + b.accept(this, null);
        }
        return "? super " + t.getSuperBound().accept(this, null);
    }

    @Override
    public String visitExecutable(ExecutableType t, Void p) {
        return t.toString();
    }

    @Override
    public String visitNoType(NoType t, Void p) {
        return t.toString();
    }
}

