/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.jvnet.sorcerer.ParsedType;
import org.jvnet.sorcerer.util.TreeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RefererFinder
extends TreePathScanner<Void, Void> {
    private final TypeElement type;
    private final Map<Element, Set<TreePath>> result = new HashMap<Element, Set<TreePath>>();

    static Map<Element, Set<TreePath>> find(ParsedType t) {
        RefererFinder finder = new RefererFinder(t.element);
        for (CompilationUnitTree cu : t.getReferers()) {
            finder.scan(cu, null);
        }
        return finder.result;
    }

    private RefererFinder(TypeElement type) {
        this.type = type;
    }

    protected void candidate(Element e) {
        if (e == null) {
            return;
        }
        switch (e.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                if (!this.type.equals(e)) break;
                this.add(this.type);
                break;
            }
            case ENUM_CONSTANT: 
            case METHOD: 
            case CONSTRUCTOR: 
            case FIELD: {
                Element p = e.getEnclosingElement();
                if (p == null || !this.type.equals(p)) break;
                this.add(e);
            }
        }
    }

    private void add(Element e) {
        Set<TreePath> trees = this.result.get(e);
        if (trees == null) {
            trees = new HashSet<TreePath>();
            this.result.put(e, trees);
        }
        trees.add(this.getCurrentPath());
    }

    @Override
    public Void visitIdentifier(IdentifierTree id, Void _) {
        this.candidate(TreeUtil.getElement(id));
        return (Void)super.visitIdentifier(id, _);
    }

    @Override
    public Void visitMemberSelect(MemberSelectTree mst, Void _) {
        this.candidate(TreeUtil.getElement(mst));
        return (Void)super.visitMemberSelect(mst, _);
    }

    @Override
    public Void visitImport(ImportTree node, Void _) {
        return _;
    }
}

