/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.jvnet.sorcerer.LocalVariableIdBuilder;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.util.BiDiMap;

public class JavaScriptStreamWriter
extends PrintWriter {
    private boolean first = false;
    private int indent = 0;
    private final ParsedSourceSet pss;
    private final SymbolTable<TypeElement> typeTable = new SymbolTable<TypeElement>(){
        private Map<Element, Integer> localId = new HashMap<Element, Integer>();

        private int getLocalId(Element e) {
            Integer i = this.localId.get(e);
            if (i == null) {
                this.localId.put(e, 1);
                return 0;
            }
            this.localId.put(e, i + 1);
            return i;
        }

        @Override
        protected void writeItem(TypeElement e) {
            JavaScriptStreamWriter.this.beginArray();
            JavaScriptStreamWriter.this.sep();
            StringBuilder buf = new StringBuilder();
            this.calcEncodedName(e, buf);
            JavaScriptStreamWriter.this.string(buf);
            JavaScriptStreamWriter.this.writeModifiers(e);
            JavaScriptStreamWriter.this.endArray();
        }

        private void calcEncodedName(Element e, StringBuilder buf) {
            Element p = e.getEnclosingElement();
            switch (e.getKind()) {
                case PACKAGE: {
                    buf.append(((PackageElement)e).getQualifiedName());
                    return;
                }
                case CLASS: 
                case ANNOTATION_TYPE: 
                case ENUM: 
                case INTERFACE: {
                    this.calcEncodedName(p, buf);
                    if (buf.length() > 0) {
                        if (p.getKind() == ElementKind.PACKAGE) {
                            buf.append('.');
                        } else {
                            buf.append('$');
                        }
                    }
                    if (e.getSimpleName().length() == 0) {
                        buf.append(this.getLocalId(p));
                    } else {
                        buf.append(e.getSimpleName());
                    }
                    return;
                }
            }
            this.calcEncodedName(p, buf);
            buf.append('$').append(this.getLocalId(p));
        }
    };
    private final SymbolTable<ExecutableElement> methodTable = new SymbolTable<ExecutableElement>(){

        @Override
        protected void writeItem(ExecutableElement e) {
            JavaScriptStreamWriter.this.beginArray();
            JavaScriptStreamWriter.this.ref((TypeElement)e.getEnclosingElement());
            JavaScriptStreamWriter.this.sep();
            if (e.getKind() == ElementKind.CONSTRUCTOR) {
                JavaScriptStreamWriter.this.string(e.getEnclosingElement().getSimpleName());
            } else {
                JavaScriptStreamWriter.this.string(e.getSimpleName());
            }
            JavaScriptStreamWriter.this.beginArray();
            for (VariableElement variableElement : e.getParameters()) {
                TypeMirror vt = JavaScriptStreamWriter.this.pss.getTypes().erasure(variableElement.asType());
                TypeElement ve = (TypeElement)JavaScriptStreamWriter.this.pss.getTypes().asElement(vt);
                if (ve != null) {
                    JavaScriptStreamWriter.this.ref(ve);
                    continue;
                }
                JavaScriptStreamWriter.this.sep().string(((Object)vt).toString());
            }
            JavaScriptStreamWriter.this.endArray();
            JavaScriptStreamWriter.this.writeModifiers(e);
            JavaScriptStreamWriter.this.endArray();
        }

        @Override
        public void add(ExecutableElement e) {
            super.add(e);
            JavaScriptStreamWriter.this.typeTable.add((TypeElement)e.getEnclosingElement());
            for (VariableElement variableElement : e.getParameters()) {
                TypeMirror vt = JavaScriptStreamWriter.this.pss.getTypes().erasure(variableElement.asType());
                TypeElement ve = (TypeElement)JavaScriptStreamWriter.this.pss.getTypes().asElement(vt);
                if (ve == null) continue;
                JavaScriptStreamWriter.this.typeTable.add(ve);
            }
        }
    };
    private final SymbolTable<VariableElement> localVariableTable = new SymbolTable<VariableElement>(){
        private BiDiMap<VariableElement, String> ids = new BiDiMap();

        @Override
        public void add(VariableElement ve) {
            super.add(ve);
            String id = new LocalVariableIdBuilder(JavaScriptStreamWriter.this.pss).href(ve);
            if (this.ids.containsValue(id)) {
                int suffix = 2;
                while (this.ids.containsValue(id + suffix)) {
                    ++suffix;
                }
                id = id + suffix;
            }
            this.ids.put(ve, id);
        }

        @Override
        protected void writeItem(VariableElement ve) {
            JavaScriptStreamWriter.this.beginArray();
            JavaScriptStreamWriter.this.sep().string(ve.getSimpleName());
            JavaScriptStreamWriter.this.sep().string(this.ids.get(ve));
            JavaScriptStreamWriter.this.endArray();
        }
    };
    static boolean doIdent = false;

    public JavaScriptStreamWriter(Writer out, ParsedSourceSet pss) {
        super(out);
        this.pss = pss;
    }

    public JavaScriptStreamWriter i() {
        ++this.indent;
        return this;
    }

    public JavaScriptStreamWriter o() {
        --this.indent;
        return this;
    }

    public JavaScriptStreamWriter sep() {
        if (this.first) {
            this.first = false;
        } else {
            this.print(',');
            this.nl();
        }
        return this;
    }

    public JavaScriptStreamWriter nl() {
        if (doIdent) {
            this.println();
            for (int i = 0; i < this.indent; ++i) {
                this.print("  ");
            }
        }
        return this;
    }

    public void resetList() {
        this.first = true;
    }

    public void beginList() {
        this.first = true;
        this.i().nl();
    }

    public void endList() {
        this.o().nl();
        this.first = false;
    }

    public void string(Object s) {
        this.print('\"');
        String str = s.toString();
        block4: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\\': {
                    this.print("\\\\");
                    continue block4;
                }
                case '\"': {
                    this.print("\\\"");
                    continue block4;
                }
                default: {
                    this.print(ch);
                }
            }
        }
        this.print('\"');
    }

    public void writeModifiers(Element e) {
        this.sep().string(this.getCssClass(e));
    }

    public void beginMethod(String methodName) {
        this.sep().print(methodName);
        this.print('(');
        this.beginList();
    }

    public void endMethod() {
        this.endList();
        this.print(')');
    }

    public void beginArray() {
        this.sep().print('[');
        this.beginList();
    }

    public void endArray() {
        this.endList();
        this.print(']');
    }

    public void ref(ExecutableElement e) {
        this.sep().print(this.methodTable.find(e));
    }

    public void ref(TypeElement e) {
        this.sep().print(this.typeTable.find(e));
    }

    public void ref(VariableElement var) {
        this.sep().print(this.localVariableTable.find(var));
    }

    public void collect(Element e) {
        switch (e.getKind()) {
            case CLASS: 
            case ANNOTATION_TYPE: 
            case ENUM: 
            case INTERFACE: {
                this.typeTable.add((TypeElement)e);
                break;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                ExecutableElement ee = (ExecutableElement)e;
                this.methodTable.add(ee);
                break;
            }
            case EXCEPTION_PARAMETER: 
            case LOCAL_VARIABLE: 
            case PARAMETER: {
                this.localVariableTable.add((VariableElement)e);
            }
        }
    }

    public void writeSymbolTable() {
        this.typeTable.write("typeTable");
        this.methodTable.write("methodTable");
        this.localVariableTable.write("localVariableTable");
    }

    public String getCssClass(Element e) {
        StringBuilder buf = new StringBuilder();
        Set<Modifier> mods = e.getModifiers();
        if (mods.contains((Object)Modifier.STATIC)) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("st");
        }
        if (this.pss.getElements().isDeprecated(e)) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append("dp");
        }
        if (buf.length() > 0) {
            buf.append(' ');
        }
        switch (e.getKind()) {
            case ANNOTATION_TYPE: {
                buf.append("an");
                break;
            }
            case CLASS: {
                buf.append("cl");
                break;
            }
            case CONSTRUCTOR: {
                buf.append("co");
                break;
            }
            case ENUM: {
                buf.append("en");
                break;
            }
            case ENUM_CONSTANT: {
                buf.append("ec");
                break;
            }
            case EXCEPTION_PARAMETER: {
                buf.append("ex");
                break;
            }
            case FIELD: {
                buf.append("fi");
                break;
            }
            case INSTANCE_INIT: {
                buf.append("ii");
                break;
            }
            case INTERFACE: {
                buf.append("it");
                break;
            }
            case LOCAL_VARIABLE: {
                buf.append("lv");
                break;
            }
            case METHOD: {
                buf.append("me");
                break;
            }
            case PACKAGE: {
                buf.append("pk");
                break;
            }
            case PARAMETER: {
                buf.append("pa");
                break;
            }
            case STATIC_INIT: {
                buf.append("si");
                break;
            }
            case TYPE_PARAMETER: {
                buf.append("tp");
                break;
            }
        }
        return buf.toString();
    }

    static {
        try {
            doIdent = Boolean.getBoolean("sorcerer.debug");
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SymbolTable<E>
    extends LinkedHashMap<E, Integer> {
        private SymbolTable() {
        }

        public void add(E e) {
            if (e == null) {
                throw new IllegalArgumentException();
            }
            if (!this.containsKey(e)) {
                this.put(e, this.size());
            }
        }

        public int find(E e) {
            Integer v = (Integer)this.get(e);
            if (v == null) {
                throw new IllegalStateException("No such symbol: " + e);
            }
            return v;
        }

        public void write(String functionName) {
            JavaScriptStreamWriter.this.beginMethod(functionName);
            for (Object e : this.keySet()) {
                this.writeItem(e);
            }
            JavaScriptStreamWriter.this.endMethod();
        }

        protected abstract void writeItem(E var1);
    }
}

