/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.sorcerer;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.jvnet.sorcerer.OutlineNameVisitor;
import org.jvnet.sorcerer.ParsedSourceSet;
import org.jvnet.sorcerer.util.JsonWriter;
import org.jvnet.sorcerer.util.TreeUtil;

abstract class AbstractWriter {
    protected final ParsedSourceSet pss;
    private static final Modifier[] MODS = new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED, Modifier.PRIVATE};

    protected AbstractWriter(ParsedSourceSet pss) {
        this.pss = pss;
    }

    protected Writer open(File dir, String fileName) throws IOException {
        return new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dir, fileName)), "UTF-8");
    }

    protected Writer openDefault(File dir, String fileName) throws IOException {
        return new BufferedWriter(new OutputStreamWriter(new FileOutputStream(new File(dir, fileName))));
    }

    protected void writeOutlineNodeProperties(JsonWriter jw, Element e) {
        jw.property("name", e.accept(OutlineNameVisitor.INSTANCE, null));
        jw.property("kind", this.getKindString(e.getKind()));
        jw.property("access", this.getAccessLevel(e).toString());
        if (e.getModifiers().contains((Object)Modifier.STATIC)) {
            jw.property("static", true);
        }
        if (TreeUtil.isLocal(e)) {
            jw.property("local", true);
        }
    }

    protected void writeOutlineNodeProperties(JsonWriter jw, Element e, CompilationUnitTree cu, Tree t) {
        this.writeOutlineNodeProperties(jw, e);
        long startPos = this.pss.getSourcePositions().getStartPosition(cu, t);
        jw.property("line", cu.getLineMap().getLineNumber(startPos));
    }

    protected Object getAccessLevel(Element e) {
        Set<Modifier> mods = e.getModifiers();
        for (Modifier mod : MODS) {
            if (!mods.contains((Object)mod)) continue;
            return mod.name().toLowerCase();
        }
        return "default";
    }

    protected String getKindString(ElementKind kind) {
        switch (kind) {
            case ANNOTATION_TYPE: {
                return "annotation";
            }
            case CLASS: {
                return "class";
            }
            case ENUM: {
                return "enum";
            }
            case INTERFACE: {
                return "interface";
            }
            case CONSTRUCTOR: 
            case METHOD: 
            case INSTANCE_INIT: 
            case STATIC_INIT: {
                return "method";
            }
            case ENUM_CONSTANT: 
            case FIELD: {
                return "field";
            }
        }
        return null;
    }
}

