
IF (CAPSIMAGE_INCLUDE_DIR)
  # Already in cache, be silent
  SET(CAPSIMAGE_FIND_QUIETLY TRUE)
ENDIF (CAPSIMAGE_INCLUDE_DIR)


# Choose the library version to use : 4 or 5
SET(CAPSIMAGE_VERSION 4)


if(CAPSIMAGE_VERSION STREQUAL 4)
	SET(CAPSIMAGE_DIR caps)
	FIND_PATH(CAPSIMAGE_INCLUDE_DIR ${CAPSIMAGE_DIR}/capsimage.h)
else()
	SET(CAPSIMAGE_DIR caps5)
	FIND_PATH(CAPSIMAGE_INCLUDE_DIR ${CAPSIMAGE_DIR}/CapsAPI.h)
endif()

if(WIN32)
	FIND_LIBRARY(CAPSIMAGE_LIBRARY NAMES capsimg PATH_SUFFIXES ${CAPSIMAGE_DIR} )
else()
	FIND_LIBRARY(CAPSIMAGE_LIBRARY NAMES capsimage PATH_SUFFIXES ${CAPSIMAGE_DIR} )
endif(WIN32)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(CAPSIMAGE DEFAULT_MSG
                                  CAPSIMAGE_LIBRARY CAPSIMAGE_INCLUDE_DIR)


MARK_AS_ADVANCED(CAPSIMAGE_LIBRARY CAPSIMAGE_INCLUDE_DIR)
