{-# OPTIONS_HADDOCK hide #-}
--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.Rendering.OpenGL.Raw.Core31.Tokens
-- Copyright   :  (c) Sven Panne 2013
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
-- All tokens from the OpenGL 3.1 core, see <http://www.opengl.org/registry/>.
--
--------------------------------------------------------------------------------

module Graphics.Rendering.OpenGL.Raw.Core31.Tokens where

import Graphics.Rendering.OpenGL.Raw.Core31.Types

gl_ACTIVE_ATTRIBUTES :: GLenum
gl_ACTIVE_ATTRIBUTES = 0x8B89

gl_ACTIVE_ATTRIBUTE_MAX_LENGTH :: GLenum
gl_ACTIVE_ATTRIBUTE_MAX_LENGTH = 0x8B8A

gl_ACTIVE_TEXTURE :: GLenum
gl_ACTIVE_TEXTURE = 0x84E0

gl_ACTIVE_UNIFORMS :: GLenum
gl_ACTIVE_UNIFORMS = 0x8B86

gl_ACTIVE_UNIFORM_MAX_LENGTH :: GLenum
gl_ACTIVE_UNIFORM_MAX_LENGTH = 0x8B87

gl_ALIASED_LINE_WIDTH_RANGE :: GLenum
gl_ALIASED_LINE_WIDTH_RANGE = 0x846E

gl_ALPHA :: GLenum
gl_ALPHA = 0x1906

gl_ALWAYS :: GLenum
gl_ALWAYS = 0x0207

gl_AND :: GLenum
gl_AND = 0x1501

gl_AND_INVERTED :: GLenum
gl_AND_INVERTED = 0x1504

gl_AND_REVERSE :: GLenum
gl_AND_REVERSE = 0x1502

gl_ARRAY_BUFFER :: GLenum
gl_ARRAY_BUFFER = 0x8892

gl_ARRAY_BUFFER_BINDING :: GLenum
gl_ARRAY_BUFFER_BINDING = 0x8894

gl_ATTACHED_SHADERS :: GLenum
gl_ATTACHED_SHADERS = 0x8B85

gl_BACK :: GLenum
gl_BACK = 0x0405

gl_BACK_LEFT :: GLenum
gl_BACK_LEFT = 0x0402

gl_BACK_RIGHT :: GLenum
gl_BACK_RIGHT = 0x0403

gl_BGR :: GLenum
gl_BGR = 0x80E0

gl_BGRA :: GLenum
gl_BGRA = 0x80E1

gl_BGRA_INTEGER :: GLenum
gl_BGRA_INTEGER = 0x8D9B

gl_BGR_INTEGER :: GLenum
gl_BGR_INTEGER = 0x8D9A

gl_BLEND :: GLenum
gl_BLEND = 0x0BE2

gl_BLEND_COLOR :: GLenum
gl_BLEND_COLOR = 0x8005

gl_BLEND_DST :: GLenum
gl_BLEND_DST = 0x0BE0

gl_BLEND_DST_ALPHA :: GLenum
gl_BLEND_DST_ALPHA = 0x80CA

gl_BLEND_DST_RGB :: GLenum
gl_BLEND_DST_RGB = 0x80C8

gl_BLEND_EQUATION :: GLenum
gl_BLEND_EQUATION = 0x8009

gl_BLEND_EQUATION_ALPHA :: GLenum
gl_BLEND_EQUATION_ALPHA = 0x883D

gl_BLEND_EQUATION_RGB :: GLenum
gl_BLEND_EQUATION_RGB = 0x8009

gl_BLEND_SRC :: GLenum
gl_BLEND_SRC = 0x0BE1

gl_BLEND_SRC_ALPHA :: GLenum
gl_BLEND_SRC_ALPHA = 0x80CB

gl_BLEND_SRC_RGB :: GLenum
gl_BLEND_SRC_RGB = 0x80C9

gl_BLUE :: GLenum
gl_BLUE = 0x1905

gl_BLUE_INTEGER :: GLenum
gl_BLUE_INTEGER = 0x8D96

gl_BOOL :: GLenum
gl_BOOL = 0x8B56

gl_BOOL_VEC2 :: GLenum
gl_BOOL_VEC2 = 0x8B57

gl_BOOL_VEC3 :: GLenum
gl_BOOL_VEC3 = 0x8B58

gl_BOOL_VEC4 :: GLenum
gl_BOOL_VEC4 = 0x8B59

gl_BUFFER_ACCESS :: GLenum
gl_BUFFER_ACCESS = 0x88BB

gl_BUFFER_ACCESS_FLAGS :: GLenum
gl_BUFFER_ACCESS_FLAGS = 0x911F

gl_BUFFER_MAPPED :: GLenum
gl_BUFFER_MAPPED = 0x88BC

gl_BUFFER_MAP_LENGTH :: GLenum
gl_BUFFER_MAP_LENGTH = 0x9120

gl_BUFFER_MAP_OFFSET :: GLenum
gl_BUFFER_MAP_OFFSET = 0x9121

gl_BUFFER_MAP_POINTER :: GLenum
gl_BUFFER_MAP_POINTER = 0x88BD

gl_BUFFER_SIZE :: GLenum
gl_BUFFER_SIZE = 0x8764

gl_BUFFER_USAGE :: GLenum
gl_BUFFER_USAGE = 0x8765

gl_BYTE :: GLenum
gl_BYTE = 0x1400

gl_CCW :: GLenum
gl_CCW = 0x0901

gl_CLAMP_READ_COLOR :: GLenum
gl_CLAMP_READ_COLOR = 0x891C

gl_CLAMP_TO_BORDER :: GLenum
gl_CLAMP_TO_BORDER = 0x812D

gl_CLAMP_TO_EDGE :: GLenum
gl_CLAMP_TO_EDGE = 0x812F

gl_CLEAR :: GLenum
gl_CLEAR = 0x1500

gl_CLIP_DISTANCE0 :: GLenum
gl_CLIP_DISTANCE0 = 0x3000

gl_CLIP_DISTANCE1 :: GLenum
gl_CLIP_DISTANCE1 = 0x3001

gl_CLIP_DISTANCE2 :: GLenum
gl_CLIP_DISTANCE2 = 0x3002

gl_CLIP_DISTANCE3 :: GLenum
gl_CLIP_DISTANCE3 = 0x3003

gl_CLIP_DISTANCE4 :: GLenum
gl_CLIP_DISTANCE4 = 0x3004

gl_CLIP_DISTANCE5 :: GLenum
gl_CLIP_DISTANCE5 = 0x3005

gl_CLIP_DISTANCE6 :: GLenum
gl_CLIP_DISTANCE6 = 0x3006

gl_CLIP_DISTANCE7 :: GLenum
gl_CLIP_DISTANCE7 = 0x3007

gl_COLOR :: GLenum
gl_COLOR = 0x1800

gl_COLOR_ATTACHMENT0 :: GLenum
gl_COLOR_ATTACHMENT0 = 0x8CE0

gl_COLOR_ATTACHMENT1 :: GLenum
gl_COLOR_ATTACHMENT1 = 0x8CE1

gl_COLOR_ATTACHMENT10 :: GLenum
gl_COLOR_ATTACHMENT10 = 0x8CEA

gl_COLOR_ATTACHMENT11 :: GLenum
gl_COLOR_ATTACHMENT11 = 0x8CEB

gl_COLOR_ATTACHMENT12 :: GLenum
gl_COLOR_ATTACHMENT12 = 0x8CEC

gl_COLOR_ATTACHMENT13 :: GLenum
gl_COLOR_ATTACHMENT13 = 0x8CED

gl_COLOR_ATTACHMENT14 :: GLenum
gl_COLOR_ATTACHMENT14 = 0x8CEE

gl_COLOR_ATTACHMENT15 :: GLenum
gl_COLOR_ATTACHMENT15 = 0x8CEF

gl_COLOR_ATTACHMENT2 :: GLenum
gl_COLOR_ATTACHMENT2 = 0x8CE2

gl_COLOR_ATTACHMENT3 :: GLenum
gl_COLOR_ATTACHMENT3 = 0x8CE3

gl_COLOR_ATTACHMENT4 :: GLenum
gl_COLOR_ATTACHMENT4 = 0x8CE4

gl_COLOR_ATTACHMENT5 :: GLenum
gl_COLOR_ATTACHMENT5 = 0x8CE5

gl_COLOR_ATTACHMENT6 :: GLenum
gl_COLOR_ATTACHMENT6 = 0x8CE6

gl_COLOR_ATTACHMENT7 :: GLenum
gl_COLOR_ATTACHMENT7 = 0x8CE7

gl_COLOR_ATTACHMENT8 :: GLenum
gl_COLOR_ATTACHMENT8 = 0x8CE8

gl_COLOR_ATTACHMENT9 :: GLenum
gl_COLOR_ATTACHMENT9 = 0x8CE9

gl_COLOR_BUFFER_BIT :: GLbitfield
gl_COLOR_BUFFER_BIT = 0x00004000

gl_COLOR_CLEAR_VALUE :: GLenum
gl_COLOR_CLEAR_VALUE = 0x0C22

gl_COLOR_LOGIC_OP :: GLenum
gl_COLOR_LOGIC_OP = 0x0BF2

gl_COLOR_WRITEMASK :: GLenum
gl_COLOR_WRITEMASK = 0x0C23

gl_COMPARE_REF_TO_TEXTURE :: GLenum
gl_COMPARE_REF_TO_TEXTURE = 0x884E

gl_COMPILE_STATUS :: GLenum
gl_COMPILE_STATUS = 0x8B81

gl_COMPRESSED_RED :: GLenum
gl_COMPRESSED_RED = 0x8225

gl_COMPRESSED_RED_RGTC1 :: GLenum
gl_COMPRESSED_RED_RGTC1 = 0x8DBB

gl_COMPRESSED_RG :: GLenum
gl_COMPRESSED_RG = 0x8226

gl_COMPRESSED_RGB :: GLenum
gl_COMPRESSED_RGB = 0x84ED

gl_COMPRESSED_RGBA :: GLenum
gl_COMPRESSED_RGBA = 0x84EE

gl_COMPRESSED_RG_RGTC2 :: GLenum
gl_COMPRESSED_RG_RGTC2 = 0x8DBD

gl_COMPRESSED_SIGNED_RED_RGTC1 :: GLenum
gl_COMPRESSED_SIGNED_RED_RGTC1 = 0x8DBC

gl_COMPRESSED_SIGNED_RG_RGTC2 :: GLenum
gl_COMPRESSED_SIGNED_RG_RGTC2 = 0x8DBE

gl_COMPRESSED_SRGB :: GLenum
gl_COMPRESSED_SRGB = 0x8C48

gl_COMPRESSED_SRGB_ALPHA :: GLenum
gl_COMPRESSED_SRGB_ALPHA = 0x8C49

gl_COMPRESSED_TEXTURE_FORMATS :: GLenum
gl_COMPRESSED_TEXTURE_FORMATS = 0x86A3

gl_CONSTANT_ALPHA :: GLenum
gl_CONSTANT_ALPHA = 0x8003

gl_CONSTANT_COLOR :: GLenum
gl_CONSTANT_COLOR = 0x8001

gl_CONTEXT_FLAGS :: GLenum
gl_CONTEXT_FLAGS = 0x821E

gl_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT :: GLbitfield
gl_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = 0x0001

gl_COPY :: GLenum
gl_COPY = 0x1503

gl_COPY_INVERTED :: GLenum
gl_COPY_INVERTED = 0x150C

gl_CULL_FACE :: GLenum
gl_CULL_FACE = 0x0B44

gl_CULL_FACE_MODE :: GLenum
gl_CULL_FACE_MODE = 0x0B45

gl_CURRENT_PROGRAM :: GLenum
gl_CURRENT_PROGRAM = 0x8B8D

gl_CURRENT_QUERY :: GLenum
gl_CURRENT_QUERY = 0x8865

gl_CURRENT_VERTEX_ATTRIB :: GLenum
gl_CURRENT_VERTEX_ATTRIB = 0x8626

gl_CW :: GLenum
gl_CW = 0x0900

gl_DECR :: GLenum
gl_DECR = 0x1E03

gl_DECR_WRAP :: GLenum
gl_DECR_WRAP = 0x8508

gl_DELETE_STATUS :: GLenum
gl_DELETE_STATUS = 0x8B80

gl_DEPTH :: GLenum
gl_DEPTH = 0x1801

gl_DEPTH24_STENCIL8 :: GLenum
gl_DEPTH24_STENCIL8 = 0x88F0

gl_DEPTH32F_STENCIL8 :: GLenum
gl_DEPTH32F_STENCIL8 = 0x8CAD

gl_DEPTH_ATTACHMENT :: GLenum
gl_DEPTH_ATTACHMENT = 0x8D00

gl_DEPTH_BUFFER :: GLenum
gl_DEPTH_BUFFER = 0x8223

gl_DEPTH_BUFFER_BIT :: GLbitfield
gl_DEPTH_BUFFER_BIT = 0x00000100

gl_DEPTH_CLEAR_VALUE :: GLenum
gl_DEPTH_CLEAR_VALUE = 0x0B73

gl_DEPTH_COMPONENT :: GLenum
gl_DEPTH_COMPONENT = 0x1902

gl_DEPTH_COMPONENT16 :: GLenum
gl_DEPTH_COMPONENT16 = 0x81A5

gl_DEPTH_COMPONENT24 :: GLenum
gl_DEPTH_COMPONENT24 = 0x81A6

gl_DEPTH_COMPONENT32 :: GLenum
gl_DEPTH_COMPONENT32 = 0x81A7

gl_DEPTH_COMPONENT32F :: GLenum
gl_DEPTH_COMPONENT32F = 0x8CAC

gl_DEPTH_FUNC :: GLenum
gl_DEPTH_FUNC = 0x0B74

gl_DEPTH_RANGE :: GLenum
gl_DEPTH_RANGE = 0x0B70

gl_DEPTH_STENCIL :: GLenum
gl_DEPTH_STENCIL = 0x84F9

gl_DEPTH_STENCIL_ATTACHMENT :: GLenum
gl_DEPTH_STENCIL_ATTACHMENT = 0x821A

gl_DEPTH_TEST :: GLenum
gl_DEPTH_TEST = 0x0B71

gl_DEPTH_WRITEMASK :: GLenum
gl_DEPTH_WRITEMASK = 0x0B72

gl_DITHER :: GLenum
gl_DITHER = 0x0BD0

gl_DONT_CARE :: GLenum
gl_DONT_CARE = 0x1100

gl_DOUBLE :: GLenum
gl_DOUBLE = 0x140A

gl_DOUBLEBUFFER :: GLenum
gl_DOUBLEBUFFER = 0x0C32

gl_DRAW_BUFFER :: GLenum
gl_DRAW_BUFFER = 0x0C01

gl_DRAW_BUFFER0 :: GLenum
gl_DRAW_BUFFER0 = 0x8825

gl_DRAW_BUFFER1 :: GLenum
gl_DRAW_BUFFER1 = 0x8826

gl_DRAW_BUFFER10 :: GLenum
gl_DRAW_BUFFER10 = 0x882F

gl_DRAW_BUFFER11 :: GLenum
gl_DRAW_BUFFER11 = 0x8830

gl_DRAW_BUFFER12 :: GLenum
gl_DRAW_BUFFER12 = 0x8831

gl_DRAW_BUFFER13 :: GLenum
gl_DRAW_BUFFER13 = 0x8832

gl_DRAW_BUFFER14 :: GLenum
gl_DRAW_BUFFER14 = 0x8833

gl_DRAW_BUFFER15 :: GLenum
gl_DRAW_BUFFER15 = 0x8834

gl_DRAW_BUFFER2 :: GLenum
gl_DRAW_BUFFER2 = 0x8827

gl_DRAW_BUFFER3 :: GLenum
gl_DRAW_BUFFER3 = 0x8828

gl_DRAW_BUFFER4 :: GLenum
gl_DRAW_BUFFER4 = 0x8829

gl_DRAW_BUFFER5 :: GLenum
gl_DRAW_BUFFER5 = 0x882A

gl_DRAW_BUFFER6 :: GLenum
gl_DRAW_BUFFER6 = 0x882B

gl_DRAW_BUFFER7 :: GLenum
gl_DRAW_BUFFER7 = 0x882C

gl_DRAW_BUFFER8 :: GLenum
gl_DRAW_BUFFER8 = 0x882D

gl_DRAW_BUFFER9 :: GLenum
gl_DRAW_BUFFER9 = 0x882E

gl_DRAW_FRAMEBUFFER :: GLenum
gl_DRAW_FRAMEBUFFER = 0x8CA9

gl_DRAW_FRAMEBUFFER_BINDING :: GLenum
gl_DRAW_FRAMEBUFFER_BINDING = gl_FRAMEBUFFER_BINDING

gl_DST_ALPHA :: GLenum
gl_DST_ALPHA = 0x0304

gl_DST_COLOR :: GLenum
gl_DST_COLOR = 0x0306

gl_DYNAMIC_COPY :: GLenum
gl_DYNAMIC_COPY = 0x88EA

gl_DYNAMIC_DRAW :: GLenum
gl_DYNAMIC_DRAW = 0x88E8

gl_DYNAMIC_READ :: GLenum
gl_DYNAMIC_READ = 0x88E9

gl_ELEMENT_ARRAY_BUFFER :: GLenum
gl_ELEMENT_ARRAY_BUFFER = 0x8893

gl_ELEMENT_ARRAY_BUFFER_BINDING :: GLenum
gl_ELEMENT_ARRAY_BUFFER_BINDING = 0x8895

gl_EQUAL :: GLenum
gl_EQUAL = 0x0202

gl_EQUIV :: GLenum
gl_EQUIV = 0x1509

gl_EXTENSIONS :: GLenum
gl_EXTENSIONS = 0x1F03

gl_FALSE :: GLenum
gl_FALSE = 0

gl_FASTEST :: GLenum
gl_FASTEST = 0x1101

gl_FILL :: GLenum
gl_FILL = 0x1B02

gl_FIXED_ONLY :: GLenum
gl_FIXED_ONLY = 0x891D

gl_FLOAT :: GLenum
gl_FLOAT = 0x1406

gl_FLOAT_32_UNSIGNED_INT_24_8_REV :: GLenum
gl_FLOAT_32_UNSIGNED_INT_24_8_REV = 0x8DAD

gl_FLOAT_MAT2 :: GLenum
gl_FLOAT_MAT2 = 0x8B5A

gl_FLOAT_MAT2x3 :: GLenum
gl_FLOAT_MAT2x3 = 0x8B65

gl_FLOAT_MAT2x4 :: GLenum
gl_FLOAT_MAT2x4 = 0x8B66

gl_FLOAT_MAT3 :: GLenum
gl_FLOAT_MAT3 = 0x8B5B

gl_FLOAT_MAT3x2 :: GLenum
gl_FLOAT_MAT3x2 = 0x8B67

gl_FLOAT_MAT3x4 :: GLenum
gl_FLOAT_MAT3x4 = 0x8B68

gl_FLOAT_MAT4 :: GLenum
gl_FLOAT_MAT4 = 0x8B5C

gl_FLOAT_MAT4x2 :: GLenum
gl_FLOAT_MAT4x2 = 0x8B69

gl_FLOAT_MAT4x3 :: GLenum
gl_FLOAT_MAT4x3 = 0x8B6A

gl_FLOAT_VEC2 :: GLenum
gl_FLOAT_VEC2 = 0x8B50

gl_FLOAT_VEC3 :: GLenum
gl_FLOAT_VEC3 = 0x8B51

gl_FLOAT_VEC4 :: GLenum
gl_FLOAT_VEC4 = 0x8B52

gl_FRAGMENT_SHADER :: GLenum
gl_FRAGMENT_SHADER = 0x8B30

gl_FRAGMENT_SHADER_DERIVATIVE_HINT :: GLenum
gl_FRAGMENT_SHADER_DERIVATIVE_HINT = 0x8B8B

gl_FRAMEBUFFER :: GLenum
gl_FRAMEBUFFER = 0x8D40

gl_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = 0x8215

gl_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = 0x8214

gl_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = 0x8210

gl_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = 0x8211

gl_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = 0x8216

gl_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = 0x8213

gl_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = 0x8CD1

gl_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = 0x8CD0

gl_FRAMEBUFFER_ATTACHMENT_RED_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_RED_SIZE = 0x8212

gl_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = 0x8217

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = 0x8CD3

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = 0x8CD4

gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL :: GLenum
gl_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = 0x8CD2

gl_FRAMEBUFFER_BINDING :: GLenum
gl_FRAMEBUFFER_BINDING = 0x8CA6

gl_FRAMEBUFFER_COMPLETE :: GLenum
gl_FRAMEBUFFER_COMPLETE = 0x8CD5

gl_FRAMEBUFFER_DEFAULT :: GLenum
gl_FRAMEBUFFER_DEFAULT = 0x8218

gl_FRAMEBUFFER_INCOMPLETE_ATTACHMENT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 0x8CD6

gl_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = 0x8CDB

gl_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 0x8CD7

gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = 0x8D56

gl_FRAMEBUFFER_INCOMPLETE_READ_BUFFER :: GLenum
gl_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = 0x8CDC

gl_FRAMEBUFFER_SRGB :: GLenum
gl_FRAMEBUFFER_SRGB = 0x8DB9

gl_FRAMEBUFFER_UNDEFINED :: GLenum
gl_FRAMEBUFFER_UNDEFINED = 0x8219

gl_FRAMEBUFFER_UNSUPPORTED :: GLenum
gl_FRAMEBUFFER_UNSUPPORTED = 0x8CDD

gl_FRONT :: GLenum
gl_FRONT = 0x0404

gl_FRONT_AND_BACK :: GLenum
gl_FRONT_AND_BACK = 0x0408

gl_FRONT_FACE :: GLenum
gl_FRONT_FACE = 0x0B46

gl_FRONT_LEFT :: GLenum
gl_FRONT_LEFT = 0x0400

gl_FRONT_RIGHT :: GLenum
gl_FRONT_RIGHT = 0x0401

gl_FUNC_ADD :: GLenum
gl_FUNC_ADD = 0x8006

gl_FUNC_REVERSE_SUBTRACT :: GLenum
gl_FUNC_REVERSE_SUBTRACT = 0x800B

gl_FUNC_SUBTRACT :: GLenum
gl_FUNC_SUBTRACT = 0x800A

gl_GEQUAL :: GLenum
gl_GEQUAL = 0x0206

gl_GREATER :: GLenum
gl_GREATER = 0x0204

gl_GREEN :: GLenum
gl_GREEN = 0x1904

gl_GREEN_INTEGER :: GLenum
gl_GREEN_INTEGER = 0x8D95

gl_HALF_FLOAT :: GLenum
gl_HALF_FLOAT = 0x140B

gl_INCR :: GLenum
gl_INCR = 0x1E02

gl_INCR_WRAP :: GLenum
gl_INCR_WRAP = 0x8507

gl_INFO_LOG_LENGTH :: GLenum
gl_INFO_LOG_LENGTH = 0x8B84

gl_INT :: GLenum
gl_INT = 0x1404

gl_INTERLEAVED_ATTRIBS :: GLenum
gl_INTERLEAVED_ATTRIBS = 0x8C8C

gl_INT_SAMPLER_1D :: GLenum
gl_INT_SAMPLER_1D = 0x8DC9

gl_INT_SAMPLER_1D_ARRAY :: GLenum
gl_INT_SAMPLER_1D_ARRAY = 0x8DCE

gl_INT_SAMPLER_2D :: GLenum
gl_INT_SAMPLER_2D = 0x8DCA

gl_INT_SAMPLER_2D_ARRAY :: GLenum
gl_INT_SAMPLER_2D_ARRAY = 0x8DCF

gl_INT_SAMPLER_2D_RECT :: GLenum
gl_INT_SAMPLER_2D_RECT = 0x8DCD

gl_INT_SAMPLER_3D :: GLenum
gl_INT_SAMPLER_3D = 0x8DCB

gl_INT_SAMPLER_BUFFER :: GLenum
gl_INT_SAMPLER_BUFFER = 0x8DD0

gl_INT_SAMPLER_CUBE :: GLenum
gl_INT_SAMPLER_CUBE = 0x8DCC

gl_INT_VEC2 :: GLenum
gl_INT_VEC2 = 0x8B53

gl_INT_VEC3 :: GLenum
gl_INT_VEC3 = 0x8B54

gl_INT_VEC4 :: GLenum
gl_INT_VEC4 = 0x8B55

gl_INVALID_ENUM :: GLenum
gl_INVALID_ENUM = 0x0500

gl_INVALID_FRAMEBUFFER_OPERATION :: GLenum
gl_INVALID_FRAMEBUFFER_OPERATION = 0x0506

gl_INVALID_OPERATION :: GLenum
gl_INVALID_OPERATION = 0x0502

gl_INVALID_VALUE :: GLenum
gl_INVALID_VALUE = 0x0501

gl_INVERT :: GLenum
gl_INVERT = 0x150A

gl_KEEP :: GLenum
gl_KEEP = 0x1E00

gl_LEFT :: GLenum
gl_LEFT = 0x0406

gl_LEQUAL :: GLenum
gl_LEQUAL = 0x0203

gl_LESS :: GLenum
gl_LESS = 0x0201

gl_LINE :: GLenum
gl_LINE = 0x1B01

gl_LINEAR :: GLenum
gl_LINEAR = 0x2601

gl_LINEAR_MIPMAP_LINEAR :: GLenum
gl_LINEAR_MIPMAP_LINEAR = 0x2703

gl_LINEAR_MIPMAP_NEAREST :: GLenum
gl_LINEAR_MIPMAP_NEAREST = 0x2701

gl_LINES :: GLenum
gl_LINES = 0x0001

gl_LINE_LOOP :: GLenum
gl_LINE_LOOP = 0x0002

gl_LINE_SMOOTH :: GLenum
gl_LINE_SMOOTH = 0x0B20

gl_LINE_SMOOTH_HINT :: GLenum
gl_LINE_SMOOTH_HINT = 0x0C52

gl_LINE_STRIP :: GLenum
gl_LINE_STRIP = 0x0003

gl_LINE_WIDTH :: GLenum
gl_LINE_WIDTH = 0x0B21

gl_LINE_WIDTH_GRANULARITY :: GLenum
gl_LINE_WIDTH_GRANULARITY = 0x0B23

gl_LINE_WIDTH_RANGE :: GLenum
gl_LINE_WIDTH_RANGE = 0x0B22

gl_LINK_STATUS :: GLenum
gl_LINK_STATUS = 0x8B82

gl_LOGIC_OP_MODE :: GLenum
gl_LOGIC_OP_MODE = 0x0BF0

gl_LOWER_LEFT :: GLenum
gl_LOWER_LEFT = 0x8CA1

gl_MAJOR_VERSION :: GLenum
gl_MAJOR_VERSION = 0x821B

gl_MAP_FLUSH_EXPLICIT_BIT :: GLbitfield
gl_MAP_FLUSH_EXPLICIT_BIT = 0x0010

gl_MAP_INVALIDATE_BUFFER_BIT :: GLbitfield
gl_MAP_INVALIDATE_BUFFER_BIT = 0x0008

gl_MAP_INVALIDATE_RANGE_BIT :: GLbitfield
gl_MAP_INVALIDATE_RANGE_BIT = 0x0004

gl_MAP_READ_BIT :: GLbitfield
gl_MAP_READ_BIT = 0x0001

gl_MAP_UNSYNCHRONIZED_BIT :: GLbitfield
gl_MAP_UNSYNCHRONIZED_BIT = 0x0020

gl_MAP_WRITE_BIT :: GLbitfield
gl_MAP_WRITE_BIT = 0x0002

gl_MAX :: GLenum
gl_MAX = 0x8008

gl_MAX_3D_TEXTURE_SIZE :: GLenum
gl_MAX_3D_TEXTURE_SIZE = 0x8073

gl_MAX_ARRAY_TEXTURE_LAYERS :: GLenum
gl_MAX_ARRAY_TEXTURE_LAYERS = 0x88FF

gl_MAX_CLIP_DISTANCES :: GLenum
gl_MAX_CLIP_DISTANCES = 0x0D32

gl_MAX_COLOR_ATTACHMENTS :: GLenum
gl_MAX_COLOR_ATTACHMENTS = 0x8CDF

gl_MAX_COMBINED_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 0x8B4D

gl_MAX_CUBE_MAP_TEXTURE_SIZE :: GLenum
gl_MAX_CUBE_MAP_TEXTURE_SIZE = 0x851C

gl_MAX_DRAW_BUFFERS :: GLenum
gl_MAX_DRAW_BUFFERS = 0x8824

gl_MAX_ELEMENTS_INDICES :: GLenum
gl_MAX_ELEMENTS_INDICES = 0x80E9

gl_MAX_ELEMENTS_VERTICES :: GLenum
gl_MAX_ELEMENTS_VERTICES = 0x80E8

gl_MAX_FRAGMENT_UNIFORM_COMPONENTS :: GLenum
gl_MAX_FRAGMENT_UNIFORM_COMPONENTS = 0x8B49

gl_MAX_PROGRAM_TEXEL_OFFSET :: GLenum
gl_MAX_PROGRAM_TEXEL_OFFSET = 0x8905

gl_MAX_RENDERBUFFER_SIZE :: GLenum
gl_MAX_RENDERBUFFER_SIZE = 0x84E8

gl_MAX_SAMPLES :: GLenum
gl_MAX_SAMPLES = 0x8D57

gl_MAX_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_TEXTURE_IMAGE_UNITS = 0x8872

gl_MAX_TEXTURE_LOD_BIAS :: GLenum
gl_MAX_TEXTURE_LOD_BIAS = 0x84FD

gl_MAX_TEXTURE_SIZE :: GLenum
gl_MAX_TEXTURE_SIZE = 0x0D33

gl_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = 0x8C8A

gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = 0x8C8B

gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS :: GLenum
gl_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = 0x8C80

gl_MAX_VARYING_COMPONENTS :: GLenum
gl_MAX_VARYING_COMPONENTS = 0x8B4B

gl_MAX_VARYING_FLOATS :: GLenum
gl_MAX_VARYING_FLOATS = 0x8B4B

gl_MAX_VERTEX_ATTRIBS :: GLenum
gl_MAX_VERTEX_ATTRIBS = 0x8869

gl_MAX_VERTEX_TEXTURE_IMAGE_UNITS :: GLenum
gl_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 0x8B4C

gl_MAX_VERTEX_UNIFORM_COMPONENTS :: GLenum
gl_MAX_VERTEX_UNIFORM_COMPONENTS = 0x8B4A

gl_MAX_VIEWPORT_DIMS :: GLenum
gl_MAX_VIEWPORT_DIMS = 0x0D3A

gl_MIN :: GLenum
gl_MIN = 0x8007

gl_MINOR_VERSION :: GLenum
gl_MINOR_VERSION = 0x821C

gl_MIN_PROGRAM_TEXEL_OFFSET :: GLenum
gl_MIN_PROGRAM_TEXEL_OFFSET = 0x8904

gl_MIRRORED_REPEAT :: GLenum
gl_MIRRORED_REPEAT = 0x8370

gl_MULTISAMPLE :: GLenum
gl_MULTISAMPLE = 0x809D

gl_NAND :: GLenum
gl_NAND = 0x150E

gl_NEAREST :: GLenum
gl_NEAREST = 0x2600

gl_NEAREST_MIPMAP_LINEAR :: GLenum
gl_NEAREST_MIPMAP_LINEAR = 0x2702

gl_NEAREST_MIPMAP_NEAREST :: GLenum
gl_NEAREST_MIPMAP_NEAREST = 0x2700

gl_NEVER :: GLenum
gl_NEVER = 0x0200

gl_NICEST :: GLenum
gl_NICEST = 0x1102

gl_NONE :: GLenum
gl_NONE = 0

gl_NOOP :: GLenum
gl_NOOP = 0x1505

gl_NOR :: GLenum
gl_NOR = 0x1508

gl_NOTEQUAL :: GLenum
gl_NOTEQUAL = 0x0205

gl_NO_ERROR :: GLenum
gl_NO_ERROR = 0

gl_NUM_COMPRESSED_TEXTURE_FORMATS :: GLenum
gl_NUM_COMPRESSED_TEXTURE_FORMATS = 0x86A2

gl_NUM_EXTENSIONS :: GLenum
gl_NUM_EXTENSIONS = 0x821D

gl_ONE :: GLenum
gl_ONE = 1

gl_ONE_MINUS_CONSTANT_ALPHA :: GLenum
gl_ONE_MINUS_CONSTANT_ALPHA = 0x8004

gl_ONE_MINUS_CONSTANT_COLOR :: GLenum
gl_ONE_MINUS_CONSTANT_COLOR = 0x8002

gl_ONE_MINUS_DST_ALPHA :: GLenum
gl_ONE_MINUS_DST_ALPHA = 0x0305

gl_ONE_MINUS_DST_COLOR :: GLenum
gl_ONE_MINUS_DST_COLOR = 0x0307

gl_ONE_MINUS_SRC_ALPHA :: GLenum
gl_ONE_MINUS_SRC_ALPHA = 0x0303

gl_ONE_MINUS_SRC_COLOR :: GLenum
gl_ONE_MINUS_SRC_COLOR = 0x0301

gl_OR :: GLenum
gl_OR = 0x1507

gl_OR_INVERTED :: GLenum
gl_OR_INVERTED = 0x150D

gl_OR_REVERSE :: GLenum
gl_OR_REVERSE = 0x150B

gl_OUT_OF_MEMORY :: GLenum
gl_OUT_OF_MEMORY = 0x0505

gl_PACK_ALIGNMENT :: GLenum
gl_PACK_ALIGNMENT = 0x0D05

gl_PACK_IMAGE_HEIGHT :: GLenum
gl_PACK_IMAGE_HEIGHT = 0x806C

gl_PACK_LSB_FIRST :: GLenum
gl_PACK_LSB_FIRST = 0x0D01

gl_PACK_ROW_LENGTH :: GLenum
gl_PACK_ROW_LENGTH = 0x0D02

gl_PACK_SKIP_IMAGES :: GLenum
gl_PACK_SKIP_IMAGES = 0x806B

gl_PACK_SKIP_PIXELS :: GLenum
gl_PACK_SKIP_PIXELS = 0x0D04

gl_PACK_SKIP_ROWS :: GLenum
gl_PACK_SKIP_ROWS = 0x0D03

gl_PACK_SWAP_BYTES :: GLenum
gl_PACK_SWAP_BYTES = 0x0D00

gl_PIXEL_PACK_BUFFER :: GLenum
gl_PIXEL_PACK_BUFFER = 0x88EB

gl_PIXEL_PACK_BUFFER_BINDING :: GLenum
gl_PIXEL_PACK_BUFFER_BINDING = 0x88ED

gl_PIXEL_UNPACK_BUFFER :: GLenum
gl_PIXEL_UNPACK_BUFFER = 0x88EC

gl_PIXEL_UNPACK_BUFFER_BINDING :: GLenum
gl_PIXEL_UNPACK_BUFFER_BINDING = 0x88EF

gl_POINT :: GLenum
gl_POINT = 0x1B00

gl_POINTS :: GLenum
gl_POINTS = 0x0000

gl_POINT_FADE_THRESHOLD_SIZE :: GLenum
gl_POINT_FADE_THRESHOLD_SIZE = 0x8128

gl_POINT_SIZE :: GLenum
gl_POINT_SIZE = 0x0B11

gl_POINT_SIZE_GRANULARITY :: GLenum
gl_POINT_SIZE_GRANULARITY = 0x0B13

gl_POINT_SIZE_RANGE :: GLenum
gl_POINT_SIZE_RANGE = 0x0B12

gl_POINT_SPRITE_COORD_ORIGIN :: GLenum
gl_POINT_SPRITE_COORD_ORIGIN = 0x8CA0

gl_POLYGON_OFFSET_FACTOR :: GLenum
gl_POLYGON_OFFSET_FACTOR = 0x8038

gl_POLYGON_OFFSET_FILL :: GLenum
gl_POLYGON_OFFSET_FILL = 0x8037

gl_POLYGON_OFFSET_LINE :: GLenum
gl_POLYGON_OFFSET_LINE = 0x2A02

gl_POLYGON_OFFSET_POINT :: GLenum
gl_POLYGON_OFFSET_POINT = 0x2A01

gl_POLYGON_OFFSET_UNITS :: GLenum
gl_POLYGON_OFFSET_UNITS = 0x2A00

gl_POLYGON_SMOOTH :: GLenum
gl_POLYGON_SMOOTH = 0x0B41

gl_POLYGON_SMOOTH_HINT :: GLenum
gl_POLYGON_SMOOTH_HINT = 0x0C53

gl_PRIMITIVES_GENERATED :: GLenum
gl_PRIMITIVES_GENERATED = 0x8C87

gl_PRIMITIVE_RESTART :: GLenum
gl_PRIMITIVE_RESTART = 0x8F9D

gl_PRIMITIVE_RESTART_INDEX :: GLenum
gl_PRIMITIVE_RESTART_INDEX = 0x8F9E

gl_PROXY_TEXTURE_1D :: GLenum
gl_PROXY_TEXTURE_1D = 0x8063

gl_PROXY_TEXTURE_1D_ARRAY :: GLenum
gl_PROXY_TEXTURE_1D_ARRAY = 0x8C19

gl_PROXY_TEXTURE_2D :: GLenum
gl_PROXY_TEXTURE_2D = 0x8064

gl_PROXY_TEXTURE_2D_ARRAY :: GLenum
gl_PROXY_TEXTURE_2D_ARRAY = 0x8C1B

gl_PROXY_TEXTURE_3D :: GLenum
gl_PROXY_TEXTURE_3D = 0x8070

gl_PROXY_TEXTURE_CUBE_MAP :: GLenum
gl_PROXY_TEXTURE_CUBE_MAP = 0x851B

gl_QUERY_BY_REGION_NO_WAIT :: GLenum
gl_QUERY_BY_REGION_NO_WAIT = 0x8E16

gl_QUERY_BY_REGION_WAIT :: GLenum
gl_QUERY_BY_REGION_WAIT = 0x8E15

gl_QUERY_COUNTER_BITS :: GLenum
gl_QUERY_COUNTER_BITS = 0x8864

gl_QUERY_NO_WAIT :: GLenum
gl_QUERY_NO_WAIT = 0x8E14

gl_QUERY_RESULT :: GLenum
gl_QUERY_RESULT = 0x8866

gl_QUERY_RESULT_AVAILABLE :: GLenum
gl_QUERY_RESULT_AVAILABLE = 0x8867

gl_QUERY_WAIT :: GLenum
gl_QUERY_WAIT = 0x8E13

gl_R11F_G11F_B10F :: GLenum
gl_R11F_G11F_B10F = 0x8C3A

gl_R16 :: GLenum
gl_R16 = 0x822A

gl_R16F :: GLenum
gl_R16F = 0x822D

gl_R16I :: GLenum
gl_R16I = 0x8233

gl_R16UI :: GLenum
gl_R16UI = 0x8234

gl_R16_SNORM :: GLenum
gl_R16_SNORM = 0x8F98

gl_R32F :: GLenum
gl_R32F = 0x822E

gl_R32I :: GLenum
gl_R32I = 0x8235

gl_R32UI :: GLenum
gl_R32UI = 0x8236

gl_R3_G3_B2 :: GLenum
gl_R3_G3_B2 = 0x2A10

gl_R8 :: GLenum
gl_R8 = 0x8229

gl_R8I :: GLenum
gl_R8I = 0x8231

gl_R8UI :: GLenum
gl_R8UI = 0x8232

gl_R8_SNORM :: GLenum
gl_R8_SNORM = 0x8F94

gl_RASTERIZER_DISCARD :: GLenum
gl_RASTERIZER_DISCARD = 0x8C89

gl_READ_BUFFER :: GLenum
gl_READ_BUFFER = 0x0C02

gl_READ_FRAMEBUFFER :: GLenum
gl_READ_FRAMEBUFFER = 0x8CA8

gl_READ_FRAMEBUFFER_BINDING :: GLenum
gl_READ_FRAMEBUFFER_BINDING = 0x8CAA

gl_READ_ONLY :: GLenum
gl_READ_ONLY = 0x88B8

gl_READ_WRITE :: GLenum
gl_READ_WRITE = 0x88BA

gl_RED :: GLenum
gl_RED = 0x1903

gl_RED_INTEGER :: GLenum
gl_RED_INTEGER = 0x8D94

gl_RED_SNORM :: GLenum
gl_RED_SNORM = 0x8F90

gl_RENDERBUFFER :: GLenum
gl_RENDERBUFFER = 0x8D41

gl_RENDERBUFFER_ALPHA_SIZE :: GLenum
gl_RENDERBUFFER_ALPHA_SIZE = 0x8D53

gl_RENDERBUFFER_BINDING :: GLenum
gl_RENDERBUFFER_BINDING = 0x8CA7

gl_RENDERBUFFER_BLUE_SIZE :: GLenum
gl_RENDERBUFFER_BLUE_SIZE = 0x8D52

gl_RENDERBUFFER_DEPTH_SIZE :: GLenum
gl_RENDERBUFFER_DEPTH_SIZE = 0x8D54

gl_RENDERBUFFER_GREEN_SIZE :: GLenum
gl_RENDERBUFFER_GREEN_SIZE = 0x8D51

gl_RENDERBUFFER_HEIGHT :: GLenum
gl_RENDERBUFFER_HEIGHT = 0x8D43

gl_RENDERBUFFER_INTERNAL_FORMAT :: GLenum
gl_RENDERBUFFER_INTERNAL_FORMAT = 0x8D44

gl_RENDERBUFFER_RED_SIZE :: GLenum
gl_RENDERBUFFER_RED_SIZE = 0x8D50

gl_RENDERBUFFER_SAMPLES :: GLenum
gl_RENDERBUFFER_SAMPLES = 0x8CAB

gl_RENDERBUFFER_STENCIL_SIZE :: GLenum
gl_RENDERBUFFER_STENCIL_SIZE = 0x8D55

gl_RENDERBUFFER_WIDTH :: GLenum
gl_RENDERBUFFER_WIDTH = 0x8D42

gl_RENDERER :: GLenum
gl_RENDERER = 0x1F01

gl_REPEAT :: GLenum
gl_REPEAT = 0x2901

gl_REPLACE :: GLenum
gl_REPLACE = 0x1E01

gl_RG :: GLenum
gl_RG = 0x8227

gl_RG16 :: GLenum
gl_RG16 = 0x822C

gl_RG16F :: GLenum
gl_RG16F = 0x822F

gl_RG16I :: GLenum
gl_RG16I = 0x8239

gl_RG16UI :: GLenum
gl_RG16UI = 0x823A

gl_RG16_SNORM :: GLenum
gl_RG16_SNORM = 0x8F99

gl_RG32F :: GLenum
gl_RG32F = 0x8230

gl_RG32I :: GLenum
gl_RG32I = 0x823B

gl_RG32UI :: GLenum
gl_RG32UI = 0x823C

gl_RG8 :: GLenum
gl_RG8 = 0x822B

gl_RG8I :: GLenum
gl_RG8I = 0x8237

gl_RG8UI :: GLenum
gl_RG8UI = 0x8238

gl_RG8_SNORM :: GLenum
gl_RG8_SNORM = 0x8F95

gl_RGB :: GLenum
gl_RGB = 0x1907

gl_RGB10 :: GLenum
gl_RGB10 = 0x8052

gl_RGB10_A2 :: GLenum
gl_RGB10_A2 = 0x8059

gl_RGB12 :: GLenum
gl_RGB12 = 0x8053

gl_RGB16 :: GLenum
gl_RGB16 = 0x8054

gl_RGB16F :: GLenum
gl_RGB16F = 0x881B

gl_RGB16I :: GLenum
gl_RGB16I = 0x8D89

gl_RGB16UI :: GLenum
gl_RGB16UI = 0x8D77

gl_RGB16_SNORM :: GLenum
gl_RGB16_SNORM = 0x8F9A

gl_RGB32F :: GLenum
gl_RGB32F = 0x8815

gl_RGB32I :: GLenum
gl_RGB32I = 0x8D83

gl_RGB32UI :: GLenum
gl_RGB32UI = 0x8D71

gl_RGB4 :: GLenum
gl_RGB4 = 0x804F

gl_RGB5 :: GLenum
gl_RGB5 = 0x8050

gl_RGB5_A1 :: GLenum
gl_RGB5_A1 = 0x8057

gl_RGB8 :: GLenum
gl_RGB8 = 0x8051

gl_RGB8I :: GLenum
gl_RGB8I = 0x8D8F

gl_RGB8UI :: GLenum
gl_RGB8UI = 0x8D7D

gl_RGB8_SNORM :: GLenum
gl_RGB8_SNORM = 0x8F96

gl_RGB9_E5 :: GLenum
gl_RGB9_E5 = 0x8C3D

gl_RGBA :: GLenum
gl_RGBA = 0x1908

gl_RGBA12 :: GLenum
gl_RGBA12 = 0x805A

gl_RGBA16 :: GLenum
gl_RGBA16 = 0x805B

gl_RGBA16F :: GLenum
gl_RGBA16F = 0x881A

gl_RGBA16I :: GLenum
gl_RGBA16I = 0x8D88

gl_RGBA16UI :: GLenum
gl_RGBA16UI = 0x8D76

gl_RGBA16_SNORM :: GLenum
gl_RGBA16_SNORM = 0x8F9B

gl_RGBA2 :: GLenum
gl_RGBA2 = 0x8055

gl_RGBA32F :: GLenum
gl_RGBA32F = 0x8814

gl_RGBA32I :: GLenum
gl_RGBA32I = 0x8D82

gl_RGBA32UI :: GLenum
gl_RGBA32UI = 0x8D70

gl_RGBA4 :: GLenum
gl_RGBA4 = 0x8056

gl_RGBA8 :: GLenum
gl_RGBA8 = 0x8058

gl_RGBA8I :: GLenum
gl_RGBA8I = 0x8D8E

gl_RGBA8UI :: GLenum
gl_RGBA8UI = 0x8D7C

gl_RGBA8_SNORM :: GLenum
gl_RGBA8_SNORM = 0x8F97

gl_RGBA_INTEGER :: GLenum
gl_RGBA_INTEGER = 0x8D99

gl_RGBA_SNORM :: GLenum
gl_RGBA_SNORM = 0x8F93

gl_RGB_INTEGER :: GLenum
gl_RGB_INTEGER = 0x8D98

gl_RGB_SNORM :: GLenum
gl_RGB_SNORM = 0x8F92

gl_RG_INTEGER :: GLenum
gl_RG_INTEGER = 0x8228

gl_RG_SNORM :: GLenum
gl_RG_SNORM = 0x8F91

gl_RIGHT :: GLenum
gl_RIGHT = 0x0407

gl_SAMPLER_1D :: GLenum
gl_SAMPLER_1D = 0x8B5D

gl_SAMPLER_1D_ARRAY :: GLenum
gl_SAMPLER_1D_ARRAY = 0x8DC0

gl_SAMPLER_1D_ARRAY_SHADOW :: GLenum
gl_SAMPLER_1D_ARRAY_SHADOW = 0x8DC3

gl_SAMPLER_1D_SHADOW :: GLenum
gl_SAMPLER_1D_SHADOW = 0x8B61

gl_SAMPLER_2D :: GLenum
gl_SAMPLER_2D = 0x8B5E

gl_SAMPLER_2D_ARRAY :: GLenum
gl_SAMPLER_2D_ARRAY = 0x8DC1

gl_SAMPLER_2D_ARRAY_SHADOW :: GLenum
gl_SAMPLER_2D_ARRAY_SHADOW = 0x8DC4

gl_SAMPLER_2D_SHADOW :: GLenum
gl_SAMPLER_2D_SHADOW = 0x8B62

gl_SAMPLER_3D :: GLenum
gl_SAMPLER_3D = 0x8B5F

gl_SAMPLER_BUFFER :: GLenum
gl_SAMPLER_BUFFER = 0x8DC2

gl_SAMPLER_CUBE :: GLenum
gl_SAMPLER_CUBE = 0x8B60

gl_SAMPLER_CUBE_SHADOW :: GLenum
gl_SAMPLER_CUBE_SHADOW = 0x8DC5

gl_SAMPLES :: GLenum
gl_SAMPLES = 0x80A9

gl_SAMPLES_PASSED :: GLenum
gl_SAMPLES_PASSED = 0x8914

gl_SAMPLE_ALPHA_TO_COVERAGE :: GLenum
gl_SAMPLE_ALPHA_TO_COVERAGE = 0x809E

gl_SAMPLE_ALPHA_TO_ONE :: GLenum
gl_SAMPLE_ALPHA_TO_ONE = 0x809F

gl_SAMPLE_BUFFERS :: GLenum
gl_SAMPLE_BUFFERS = 0x80A8

gl_SAMPLE_COVERAGE :: GLenum
gl_SAMPLE_COVERAGE = 0x80A0

gl_SAMPLE_COVERAGE_INVERT :: GLenum
gl_SAMPLE_COVERAGE_INVERT = 0x80AB

gl_SAMPLE_COVERAGE_VALUE :: GLenum
gl_SAMPLE_COVERAGE_VALUE = 0x80AA

gl_SCISSOR_BOX :: GLenum
gl_SCISSOR_BOX = 0x0C10

gl_SCISSOR_TEST :: GLenum
gl_SCISSOR_TEST = 0x0C11

gl_SEPARATE_ATTRIBS :: GLenum
gl_SEPARATE_ATTRIBS = 0x8C8D

gl_SET :: GLenum
gl_SET = 0x150F

gl_SHADER_SOURCE_LENGTH :: GLenum
gl_SHADER_SOURCE_LENGTH = 0x8B88

gl_SHADER_TYPE :: GLenum
gl_SHADER_TYPE = 0x8B4F

gl_SHADING_LANGUAGE_VERSION :: GLenum
gl_SHADING_LANGUAGE_VERSION = 0x8B8C

gl_SHORT :: GLenum
gl_SHORT = 0x1402

gl_SIGNED_NORMALIZED :: GLenum
gl_SIGNED_NORMALIZED = 0x8F9C

gl_SMOOTH_LINE_WIDTH_GRANULARITY :: GLenum
gl_SMOOTH_LINE_WIDTH_GRANULARITY = 0x0B23

gl_SMOOTH_LINE_WIDTH_RANGE :: GLenum
gl_SMOOTH_LINE_WIDTH_RANGE = 0x0B22

gl_SMOOTH_POINT_SIZE_GRANULARITY :: GLenum
gl_SMOOTH_POINT_SIZE_GRANULARITY = 0x0B13

gl_SMOOTH_POINT_SIZE_RANGE :: GLenum
gl_SMOOTH_POINT_SIZE_RANGE = 0x0B12

gl_SRC_ALPHA :: GLenum
gl_SRC_ALPHA = 0x0302

gl_SRC_ALPHA_SATURATE :: GLenum
gl_SRC_ALPHA_SATURATE = 0x0308

gl_SRC_COLOR :: GLenum
gl_SRC_COLOR = 0x0300

gl_SRGB :: GLenum
gl_SRGB = 0x8C40

gl_SRGB8 :: GLenum
gl_SRGB8 = 0x8C41

gl_SRGB8_ALPHA8 :: GLenum
gl_SRGB8_ALPHA8 = 0x8C43

gl_SRGB_ALPHA :: GLenum
gl_SRGB_ALPHA = 0x8C42

gl_STATIC_COPY :: GLenum
gl_STATIC_COPY = 0x88E6

gl_STATIC_DRAW :: GLenum
gl_STATIC_DRAW = 0x88E4

gl_STATIC_READ :: GLenum
gl_STATIC_READ = 0x88E5

gl_STENCIL :: GLenum
gl_STENCIL = 0x1802

gl_STENCIL_ATTACHMENT :: GLenum
gl_STENCIL_ATTACHMENT = 0x8D20

gl_STENCIL_BACK_FAIL :: GLenum
gl_STENCIL_BACK_FAIL = 0x8801

gl_STENCIL_BACK_FUNC :: GLenum
gl_STENCIL_BACK_FUNC = 0x8800

gl_STENCIL_BACK_PASS_DEPTH_FAIL :: GLenum
gl_STENCIL_BACK_PASS_DEPTH_FAIL = 0x8802

gl_STENCIL_BACK_PASS_DEPTH_PASS :: GLenum
gl_STENCIL_BACK_PASS_DEPTH_PASS = 0x8803

gl_STENCIL_BACK_REF :: GLenum
gl_STENCIL_BACK_REF = 0x8CA3

gl_STENCIL_BACK_VALUE_MASK :: GLenum
gl_STENCIL_BACK_VALUE_MASK = 0x8CA4

gl_STENCIL_BACK_WRITEMASK :: GLenum
gl_STENCIL_BACK_WRITEMASK = 0x8CA5

gl_STENCIL_BUFFER :: GLenum
gl_STENCIL_BUFFER = 0x8224

gl_STENCIL_BUFFER_BIT :: GLbitfield
gl_STENCIL_BUFFER_BIT = 0x00000400

gl_STENCIL_CLEAR_VALUE :: GLenum
gl_STENCIL_CLEAR_VALUE = 0x0B91

gl_STENCIL_FAIL :: GLenum
gl_STENCIL_FAIL = 0x0B94

gl_STENCIL_FUNC :: GLenum
gl_STENCIL_FUNC = 0x0B92

gl_STENCIL_INDEX :: GLenum
gl_STENCIL_INDEX = 0x1901

gl_STENCIL_INDEX1 :: GLenum
gl_STENCIL_INDEX1 = 0x8D46

gl_STENCIL_INDEX16 :: GLenum
gl_STENCIL_INDEX16 = 0x8D49

gl_STENCIL_INDEX4 :: GLenum
gl_STENCIL_INDEX4 = 0x8D47

gl_STENCIL_INDEX8 :: GLenum
gl_STENCIL_INDEX8 = 0x8D48

gl_STENCIL_PASS_DEPTH_FAIL :: GLenum
gl_STENCIL_PASS_DEPTH_FAIL = 0x0B95

gl_STENCIL_PASS_DEPTH_PASS :: GLenum
gl_STENCIL_PASS_DEPTH_PASS = 0x0B96

gl_STENCIL_REF :: GLenum
gl_STENCIL_REF = 0x0B97

gl_STENCIL_TEST :: GLenum
gl_STENCIL_TEST = 0x0B90

gl_STENCIL_VALUE_MASK :: GLenum
gl_STENCIL_VALUE_MASK = 0x0B93

gl_STENCIL_WRITEMASK :: GLenum
gl_STENCIL_WRITEMASK = 0x0B98

gl_STEREO :: GLenum
gl_STEREO = 0x0C33

gl_STREAM_COPY :: GLenum
gl_STREAM_COPY = 0x88E2

gl_STREAM_DRAW :: GLenum
gl_STREAM_DRAW = 0x88E0

gl_STREAM_READ :: GLenum
gl_STREAM_READ = 0x88E1

gl_SUBPIXEL_BITS :: GLenum
gl_SUBPIXEL_BITS = 0x0D50

gl_TEXTURE :: GLenum
gl_TEXTURE = 0x1702

gl_TEXTURE0 :: GLenum
gl_TEXTURE0 = 0x84C0

gl_TEXTURE1 :: GLenum
gl_TEXTURE1 = 0x84C1

gl_TEXTURE10 :: GLenum
gl_TEXTURE10 = 0x84CA

gl_TEXTURE11 :: GLenum
gl_TEXTURE11 = 0x84CB

gl_TEXTURE12 :: GLenum
gl_TEXTURE12 = 0x84CC

gl_TEXTURE13 :: GLenum
gl_TEXTURE13 = 0x84CD

gl_TEXTURE14 :: GLenum
gl_TEXTURE14 = 0x84CE

gl_TEXTURE15 :: GLenum
gl_TEXTURE15 = 0x84CF

gl_TEXTURE16 :: GLenum
gl_TEXTURE16 = 0x84D0

gl_TEXTURE17 :: GLenum
gl_TEXTURE17 = 0x84D1

gl_TEXTURE18 :: GLenum
gl_TEXTURE18 = 0x84D2

gl_TEXTURE19 :: GLenum
gl_TEXTURE19 = 0x84D3

gl_TEXTURE2 :: GLenum
gl_TEXTURE2 = 0x84C2

gl_TEXTURE20 :: GLenum
gl_TEXTURE20 = 0x84D4

gl_TEXTURE21 :: GLenum
gl_TEXTURE21 = 0x84D5

gl_TEXTURE22 :: GLenum
gl_TEXTURE22 = 0x84D6

gl_TEXTURE23 :: GLenum
gl_TEXTURE23 = 0x84D7

gl_TEXTURE24 :: GLenum
gl_TEXTURE24 = 0x84D8

gl_TEXTURE25 :: GLenum
gl_TEXTURE25 = 0x84D9

gl_TEXTURE26 :: GLenum
gl_TEXTURE26 = 0x84DA

gl_TEXTURE27 :: GLenum
gl_TEXTURE27 = 0x84DB

gl_TEXTURE28 :: GLenum
gl_TEXTURE28 = 0x84DC

gl_TEXTURE29 :: GLenum
gl_TEXTURE29 = 0x84DD

gl_TEXTURE3 :: GLenum
gl_TEXTURE3 = 0x84C3

gl_TEXTURE30 :: GLenum
gl_TEXTURE30 = 0x84DE

gl_TEXTURE31 :: GLenum
gl_TEXTURE31 = 0x84DF

gl_TEXTURE4 :: GLenum
gl_TEXTURE4 = 0x84C4

gl_TEXTURE5 :: GLenum
gl_TEXTURE5 = 0x84C5

gl_TEXTURE6 :: GLenum
gl_TEXTURE6 = 0x84C6

gl_TEXTURE7 :: GLenum
gl_TEXTURE7 = 0x84C7

gl_TEXTURE8 :: GLenum
gl_TEXTURE8 = 0x84C8

gl_TEXTURE9 :: GLenum
gl_TEXTURE9 = 0x84C9

gl_TEXTURE_1D :: GLenum
gl_TEXTURE_1D = 0x0DE0

gl_TEXTURE_1D_ARRAY :: GLenum
gl_TEXTURE_1D_ARRAY = 0x8C18

gl_TEXTURE_2D :: GLenum
gl_TEXTURE_2D = 0x0DE1

gl_TEXTURE_2D_ARRAY :: GLenum
gl_TEXTURE_2D_ARRAY = 0x8C1A

gl_TEXTURE_3D :: GLenum
gl_TEXTURE_3D = 0x806F

gl_TEXTURE_ALPHA_SIZE :: GLenum
gl_TEXTURE_ALPHA_SIZE = 0x805F

gl_TEXTURE_ALPHA_TYPE :: GLenum
gl_TEXTURE_ALPHA_TYPE = 0x8C13

gl_TEXTURE_BASE_LEVEL :: GLenum
gl_TEXTURE_BASE_LEVEL = 0x813C

gl_TEXTURE_BINDING_1D :: GLenum
gl_TEXTURE_BINDING_1D = 0x8068

gl_TEXTURE_BINDING_1D_ARRAY :: GLenum
gl_TEXTURE_BINDING_1D_ARRAY = 0x8C1C

gl_TEXTURE_BINDING_2D :: GLenum
gl_TEXTURE_BINDING_2D = 0x8069

gl_TEXTURE_BINDING_2D_ARRAY :: GLenum
gl_TEXTURE_BINDING_2D_ARRAY = 0x8C1D

gl_TEXTURE_BINDING_3D :: GLenum
gl_TEXTURE_BINDING_3D = 0x806A

gl_TEXTURE_BINDING_CUBE_MAP :: GLenum
gl_TEXTURE_BINDING_CUBE_MAP = 0x8514

gl_TEXTURE_BLUE_SIZE :: GLenum
gl_TEXTURE_BLUE_SIZE = 0x805E

gl_TEXTURE_BLUE_TYPE :: GLenum
gl_TEXTURE_BLUE_TYPE = 0x8C12

gl_TEXTURE_BORDER :: GLenum
gl_TEXTURE_BORDER = 0x1005

gl_TEXTURE_BORDER_COLOR :: GLenum
gl_TEXTURE_BORDER_COLOR = 0x1004

gl_TEXTURE_COMPARE_FUNC :: GLenum
gl_TEXTURE_COMPARE_FUNC = 0x884D

gl_TEXTURE_COMPARE_MODE :: GLenum
gl_TEXTURE_COMPARE_MODE = 0x884C

gl_TEXTURE_COMPRESSED :: GLenum
gl_TEXTURE_COMPRESSED = 0x86A1

gl_TEXTURE_COMPRESSED_IMAGE_SIZE :: GLenum
gl_TEXTURE_COMPRESSED_IMAGE_SIZE = 0x86A0

gl_TEXTURE_COMPRESSION_HINT :: GLenum
gl_TEXTURE_COMPRESSION_HINT = 0x84EF

gl_TEXTURE_CUBE_MAP :: GLenum
gl_TEXTURE_CUBE_MAP = 0x8513

gl_TEXTURE_CUBE_MAP_NEGATIVE_X :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_X = 0x8516

gl_TEXTURE_CUBE_MAP_NEGATIVE_Y :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Y = 0x8518

gl_TEXTURE_CUBE_MAP_NEGATIVE_Z :: GLenum
gl_TEXTURE_CUBE_MAP_NEGATIVE_Z = 0x851A

gl_TEXTURE_CUBE_MAP_POSITIVE_X :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_X = 0x8515

gl_TEXTURE_CUBE_MAP_POSITIVE_Y :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Y = 0x8517

gl_TEXTURE_CUBE_MAP_POSITIVE_Z :: GLenum
gl_TEXTURE_CUBE_MAP_POSITIVE_Z = 0x8519

gl_TEXTURE_DEPTH :: GLenum
gl_TEXTURE_DEPTH = 0x8071

gl_TEXTURE_DEPTH_SIZE :: GLenum
gl_TEXTURE_DEPTH_SIZE = 0x884A

gl_TEXTURE_DEPTH_TYPE :: GLenum
gl_TEXTURE_DEPTH_TYPE = 0x8C16

gl_TEXTURE_GREEN_SIZE :: GLenum
gl_TEXTURE_GREEN_SIZE = 0x805D

gl_TEXTURE_GREEN_TYPE :: GLenum
gl_TEXTURE_GREEN_TYPE = 0x8C11

gl_TEXTURE_HEIGHT :: GLenum
gl_TEXTURE_HEIGHT = 0x1001

gl_TEXTURE_INTERNAL_FORMAT :: GLenum
gl_TEXTURE_INTERNAL_FORMAT = 0x1003

gl_TEXTURE_LOD_BIAS :: GLenum
gl_TEXTURE_LOD_BIAS = 0x8501

gl_TEXTURE_MAG_FILTER :: GLenum
gl_TEXTURE_MAG_FILTER = 0x2800

gl_TEXTURE_MAX_LEVEL :: GLenum
gl_TEXTURE_MAX_LEVEL = 0x813D

gl_TEXTURE_MAX_LOD :: GLenum
gl_TEXTURE_MAX_LOD = 0x813B

gl_TEXTURE_MIN_FILTER :: GLenum
gl_TEXTURE_MIN_FILTER = 0x2801

gl_TEXTURE_MIN_LOD :: GLenum
gl_TEXTURE_MIN_LOD = 0x813A

gl_TEXTURE_RED_SIZE :: GLenum
gl_TEXTURE_RED_SIZE = 0x805C

gl_TEXTURE_RED_TYPE :: GLenum
gl_TEXTURE_RED_TYPE = 0x8C10

gl_TEXTURE_SHARED_SIZE :: GLenum
gl_TEXTURE_SHARED_SIZE = 0x8C3F

gl_TEXTURE_STENCIL_SIZE :: GLenum
gl_TEXTURE_STENCIL_SIZE = 0x88F1

gl_TEXTURE_WIDTH :: GLenum
gl_TEXTURE_WIDTH = 0x1000

gl_TEXTURE_WRAP_R :: GLenum
gl_TEXTURE_WRAP_R = 0x8072

gl_TEXTURE_WRAP_S :: GLenum
gl_TEXTURE_WRAP_S = 0x2802

gl_TEXTURE_WRAP_T :: GLenum
gl_TEXTURE_WRAP_T = 0x2803

gl_TRANSFORM_FEEDBACK_BUFFER :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER = 0x8C8E

gl_TRANSFORM_FEEDBACK_BUFFER_BINDING :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_BINDING = 0x8C8F

gl_TRANSFORM_FEEDBACK_BUFFER_MODE :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_MODE = 0x8C7F

gl_TRANSFORM_FEEDBACK_BUFFER_SIZE :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_SIZE = 0x8C85

gl_TRANSFORM_FEEDBACK_BUFFER_START :: GLenum
gl_TRANSFORM_FEEDBACK_BUFFER_START = 0x8C84

gl_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN :: GLenum
gl_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = 0x8C88

gl_TRANSFORM_FEEDBACK_VARYINGS :: GLenum
gl_TRANSFORM_FEEDBACK_VARYINGS = 0x8C83

gl_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH :: GLenum
gl_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = 0x8C76

gl_TRIANGLES :: GLenum
gl_TRIANGLES = 0x0004

gl_TRIANGLE_FAN :: GLenum
gl_TRIANGLE_FAN = 0x0006

gl_TRIANGLE_STRIP :: GLenum
gl_TRIANGLE_STRIP = 0x0005

gl_TRUE :: GLenum
gl_TRUE = 1

gl_UNPACK_ALIGNMENT :: GLenum
gl_UNPACK_ALIGNMENT = 0x0CF5

gl_UNPACK_IMAGE_HEIGHT :: GLenum
gl_UNPACK_IMAGE_HEIGHT = 0x806E

gl_UNPACK_LSB_FIRST :: GLenum
gl_UNPACK_LSB_FIRST = 0x0CF1

gl_UNPACK_ROW_LENGTH :: GLenum
gl_UNPACK_ROW_LENGTH = 0x0CF2

gl_UNPACK_SKIP_IMAGES :: GLenum
gl_UNPACK_SKIP_IMAGES = 0x806D

gl_UNPACK_SKIP_PIXELS :: GLenum
gl_UNPACK_SKIP_PIXELS = 0x0CF4

gl_UNPACK_SKIP_ROWS :: GLenum
gl_UNPACK_SKIP_ROWS = 0x0CF3

gl_UNPACK_SWAP_BYTES :: GLenum
gl_UNPACK_SWAP_BYTES = 0x0CF0

gl_UNSIGNED_BYTE :: GLenum
gl_UNSIGNED_BYTE = 0x1401

gl_UNSIGNED_BYTE_2_3_3_REV :: GLenum
gl_UNSIGNED_BYTE_2_3_3_REV = 0x8362

gl_UNSIGNED_BYTE_3_3_2 :: GLenum
gl_UNSIGNED_BYTE_3_3_2 = 0x8032

gl_UNSIGNED_INT :: GLenum
gl_UNSIGNED_INT = 0x1405

gl_UNSIGNED_INT_10F_11F_11F_REV :: GLenum
gl_UNSIGNED_INT_10F_11F_11F_REV = 0x8C3B

gl_UNSIGNED_INT_10_10_10_2 :: GLenum
gl_UNSIGNED_INT_10_10_10_2 = 0x8036

gl_UNSIGNED_INT_24_8 :: GLenum
gl_UNSIGNED_INT_24_8 = 0x84FA

gl_UNSIGNED_INT_2_10_10_10_REV :: GLenum
gl_UNSIGNED_INT_2_10_10_10_REV = 0x8368

gl_UNSIGNED_INT_5_9_9_9_REV :: GLenum
gl_UNSIGNED_INT_5_9_9_9_REV = 0x8C3E

gl_UNSIGNED_INT_8_8_8_8 :: GLenum
gl_UNSIGNED_INT_8_8_8_8 = 0x8035

gl_UNSIGNED_INT_8_8_8_8_REV :: GLenum
gl_UNSIGNED_INT_8_8_8_8_REV = 0x8367

gl_UNSIGNED_INT_SAMPLER_1D :: GLenum
gl_UNSIGNED_INT_SAMPLER_1D = 0x8DD1

gl_UNSIGNED_INT_SAMPLER_1D_ARRAY :: GLenum
gl_UNSIGNED_INT_SAMPLER_1D_ARRAY = 0x8DD6

gl_UNSIGNED_INT_SAMPLER_2D :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D = 0x8DD2

gl_UNSIGNED_INT_SAMPLER_2D_ARRAY :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_ARRAY = 0x8DD7

gl_UNSIGNED_INT_SAMPLER_2D_RECT :: GLenum
gl_UNSIGNED_INT_SAMPLER_2D_RECT = 0x8DD5

gl_UNSIGNED_INT_SAMPLER_3D :: GLenum
gl_UNSIGNED_INT_SAMPLER_3D = 0x8DD3

gl_UNSIGNED_INT_SAMPLER_BUFFER :: GLenum
gl_UNSIGNED_INT_SAMPLER_BUFFER = 0x8DD8

gl_UNSIGNED_INT_SAMPLER_CUBE :: GLenum
gl_UNSIGNED_INT_SAMPLER_CUBE = 0x8DD4

gl_UNSIGNED_INT_VEC2 :: GLenum
gl_UNSIGNED_INT_VEC2 = 0x8DC6

gl_UNSIGNED_INT_VEC3 :: GLenum
gl_UNSIGNED_INT_VEC3 = 0x8DC7

gl_UNSIGNED_INT_VEC4 :: GLenum
gl_UNSIGNED_INT_VEC4 = 0x8DC8

gl_UNSIGNED_NORMALIZED :: GLenum
gl_UNSIGNED_NORMALIZED = 0x8C17

gl_UNSIGNED_SHORT :: GLenum
gl_UNSIGNED_SHORT = 0x1403

gl_UNSIGNED_SHORT_1_5_5_5_REV :: GLenum
gl_UNSIGNED_SHORT_1_5_5_5_REV = 0x8366

gl_UNSIGNED_SHORT_4_4_4_4 :: GLenum
gl_UNSIGNED_SHORT_4_4_4_4 = 0x8033

gl_UNSIGNED_SHORT_4_4_4_4_REV :: GLenum
gl_UNSIGNED_SHORT_4_4_4_4_REV = 0x8365

gl_UNSIGNED_SHORT_5_5_5_1 :: GLenum
gl_UNSIGNED_SHORT_5_5_5_1 = 0x8034

gl_UNSIGNED_SHORT_5_6_5 :: GLenum
gl_UNSIGNED_SHORT_5_6_5 = 0x8363

gl_UNSIGNED_SHORT_5_6_5_REV :: GLenum
gl_UNSIGNED_SHORT_5_6_5_REV = 0x8364

gl_UPPER_LEFT :: GLenum
gl_UPPER_LEFT = 0x8CA2

gl_VALIDATE_STATUS :: GLenum
gl_VALIDATE_STATUS = 0x8B83

gl_VENDOR :: GLenum
gl_VENDOR = 0x1F00

gl_VERSION :: GLenum
gl_VERSION = 0x1F02

gl_VERTEX_ARRAY_BINDING :: GLenum
gl_VERTEX_ARRAY_BINDING = 0x85B5

gl_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING :: GLenum
gl_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = 0x889F

gl_VERTEX_ATTRIB_ARRAY_ENABLED :: GLenum
gl_VERTEX_ATTRIB_ARRAY_ENABLED = 0x8622

gl_VERTEX_ATTRIB_ARRAY_INTEGER :: GLenum
gl_VERTEX_ATTRIB_ARRAY_INTEGER = 0x88FD

gl_VERTEX_ATTRIB_ARRAY_NORMALIZED :: GLenum
gl_VERTEX_ATTRIB_ARRAY_NORMALIZED = 0x886A

gl_VERTEX_ATTRIB_ARRAY_POINTER :: GLenum
gl_VERTEX_ATTRIB_ARRAY_POINTER = 0x8645

gl_VERTEX_ATTRIB_ARRAY_SIZE :: GLenum
gl_VERTEX_ATTRIB_ARRAY_SIZE = 0x8623

gl_VERTEX_ATTRIB_ARRAY_STRIDE :: GLenum
gl_VERTEX_ATTRIB_ARRAY_STRIDE = 0x8624

gl_VERTEX_ATTRIB_ARRAY_TYPE :: GLenum
gl_VERTEX_ATTRIB_ARRAY_TYPE = 0x8625

gl_VERTEX_PROGRAM_POINT_SIZE :: GLenum
gl_VERTEX_PROGRAM_POINT_SIZE = 0x8642

gl_VERTEX_SHADER :: GLenum
gl_VERTEX_SHADER = 0x8B31

gl_VIEWPORT :: GLenum
gl_VIEWPORT = 0x0BA2

gl_WRITE_ONLY :: GLenum
gl_WRITE_ONLY = 0x88B9

gl_XOR :: GLenum
gl_XOR = 0x1506

gl_ZERO :: GLenum
gl_ZERO = 0
