/*
 * $Id: haserl.h,v 1.6 2004/11/10 17:59:35 nangel Exp $
 */
#ifndef _WEBCONF_H
#define _WEBCONF_H	1


#define STDIN	0
#define STDOUT  1
#define STDERR	2 


#define TRUE  -1
#define FALSE 0


/* the script */
typedef struct {
	char 	*name; 		/* pointer to name of script 	*/
	int	size;		/* size of script in bytes 	*/	
 	uid_t	uid;		/* user owner			*/
	gid_t	gid;		/* group owner			*/
	time_t	mtime;		/* last modified time		*/
	void	*buffer;	/* pointer to malloc'ed buffer	*/
	int	curpos;		/* current position in buffer	*/	
	} script_t;

/* tag types */
enum tag_t { HTML, RUN, IF, ELSE, FI, ABORT, NOOP };


/* the "names" for the pipes to the subshell */
enum pipe_t { PARENT_IN, PARENT_OUT, PARENT_CTRLIN, CHILD_CTRLOUT };

/* token structure */
typedef struct {
	enum tag_t	tag;	/* the token type		*/
	char	*buf; 		/* the token argument		*/
	int	len;		/* length of token		*/
	int	depth;		/* nesting - 0 is outer later	*/
	struct	token_t	*next;	/* the next token in the chain	*/
	} token_t; 

/* linked list of environment variables */
typedef struct {
	char 	*buf;
	void    *next;
	} buflist_t;
	
/* These aren't use anymore 
 * enum modes { TOP, IFTRUE, IFFALSE };
 */

/* generated by cproto 25 May 2004 */
char x2c(char *what);
void unescape_url(char *url);
int myputenv(char *newbuf, char *prefix);
void readenv(void);
void freeenvchain(void);
void FreeTokenChain(void);
void sessionid(void);
void wcversion(void);
int ReadCGIQueryString(void);
int ReadCGIPOSTValues(void);
int LineToStr(char *string, size_t max);
int ReadMimeEncodedInput(char *qs);
int loadscript(char *filename, script_t *scriptbuf);
int freescript(script_t *scriptbuf);
void PrintParseError(char *error, int linenum);
int scanline(script_t *script, int endcount);
int PushTokenChain(enum tag_t tag, char *buf, size_t len, int depth);
int FindTag(char *buf, size_t len, char *tag);
int BuildTokenChain(script_t *script);
int FindHeadBlock(script_t *script);
int ProcessTokenChain(token_t *token);
int OpenSubshell(void);
int CloseSubshell(void);
int ExecSubshell( char *);
int main(int argc, char *argv[]);


#endif /* !_WEBCONF_H */
