<?php
/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
include_once $GLOBALS['THRIFT_ROOT'].'/Thrift.php';

include_once $GLOBALS['THRIFT_ROOT'].'/packages/hadoopfs/hadoopfs_types.php';

interface ThriftHadoopFileSystemIf {
  public function setInactivityTimeoutPeriod($periodInSeconds);
  public function shutdown($status);
  public function create($path);
  public function createFile($path, $mode, $overwrite, $bufferSize, $block_replication, $blocksize);
  public function open($path);
  public function append($path);
  public function write($handle, $data);
  public function read($handle, $offset, $size);
  public function close($out);
  public function rm($path, $recursive);
  public function rename($path, $dest);
  public function mkdirs($path);
  public function exists($path);
  public function stat($path);
  public function listStatus($path);
  public function chmod($path, $mode);
  public function chown($path, $owner, $group);
  public function setReplication($path, $replication);
  public function getFileBlockLocations($path, $start, $length);
}

class ThriftHadoopFileSystemClient implements ThriftHadoopFileSystemIf {
  protected $input_ = null;
  protected $output_ = null;

  protected $seqid_ = 0;

  public function __construct($input, $output=null) {
    $this->input_ = $input;
    $this->output_ = $output ? $output : $input;
  }

  public function setInactivityTimeoutPeriod($periodInSeconds)
  {
    $this->send_setInactivityTimeoutPeriod($periodInSeconds);
    $this->recv_setInactivityTimeoutPeriod();
  }

  public function send_setInactivityTimeoutPeriod($periodInSeconds)
  {
    $args = new ThriftHadoopFileSystem_setInactivityTimeoutPeriod_args();
    $args->periodInSeconds = $periodInSeconds;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'setInactivityTimeoutPeriod', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('setInactivityTimeoutPeriod', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_setInactivityTimeoutPeriod()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_setInactivityTimeoutPeriod_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_setInactivityTimeoutPeriod_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    return;
  }

  public function shutdown($status)
  {
    $this->send_shutdown($status);
    $this->recv_shutdown();
  }

  public function send_shutdown($status)
  {
    $args = new ThriftHadoopFileSystem_shutdown_args();
    $args->status = $status;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'shutdown', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('shutdown', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_shutdown()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_shutdown_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_shutdown_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    return;
  }

  public function create($path)
  {
    $this->send_create($path);
    return $this->recv_create();
  }

  public function send_create($path)
  {
    $args = new ThriftHadoopFileSystem_create_args();
    $args->path = $path;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_create_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_create_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("create failed: unknown result");
  }

  public function createFile($path, $mode, $overwrite, $bufferSize, $block_replication, $blocksize)
  {
    $this->send_createFile($path, $mode, $overwrite, $bufferSize, $block_replication, $blocksize);
    return $this->recv_createFile();
  }

  public function send_createFile($path, $mode, $overwrite, $bufferSize, $block_replication, $blocksize)
  {
    $args = new ThriftHadoopFileSystem_createFile_args();
    $args->path = $path;
    $args->mode = $mode;
    $args->overwrite = $overwrite;
    $args->bufferSize = $bufferSize;
    $args->block_replication = $block_replication;
    $args->blocksize = $blocksize;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'createFile', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('createFile', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_createFile()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_createFile_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_createFile_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("createFile failed: unknown result");
  }

  public function open($path)
  {
    $this->send_open($path);
    return $this->recv_open();
  }

  public function send_open($path)
  {
    $args = new ThriftHadoopFileSystem_open_args();
    $args->path = $path;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'open', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('open', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_open()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_open_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_open_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("open failed: unknown result");
  }

  public function append($path)
  {
    $this->send_append($path);
    return $this->recv_append();
  }

  public function send_append($path)
  {
    $args = new ThriftHadoopFileSystem_append_args();
    $args->path = $path;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_append_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_append_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("append failed: unknown result");
  }

  public function write($handle, $data)
  {
    $this->send_write($handle, $data);
    return $this->recv_write();
  }

  public function send_write($handle, $data)
  {
    $args = new ThriftHadoopFileSystem_write_args();
    $args->handle = $handle;
    $args->data = $data;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'write', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('write', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_write()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_write_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_write_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("write failed: unknown result");
  }

  public function read($handle, $offset, $size)
  {
    $this->send_read($handle, $offset, $size);
    return $this->recv_read();
  }

  public function send_read($handle, $offset, $size)
  {
    $args = new ThriftHadoopFileSystem_read_args();
    $args->handle = $handle;
    $args->offset = $offset;
    $args->size = $size;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'read', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('read', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_read()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_read_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_read_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("read failed: unknown result");
  }

  public function close($out)
  {
    $this->send_close($out);
    return $this->recv_close();
  }

  public function send_close($out)
  {
    $args = new ThriftHadoopFileSystem_close_args();
    $args->out = $out;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'close', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('close', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_close()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_close_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_close_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("close failed: unknown result");
  }

  public function rm($path, $recursive)
  {
    $this->send_rm($path, $recursive);
    return $this->recv_rm();
  }

  public function send_rm($path, $recursive)
  {
    $args = new ThriftHadoopFileSystem_rm_args();
    $args->path = $path;
    $args->recursive = $recursive;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'rm', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('rm', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_rm()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_rm_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_rm_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("rm failed: unknown result");
  }

  public function rename($path, $dest)
  {
    $this->send_rename($path, $dest);
    return $this->recv_rename();
  }

  public function send_rename($path, $dest)
  {
    $args = new ThriftHadoopFileSystem_rename_args();
    $args->path = $path;
    $args->dest = $dest;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'rename', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('rename', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_rename()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_rename_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_rename_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("rename failed: unknown result");
  }

  public function mkdirs($path)
  {
    $this->send_mkdirs($path);
    return $this->recv_mkdirs();
  }

  public function send_mkdirs($path)
  {
    $args = new ThriftHadoopFileSystem_mkdirs_args();
    $args->path = $path;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'mkdirs', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('mkdirs', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_mkdirs()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_mkdirs_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_mkdirs_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("mkdirs failed: unknown result");
  }

  public function exists($path)
  {
    $this->send_exists($path);
    return $this->recv_exists();
  }

  public function send_exists($path)
  {
    $args = new ThriftHadoopFileSystem_exists_args();
    $args->path = $path;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'exists', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('exists', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_exists()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_exists_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_exists_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("exists failed: unknown result");
  }

  public function stat($path)
  {
    $this->send_stat($path);
    return $this->recv_stat();
  }

  public function send_stat($path)
  {
    $args = new ThriftHadoopFileSystem_stat_args();
    $args->path = $path;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'stat', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('stat', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_stat()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_stat_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_stat_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("stat failed: unknown result");
  }

  public function listStatus($path)
  {
    $this->send_listStatus($path);
    return $this->recv_listStatus();
  }

  public function send_listStatus($path)
  {
    $args = new ThriftHadoopFileSystem_listStatus_args();
    $args->path = $path;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'listStatus', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('listStatus', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_listStatus()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_listStatus_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_listStatus_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("listStatus failed: unknown result");
  }

  public function chmod($path, $mode)
  {
    $this->send_chmod($path, $mode);
    $this->recv_chmod();
  }

  public function send_chmod($path, $mode)
  {
    $args = new ThriftHadoopFileSystem_chmod_args();
    $args->path = $path;
    $args->mode = $mode;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'chmod', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('chmod', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_chmod()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_chmod_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_chmod_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    return;
  }

  public function chown($path, $owner, $group)
  {
    $this->send_chown($path, $owner, $group);
    $this->recv_chown();
  }

  public function send_chown($path, $owner, $group)
  {
    $args = new ThriftHadoopFileSystem_chown_args();
    $args->path = $path;
    $args->owner = $owner;
    $args->group = $group;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'chown', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('chown', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_chown()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_chown_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_chown_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    return;
  }

  public function setReplication($path, $replication)
  {
    $this->send_setReplication($path, $replication);
    $this->recv_setReplication();
  }

  public function send_setReplication($path, $replication)
  {
    $args = new ThriftHadoopFileSystem_setReplication_args();
    $args->path = $path;
    $args->replication = $replication;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'setReplication', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('setReplication', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_setReplication()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_setReplication_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_setReplication_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    return;
  }

  public function getFileBlockLocations($path, $start, $length)
  {
    $this->send_getFileBlockLocations($path, $start, $length);
    return $this->recv_getFileBlockLocations();
  }

  public function send_getFileBlockLocations($path, $start, $length)
  {
    $args = new ThriftHadoopFileSystem_getFileBlockLocations_args();
    $args->path = $path;
    $args->start = $start;
    $args->length = $length;
    $bin_accel = ($this->output_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getFileBlockLocations', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getFileBlockLocations', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getFileBlockLocations()
  {
    $bin_accel = ($this->input_ instanceof TProtocol::$TBINARYPROTOCOLACCELERATED) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, 'ThriftHadoopFileSystem_getFileBlockLocations_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new ThriftHadoopFileSystem_getFileBlockLocations_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->ouch !== null) {
      throw $result->ouch;
    }
    throw new Exception("getFileBlockLocations failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class ThriftHadoopFileSystem_setInactivityTimeoutPeriod_args {
  static $_TSPEC;

  public $periodInSeconds = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'periodInSeconds',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['periodInSeconds'])) {
        $this->periodInSeconds = $vals['periodInSeconds'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_setInactivityTimeoutPeriod_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->periodInSeconds);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_setInactivityTimeoutPeriod_args');
    if ($this->periodInSeconds !== null) {
      $xfer += $output->writeFieldBegin('periodInSeconds', TType::I64, 1);
      $xfer += $output->writeI64($this->periodInSeconds);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_setInactivityTimeoutPeriod_result {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_setInactivityTimeoutPeriod_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_setInactivityTimeoutPeriod_result');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_shutdown_args {
  static $_TSPEC;

  public $status = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'status',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['status'])) {
        $this->status = $vals['status'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_shutdown_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->status);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_shutdown_args');
    if ($this->status !== null) {
      $xfer += $output->writeFieldBegin('status', TType::I32, 1);
      $xfer += $output->writeI32($this->status);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_shutdown_result {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_shutdown_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_shutdown_result');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_create_args {
  static $_TSPEC;

  public $path = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_create_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_create_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_create_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => 'ThriftHandle',
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_create_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new ThriftHandle();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_create_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_createFile_args {
  static $_TSPEC;

  public $path = null;
  public $mode = null;
  public $overwrite = null;
  public $bufferSize = null;
  public $block_replication = null;
  public $blocksize = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        2 => array(
          'var' => 'mode',
          'type' => TType::I16,
          ),
        3 => array(
          'var' => 'overwrite',
          'type' => TType::BOOL,
          ),
        4 => array(
          'var' => 'bufferSize',
          'type' => TType::I32,
          ),
        5 => array(
          'var' => 'block_replication',
          'type' => TType::I16,
          ),
        6 => array(
          'var' => 'blocksize',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
      if (isset($vals['mode'])) {
        $this->mode = $vals['mode'];
      }
      if (isset($vals['overwrite'])) {
        $this->overwrite = $vals['overwrite'];
      }
      if (isset($vals['bufferSize'])) {
        $this->bufferSize = $vals['bufferSize'];
      }
      if (isset($vals['block_replication'])) {
        $this->block_replication = $vals['block_replication'];
      }
      if (isset($vals['blocksize'])) {
        $this->blocksize = $vals['blocksize'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_createFile_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->mode);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->overwrite);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->bufferSize);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->block_replication);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->blocksize);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_createFile_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mode !== null) {
      $xfer += $output->writeFieldBegin('mode', TType::I16, 2);
      $xfer += $output->writeI16($this->mode);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->overwrite !== null) {
      $xfer += $output->writeFieldBegin('overwrite', TType::BOOL, 3);
      $xfer += $output->writeBool($this->overwrite);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->bufferSize !== null) {
      $xfer += $output->writeFieldBegin('bufferSize', TType::I32, 4);
      $xfer += $output->writeI32($this->bufferSize);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->block_replication !== null) {
      $xfer += $output->writeFieldBegin('block_replication', TType::I16, 5);
      $xfer += $output->writeI16($this->block_replication);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->blocksize !== null) {
      $xfer += $output->writeFieldBegin('blocksize', TType::I64, 6);
      $xfer += $output->writeI64($this->blocksize);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_createFile_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => 'ThriftHandle',
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_createFile_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new ThriftHandle();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_createFile_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_open_args {
  static $_TSPEC;

  public $path = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_open_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_open_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_open_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => 'ThriftHandle',
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_open_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new ThriftHandle();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_open_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_append_args {
  static $_TSPEC;

  public $path = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_append_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_append_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_append_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => 'ThriftHandle',
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_append_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new ThriftHandle();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_append_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_write_args {
  static $_TSPEC;

  public $handle = null;
  public $data = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'handle',
          'type' => TType::STRUCT,
          'class' => 'ThriftHandle',
          ),
        -1 => array(
          'var' => 'data',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['handle'])) {
        $this->handle = $vals['handle'];
      }
      if (isset($vals['data'])) {
        $this->data = $vals['data'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_write_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->handle = new ThriftHandle();
            $xfer += $this->handle->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case -1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->data);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_write_args');
    if ($this->handle !== null) {
      if (!is_object($this->handle)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('handle', TType::STRUCT, 1);
      $xfer += $this->handle->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->data !== null) {
      $xfer += $output->writeFieldBegin('data', TType::STRING, -1);
      $xfer += $output->writeString($this->data);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_write_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_write_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_write_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_read_args {
  static $_TSPEC;

  public $handle = null;
  public $offset = null;
  public $size = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'handle',
          'type' => TType::STRUCT,
          'class' => 'ThriftHandle',
          ),
        -1 => array(
          'var' => 'offset',
          'type' => TType::I64,
          ),
        -2 => array(
          'var' => 'size',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['handle'])) {
        $this->handle = $vals['handle'];
      }
      if (isset($vals['offset'])) {
        $this->offset = $vals['offset'];
      }
      if (isset($vals['size'])) {
        $this->size = $vals['size'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_read_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->handle = new ThriftHandle();
            $xfer += $this->handle->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case -1:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->offset);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case -2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->size);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_read_args');
    if ($this->handle !== null) {
      if (!is_object($this->handle)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('handle', TType::STRUCT, 1);
      $xfer += $this->handle->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->offset !== null) {
      $xfer += $output->writeFieldBegin('offset', TType::I64, -1);
      $xfer += $output->writeI64($this->offset);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->size !== null) {
      $xfer += $output->writeFieldBegin('size', TType::I32, -2);
      $xfer += $output->writeI32($this->size);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_read_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_read_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_read_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_close_args {
  static $_TSPEC;

  public $out = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'out',
          'type' => TType::STRUCT,
          'class' => 'ThriftHandle',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['out'])) {
        $this->out = $vals['out'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_close_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->out = new ThriftHandle();
            $xfer += $this->out->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_close_args');
    if ($this->out !== null) {
      if (!is_object($this->out)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('out', TType::STRUCT, 1);
      $xfer += $this->out->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_close_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_close_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_close_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_rm_args {
  static $_TSPEC;

  public $path = null;
  public $recursive = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        2 => array(
          'var' => 'recursive',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
      if (isset($vals['recursive'])) {
        $this->recursive = $vals['recursive'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_rm_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->recursive);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_rm_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->recursive !== null) {
      $xfer += $output->writeFieldBegin('recursive', TType::BOOL, 2);
      $xfer += $output->writeBool($this->recursive);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_rm_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_rm_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_rm_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_rename_args {
  static $_TSPEC;

  public $path = null;
  public $dest = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        2 => array(
          'var' => 'dest',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
      if (isset($vals['dest'])) {
        $this->dest = $vals['dest'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_rename_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->dest = new Pathname();
            $xfer += $this->dest->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_rename_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dest !== null) {
      if (!is_object($this->dest)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('dest', TType::STRUCT, 2);
      $xfer += $this->dest->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_rename_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_rename_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_rename_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_mkdirs_args {
  static $_TSPEC;

  public $path = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_mkdirs_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_mkdirs_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_mkdirs_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_mkdirs_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_mkdirs_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_exists_args {
  static $_TSPEC;

  public $path = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_exists_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_exists_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_exists_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_exists_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_exists_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_stat_args {
  static $_TSPEC;

  public $path = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_stat_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_stat_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_stat_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => 'FileStatus',
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_stat_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new FileStatus();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_stat_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_listStatus_args {
  static $_TSPEC;

  public $path = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_listStatus_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_listStatus_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_listStatus_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => 'FileStatus',
            ),
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_listStatus_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size14 = 0;
            $_etype17 = 0;
            $xfer += $input->readListBegin($_etype17, $_size14);
            for ($_i18 = 0; $_i18 < $_size14; ++$_i18)
            {
              $elem19 = null;
              $elem19 = new FileStatus();
              $xfer += $elem19->read($input);
              $this->success []= $elem19;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_listStatus_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter20)
          {
            $xfer += $iter20->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_chmod_args {
  static $_TSPEC;

  public $path = null;
  public $mode = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        2 => array(
          'var' => 'mode',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
      if (isset($vals['mode'])) {
        $this->mode = $vals['mode'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_chmod_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->mode);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_chmod_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->mode !== null) {
      $xfer += $output->writeFieldBegin('mode', TType::I16, 2);
      $xfer += $output->writeI16($this->mode);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_chmod_result {
  static $_TSPEC;

  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_chmod_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_chmod_result');
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_chown_args {
  static $_TSPEC;

  public $path = null;
  public $owner = null;
  public $group = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        2 => array(
          'var' => 'owner',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'group',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
      if (isset($vals['owner'])) {
        $this->owner = $vals['owner'];
      }
      if (isset($vals['group'])) {
        $this->group = $vals['group'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_chown_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->owner);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->group);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_chown_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->owner !== null) {
      $xfer += $output->writeFieldBegin('owner', TType::STRING, 2);
      $xfer += $output->writeString($this->owner);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group !== null) {
      $xfer += $output->writeFieldBegin('group', TType::STRING, 3);
      $xfer += $output->writeString($this->group);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_chown_result {
  static $_TSPEC;

  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_chown_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_chown_result');
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_setReplication_args {
  static $_TSPEC;

  public $path = null;
  public $replication = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        2 => array(
          'var' => 'replication',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
      if (isset($vals['replication'])) {
        $this->replication = $vals['replication'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_setReplication_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->replication);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_setReplication_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->replication !== null) {
      $xfer += $output->writeFieldBegin('replication', TType::I16, 2);
      $xfer += $output->writeI16($this->replication);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_setReplication_result {
  static $_TSPEC;

  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_setReplication_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_setReplication_result');
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_getFileBlockLocations_args {
  static $_TSPEC;

  public $path = null;
  public $start = null;
  public $length = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'path',
          'type' => TType::STRUCT,
          'class' => 'Pathname',
          ),
        2 => array(
          'var' => 'start',
          'type' => TType::I64,
          ),
        3 => array(
          'var' => 'length',
          'type' => TType::I64,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['path'])) {
        $this->path = $vals['path'];
      }
      if (isset($vals['start'])) {
        $this->start = $vals['start'];
      }
      if (isset($vals['length'])) {
        $this->length = $vals['length'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_getFileBlockLocations_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->path = new Pathname();
            $xfer += $this->path->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->start);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I64) {
            $xfer += $input->readI64($this->length);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_getFileBlockLocations_args');
    if ($this->path !== null) {
      if (!is_object($this->path)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('path', TType::STRUCT, 1);
      $xfer += $this->path->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->start !== null) {
      $xfer += $output->writeFieldBegin('start', TType::I64, 2);
      $xfer += $output->writeI64($this->start);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->length !== null) {
      $xfer += $output->writeFieldBegin('length', TType::I64, 3);
      $xfer += $output->writeI64($this->length);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystem_getFileBlockLocations_result {
  static $_TSPEC;

  public $success = null;
  public $ouch = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => 'BlockLocation',
            ),
          ),
        1 => array(
          'var' => 'ouch',
          'type' => TType::STRUCT,
          'class' => 'ThriftIOException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['ouch'])) {
        $this->ouch = $vals['ouch'];
      }
    }
  }

  public function getName() {
    return 'ThriftHadoopFileSystem_getFileBlockLocations_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size21 = 0;
            $_etype24 = 0;
            $xfer += $input->readListBegin($_etype24, $_size21);
            for ($_i25 = 0; $_i25 < $_size21; ++$_i25)
            {
              $elem26 = null;
              $elem26 = new BlockLocation();
              $xfer += $elem26->read($input);
              $this->success []= $elem26;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->ouch = new ThriftIOException();
            $xfer += $this->ouch->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHadoopFileSystem_getFileBlockLocations_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter27)
          {
            $xfer += $iter27->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ouch !== null) {
      $xfer += $output->writeFieldBegin('ouch', TType::STRUCT, 1);
      $xfer += $this->ouch->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHadoopFileSystemProcessor {
  protected $handler_ = null;
  public function __construct($handler) {
    $this->handler_ = $handler;
  }

  public function process($input, $output) {
    $rseqid = 0;
    $fname = null;
    $mtype = 0;

    $input->readMessageBegin($fname, $mtype, $rseqid);
    $methodname = 'process_'.$fname;
    if (!method_exists($this, $methodname)) {
      $input->skip(TType::STRUCT);
      $input->readMessageEnd();
      $x = new TApplicationException('Function '.$fname.' not implemented.', TApplicationException::UNKNOWN_METHOD);
      $output->writeMessageBegin($fname, TMessageType::EXCEPTION, $rseqid);
      $x->write($output);
      $output->writeMessageEnd();
      $output->getTransport()->flush();
      return;
    }
    $this->$methodname($rseqid, $input, $output);
    return true;
  }

  protected function process_setInactivityTimeoutPeriod($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_setInactivityTimeoutPeriod_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_setInactivityTimeoutPeriod_result();
    $this->handler_->setInactivityTimeoutPeriod($args->periodInSeconds);
    $output->writeMessageBegin('setInactivityTimeoutPeriod', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_shutdown($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_shutdown_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_shutdown_result();
    $this->handler_->shutdown($args->status);
    $output->writeMessageBegin('shutdown', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_create($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_create_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_create_result();
    try {
      $result->success = $this->handler_->create($args->path);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('create', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_createFile($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_createFile_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_createFile_result();
    try {
      $result->success = $this->handler_->createFile($args->path, $args->mode, $args->overwrite, $args->bufferSize, $args->block_replication, $args->blocksize);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('createFile', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_open($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_open_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_open_result();
    try {
      $result->success = $this->handler_->open($args->path);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('open', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_append($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_append_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_append_result();
    try {
      $result->success = $this->handler_->append($args->path);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('append', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_write($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_write_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_write_result();
    try {
      $result->success = $this->handler_->write($args->handle, $args->data);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('write', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_read($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_read_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_read_result();
    try {
      $result->success = $this->handler_->read($args->handle, $args->offset, $args->size);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('read', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_close($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_close_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_close_result();
    try {
      $result->success = $this->handler_->close($args->out);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('close', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_rm($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_rm_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_rm_result();
    try {
      $result->success = $this->handler_->rm($args->path, $args->recursive);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('rm', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_rename($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_rename_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_rename_result();
    try {
      $result->success = $this->handler_->rename($args->path, $args->dest);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('rename', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_mkdirs($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_mkdirs_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_mkdirs_result();
    try {
      $result->success = $this->handler_->mkdirs($args->path);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('mkdirs', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_exists($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_exists_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_exists_result();
    try {
      $result->success = $this->handler_->exists($args->path);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('exists', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_stat($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_stat_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_stat_result();
    try {
      $result->success = $this->handler_->stat($args->path);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('stat', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_listStatus($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_listStatus_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_listStatus_result();
    try {
      $result->success = $this->handler_->listStatus($args->path);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('listStatus', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_chmod($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_chmod_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_chmod_result();
    try {
      $this->handler_->chmod($args->path, $args->mode);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('chmod', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_chown($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_chown_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_chown_result();
    try {
      $this->handler_->chown($args->path, $args->owner, $args->group);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('chown', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_setReplication($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_setReplication_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_setReplication_result();
    try {
      $this->handler_->setReplication($args->path, $args->replication);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('setReplication', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
  protected function process_getFileBlockLocations($seqid, $input, $output) {
    $args = new ThriftHadoopFileSystem_getFileBlockLocations_args();
    $args->read($input);
    $input->readMessageEnd();
    $result = new ThriftHadoopFileSystem_getFileBlockLocations_result();
    try {
      $result->success = $this->handler_->getFileBlockLocations($args->path, $args->start, $args->length);
    } catch (ThriftIOException $ouch) {
      $result->ouch = $ouch;
    }
    $output->writeMessageBegin('getFileBlockLocations', TMessageType::REPLY, $seqid);
    $result->write($output);
    $output->getTransport()->flush();
  }
}
?>
