/**
 * Autogenerated by Thrift
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 */
package org.apache.hadoop.thriftfs.api;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;
import com.facebook.thrift.*;

import com.facebook.thrift.protocol.*;
import com.facebook.thrift.transport.*;

public class ThriftHadoopFileSystem {

  public interface Iface {

    public void setInactivityTimeoutPeriod(long periodInSeconds) throws TException;

    public void shutdown(int status) throws TException;

    public ThriftHandle create(Pathname path) throws ThriftIOException, TException;

    public ThriftHandle createFile(Pathname path, short mode, boolean overwrite, int bufferSize, short block_replication, long blocksize) throws ThriftIOException, TException;

    public ThriftHandle open(Pathname path) throws ThriftIOException, TException;

    public ThriftHandle append(Pathname path) throws ThriftIOException, TException;

    public boolean write(ThriftHandle handle, String data) throws ThriftIOException, TException;

    public String read(ThriftHandle handle, long offset, int size) throws ThriftIOException, TException;

    public boolean close(ThriftHandle out) throws ThriftIOException, TException;

    public boolean rm(Pathname path, boolean recursive) throws ThriftIOException, TException;

    public boolean rename(Pathname path, Pathname dest) throws ThriftIOException, TException;

    public boolean mkdirs(Pathname path) throws ThriftIOException, TException;

    public boolean exists(Pathname path) throws ThriftIOException, TException;

    public FileStatus stat(Pathname path) throws ThriftIOException, TException;

    public List<FileStatus> listStatus(Pathname path) throws ThriftIOException, TException;

    public void chmod(Pathname path, short mode) throws ThriftIOException, TException;

    public void chown(Pathname path, String owner, String group) throws ThriftIOException, TException;

    public void setReplication(Pathname path, short replication) throws ThriftIOException, TException;

    public List<BlockLocation> getFileBlockLocations(Pathname path, long start, long length) throws ThriftIOException, TException;

  }

  public static class Client implements Iface {
    public Client(TProtocol prot)
    {
      this(prot, prot);
    }

    public Client(TProtocol iprot, TProtocol oprot)
    {
      iprot_ = iprot;
      oprot_ = oprot;
    }

    protected TProtocol iprot_;
    protected TProtocol oprot_;

    protected int seqid_;

    public TProtocol getInputProtocol()
    {
      return this.iprot_;
    }

    public TProtocol getOutputProtocol()
    {
      return this.oprot_;
    }

    public void setInactivityTimeoutPeriod(long periodInSeconds) throws TException
    {
      send_setInactivityTimeoutPeriod(periodInSeconds);
      recv_setInactivityTimeoutPeriod();
    }

    public void send_setInactivityTimeoutPeriod(long periodInSeconds) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("setInactivityTimeoutPeriod", TMessageType.CALL, seqid_));
      setInactivityTimeoutPeriod_args args = new setInactivityTimeoutPeriod_args();
      args.periodInSeconds = periodInSeconds;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_setInactivityTimeoutPeriod() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      setInactivityTimeoutPeriod_result result = new setInactivityTimeoutPeriod_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      return;
    }

    public void shutdown(int status) throws TException
    {
      send_shutdown(status);
      recv_shutdown();
    }

    public void send_shutdown(int status) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("shutdown", TMessageType.CALL, seqid_));
      shutdown_args args = new shutdown_args();
      args.status = status;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_shutdown() throws TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      shutdown_result result = new shutdown_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      return;
    }

    public ThriftHandle create(Pathname path) throws ThriftIOException, TException
    {
      send_create(path);
      return recv_create();
    }

    public void send_create(Pathname path) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("create", TMessageType.CALL, seqid_));
      create_args args = new create_args();
      args.path = path;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public ThriftHandle recv_create() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      create_result result = new create_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "create failed: unknown result");
    }

    public ThriftHandle createFile(Pathname path, short mode, boolean overwrite, int bufferSize, short block_replication, long blocksize) throws ThriftIOException, TException
    {
      send_createFile(path, mode, overwrite, bufferSize, block_replication, blocksize);
      return recv_createFile();
    }

    public void send_createFile(Pathname path, short mode, boolean overwrite, int bufferSize, short block_replication, long blocksize) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("createFile", TMessageType.CALL, seqid_));
      createFile_args args = new createFile_args();
      args.path = path;
      args.mode = mode;
      args.overwrite = overwrite;
      args.bufferSize = bufferSize;
      args.block_replication = block_replication;
      args.blocksize = blocksize;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public ThriftHandle recv_createFile() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      createFile_result result = new createFile_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "createFile failed: unknown result");
    }

    public ThriftHandle open(Pathname path) throws ThriftIOException, TException
    {
      send_open(path);
      return recv_open();
    }

    public void send_open(Pathname path) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("open", TMessageType.CALL, seqid_));
      open_args args = new open_args();
      args.path = path;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public ThriftHandle recv_open() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      open_result result = new open_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "open failed: unknown result");
    }

    public ThriftHandle append(Pathname path) throws ThriftIOException, TException
    {
      send_append(path);
      return recv_append();
    }

    public void send_append(Pathname path) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("append", TMessageType.CALL, seqid_));
      append_args args = new append_args();
      args.path = path;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public ThriftHandle recv_append() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      append_result result = new append_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "append failed: unknown result");
    }

    public boolean write(ThriftHandle handle, String data) throws ThriftIOException, TException
    {
      send_write(handle, data);
      return recv_write();
    }

    public void send_write(ThriftHandle handle, String data) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("write", TMessageType.CALL, seqid_));
      write_args args = new write_args();
      args.handle = handle;
      args.data = data;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public boolean recv_write() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      write_result result = new write_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "write failed: unknown result");
    }

    public String read(ThriftHandle handle, long offset, int size) throws ThriftIOException, TException
    {
      send_read(handle, offset, size);
      return recv_read();
    }

    public void send_read(ThriftHandle handle, long offset, int size) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("read", TMessageType.CALL, seqid_));
      read_args args = new read_args();
      args.handle = handle;
      args.offset = offset;
      args.size = size;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public String recv_read() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      read_result result = new read_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "read failed: unknown result");
    }

    public boolean close(ThriftHandle out) throws ThriftIOException, TException
    {
      send_close(out);
      return recv_close();
    }

    public void send_close(ThriftHandle out) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("close", TMessageType.CALL, seqid_));
      close_args args = new close_args();
      args.out = out;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public boolean recv_close() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      close_result result = new close_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "close failed: unknown result");
    }

    public boolean rm(Pathname path, boolean recursive) throws ThriftIOException, TException
    {
      send_rm(path, recursive);
      return recv_rm();
    }

    public void send_rm(Pathname path, boolean recursive) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("rm", TMessageType.CALL, seqid_));
      rm_args args = new rm_args();
      args.path = path;
      args.recursive = recursive;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public boolean recv_rm() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      rm_result result = new rm_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "rm failed: unknown result");
    }

    public boolean rename(Pathname path, Pathname dest) throws ThriftIOException, TException
    {
      send_rename(path, dest);
      return recv_rename();
    }

    public void send_rename(Pathname path, Pathname dest) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("rename", TMessageType.CALL, seqid_));
      rename_args args = new rename_args();
      args.path = path;
      args.dest = dest;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public boolean recv_rename() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      rename_result result = new rename_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "rename failed: unknown result");
    }

    public boolean mkdirs(Pathname path) throws ThriftIOException, TException
    {
      send_mkdirs(path);
      return recv_mkdirs();
    }

    public void send_mkdirs(Pathname path) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("mkdirs", TMessageType.CALL, seqid_));
      mkdirs_args args = new mkdirs_args();
      args.path = path;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public boolean recv_mkdirs() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      mkdirs_result result = new mkdirs_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "mkdirs failed: unknown result");
    }

    public boolean exists(Pathname path) throws ThriftIOException, TException
    {
      send_exists(path);
      return recv_exists();
    }

    public void send_exists(Pathname path) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("exists", TMessageType.CALL, seqid_));
      exists_args args = new exists_args();
      args.path = path;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public boolean recv_exists() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      exists_result result = new exists_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "exists failed: unknown result");
    }

    public FileStatus stat(Pathname path) throws ThriftIOException, TException
    {
      send_stat(path);
      return recv_stat();
    }

    public void send_stat(Pathname path) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("stat", TMessageType.CALL, seqid_));
      stat_args args = new stat_args();
      args.path = path;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public FileStatus recv_stat() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      stat_result result = new stat_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "stat failed: unknown result");
    }

    public List<FileStatus> listStatus(Pathname path) throws ThriftIOException, TException
    {
      send_listStatus(path);
      return recv_listStatus();
    }

    public void send_listStatus(Pathname path) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("listStatus", TMessageType.CALL, seqid_));
      listStatus_args args = new listStatus_args();
      args.path = path;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public List<FileStatus> recv_listStatus() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      listStatus_result result = new listStatus_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "listStatus failed: unknown result");
    }

    public void chmod(Pathname path, short mode) throws ThriftIOException, TException
    {
      send_chmod(path, mode);
      recv_chmod();
    }

    public void send_chmod(Pathname path, short mode) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("chmod", TMessageType.CALL, seqid_));
      chmod_args args = new chmod_args();
      args.path = path;
      args.mode = mode;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_chmod() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      chmod_result result = new chmod_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      return;
    }

    public void chown(Pathname path, String owner, String group) throws ThriftIOException, TException
    {
      send_chown(path, owner, group);
      recv_chown();
    }

    public void send_chown(Pathname path, String owner, String group) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("chown", TMessageType.CALL, seqid_));
      chown_args args = new chown_args();
      args.path = path;
      args.owner = owner;
      args.group = group;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_chown() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      chown_result result = new chown_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      return;
    }

    public void setReplication(Pathname path, short replication) throws ThriftIOException, TException
    {
      send_setReplication(path, replication);
      recv_setReplication();
    }

    public void send_setReplication(Pathname path, short replication) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("setReplication", TMessageType.CALL, seqid_));
      setReplication_args args = new setReplication_args();
      args.path = path;
      args.replication = replication;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public void recv_setReplication() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      setReplication_result result = new setReplication_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      return;
    }

    public List<BlockLocation> getFileBlockLocations(Pathname path, long start, long length) throws ThriftIOException, TException
    {
      send_getFileBlockLocations(path, start, length);
      return recv_getFileBlockLocations();
    }

    public void send_getFileBlockLocations(Pathname path, long start, long length) throws TException
    {
      oprot_.writeMessageBegin(new TMessage("getFileBlockLocations", TMessageType.CALL, seqid_));
      getFileBlockLocations_args args = new getFileBlockLocations_args();
      args.path = path;
      args.start = start;
      args.length = length;
      args.write(oprot_);
      oprot_.writeMessageEnd();
      oprot_.getTransport().flush();
    }

    public List<BlockLocation> recv_getFileBlockLocations() throws ThriftIOException, TException
    {
      TMessage msg = iprot_.readMessageBegin();
      if (msg.type == TMessageType.EXCEPTION) {
        TApplicationException x = TApplicationException.read(iprot_);
        iprot_.readMessageEnd();
        throw x;
      }
      getFileBlockLocations_result result = new getFileBlockLocations_result();
      result.read(iprot_);
      iprot_.readMessageEnd();
      if (result.__isset.success) {
        return result.success;
      }
      if (result.__isset.ouch) {
        throw result.ouch;
      }
      throw new TApplicationException(TApplicationException.MISSING_RESULT, "getFileBlockLocations failed: unknown result");
    }

  }
  public static class Processor implements TProcessor {
    public Processor(Iface iface)
    {
      iface_ = iface;
      processMap_.put("setInactivityTimeoutPeriod", new setInactivityTimeoutPeriod());
      processMap_.put("shutdown", new shutdown());
      processMap_.put("create", new create());
      processMap_.put("createFile", new createFile());
      processMap_.put("open", new open());
      processMap_.put("append", new append());
      processMap_.put("write", new write());
      processMap_.put("read", new read());
      processMap_.put("close", new close());
      processMap_.put("rm", new rm());
      processMap_.put("rename", new rename());
      processMap_.put("mkdirs", new mkdirs());
      processMap_.put("exists", new exists());
      processMap_.put("stat", new stat());
      processMap_.put("listStatus", new listStatus());
      processMap_.put("chmod", new chmod());
      processMap_.put("chown", new chown());
      processMap_.put("setReplication", new setReplication());
      processMap_.put("getFileBlockLocations", new getFileBlockLocations());
    }

    protected static interface ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException;
    }

    private Iface iface_;
    protected final HashMap<String,ProcessFunction> processMap_ = new HashMap<String,ProcessFunction>();

    public boolean process(TProtocol iprot, TProtocol oprot) throws TException
    {
      TMessage msg = iprot.readMessageBegin();
      ProcessFunction fn = processMap_.get(msg.name);
      if (fn == null) {
        TProtocolUtil.skip(iprot, TType.STRUCT);
        iprot.readMessageEnd();
        TApplicationException x = new TApplicationException(TApplicationException.UNKNOWN_METHOD, "Invalid method name: '"+msg.name+"'");
        oprot.writeMessageBegin(new TMessage(msg.name, TMessageType.EXCEPTION, msg.seqid));
        x.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
        return true;
      }
      fn.process(msg.seqid, iprot, oprot);
      return true;
    }

    private class setInactivityTimeoutPeriod implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        setInactivityTimeoutPeriod_args args = new setInactivityTimeoutPeriod_args();
        args.read(iprot);
        iprot.readMessageEnd();
        setInactivityTimeoutPeriod_result result = new setInactivityTimeoutPeriod_result();
        iface_.setInactivityTimeoutPeriod(args.periodInSeconds);
        oprot.writeMessageBegin(new TMessage("setInactivityTimeoutPeriod", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class shutdown implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        shutdown_args args = new shutdown_args();
        args.read(iprot);
        iprot.readMessageEnd();
        shutdown_result result = new shutdown_result();
        iface_.shutdown(args.status);
        oprot.writeMessageBegin(new TMessage("shutdown", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class create implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        create_args args = new create_args();
        args.read(iprot);
        iprot.readMessageEnd();
        create_result result = new create_result();
        try {
          result.success = iface_.create(args.path);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("create", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class createFile implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        createFile_args args = new createFile_args();
        args.read(iprot);
        iprot.readMessageEnd();
        createFile_result result = new createFile_result();
        try {
          result.success = iface_.createFile(args.path, args.mode, args.overwrite, args.bufferSize, args.block_replication, args.blocksize);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("createFile", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class open implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        open_args args = new open_args();
        args.read(iprot);
        iprot.readMessageEnd();
        open_result result = new open_result();
        try {
          result.success = iface_.open(args.path);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("open", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class append implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        append_args args = new append_args();
        args.read(iprot);
        iprot.readMessageEnd();
        append_result result = new append_result();
        try {
          result.success = iface_.append(args.path);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("append", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class write implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        write_args args = new write_args();
        args.read(iprot);
        iprot.readMessageEnd();
        write_result result = new write_result();
        try {
          result.success = iface_.write(args.handle, args.data);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("write", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class read implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        read_args args = new read_args();
        args.read(iprot);
        iprot.readMessageEnd();
        read_result result = new read_result();
        try {
          result.success = iface_.read(args.handle, args.offset, args.size);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("read", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class close implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        close_args args = new close_args();
        args.read(iprot);
        iprot.readMessageEnd();
        close_result result = new close_result();
        try {
          result.success = iface_.close(args.out);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("close", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class rm implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        rm_args args = new rm_args();
        args.read(iprot);
        iprot.readMessageEnd();
        rm_result result = new rm_result();
        try {
          result.success = iface_.rm(args.path, args.recursive);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("rm", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class rename implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        rename_args args = new rename_args();
        args.read(iprot);
        iprot.readMessageEnd();
        rename_result result = new rename_result();
        try {
          result.success = iface_.rename(args.path, args.dest);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("rename", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class mkdirs implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        mkdirs_args args = new mkdirs_args();
        args.read(iprot);
        iprot.readMessageEnd();
        mkdirs_result result = new mkdirs_result();
        try {
          result.success = iface_.mkdirs(args.path);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("mkdirs", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class exists implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        exists_args args = new exists_args();
        args.read(iprot);
        iprot.readMessageEnd();
        exists_result result = new exists_result();
        try {
          result.success = iface_.exists(args.path);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("exists", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class stat implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        stat_args args = new stat_args();
        args.read(iprot);
        iprot.readMessageEnd();
        stat_result result = new stat_result();
        try {
          result.success = iface_.stat(args.path);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("stat", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class listStatus implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        listStatus_args args = new listStatus_args();
        args.read(iprot);
        iprot.readMessageEnd();
        listStatus_result result = new listStatus_result();
        try {
          result.success = iface_.listStatus(args.path);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("listStatus", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class chmod implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        chmod_args args = new chmod_args();
        args.read(iprot);
        iprot.readMessageEnd();
        chmod_result result = new chmod_result();
        try {
          iface_.chmod(args.path, args.mode);
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("chmod", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class chown implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        chown_args args = new chown_args();
        args.read(iprot);
        iprot.readMessageEnd();
        chown_result result = new chown_result();
        try {
          iface_.chown(args.path, args.owner, args.group);
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("chown", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class setReplication implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        setReplication_args args = new setReplication_args();
        args.read(iprot);
        iprot.readMessageEnd();
        setReplication_result result = new setReplication_result();
        try {
          iface_.setReplication(args.path, args.replication);
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("setReplication", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

    private class getFileBlockLocations implements ProcessFunction {
      public void process(int seqid, TProtocol iprot, TProtocol oprot) throws TException
      {
        getFileBlockLocations_args args = new getFileBlockLocations_args();
        args.read(iprot);
        iprot.readMessageEnd();
        getFileBlockLocations_result result = new getFileBlockLocations_result();
        try {
          result.success = iface_.getFileBlockLocations(args.path, args.start, args.length);
          result.__isset.success = true;
        } catch (ThriftIOException ouch) {
          result.ouch = ouch;
          result.__isset.ouch = true;
        }
        oprot.writeMessageBegin(new TMessage("getFileBlockLocations", TMessageType.REPLY, seqid));
        result.write(oprot);
        oprot.writeMessageEnd();
        oprot.getTransport().flush();
      }

    }

  }

  public static class setInactivityTimeoutPeriod_args implements TBase, java.io.Serializable   {
    public long periodInSeconds;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean periodInSeconds = false;
    }

    public setInactivityTimeoutPeriod_args() {
    }

    public setInactivityTimeoutPeriod_args(
      long periodInSeconds)
    {
      this();
      this.periodInSeconds = periodInSeconds;
      this.__isset.periodInSeconds = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setInactivityTimeoutPeriod_args)
        return this.equals((setInactivityTimeoutPeriod_args)that);
      return false;
    }

    public boolean equals(setInactivityTimeoutPeriod_args that) {
      if (that == null)
        return false;

      boolean this_present_periodInSeconds = true;
      boolean that_present_periodInSeconds = true;
      if (this_present_periodInSeconds || that_present_periodInSeconds) {
        if (!(this_present_periodInSeconds && that_present_periodInSeconds))
          return false;
        if (this.periodInSeconds != that.periodInSeconds)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.I64) {
              this.periodInSeconds = iprot.readI64();
              this.__isset.periodInSeconds = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("setInactivityTimeoutPeriod_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      field.name = "periodInSeconds";
      field.type = TType.I64;
      field.id = 1;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.periodInSeconds);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("setInactivityTimeoutPeriod_args(");
      sb.append("periodInSeconds:");
      sb.append(this.periodInSeconds);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class setInactivityTimeoutPeriod_result implements TBase, java.io.Serializable   {
    public setInactivityTimeoutPeriod_result() {
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setInactivityTimeoutPeriod_result)
        return this.equals((setInactivityTimeoutPeriod_result)that);
      return false;
    }

    public boolean equals(setInactivityTimeoutPeriod_result that) {
      if (that == null)
        return false;

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("setInactivityTimeoutPeriod_result");
      oprot.writeStructBegin(struct);

      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("setInactivityTimeoutPeriod_result(");
      sb.append(")");
      return sb.toString();
    }

  }

  public static class shutdown_args implements TBase, java.io.Serializable   {
    public int status;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean status = false;
    }

    public shutdown_args() {
    }

    public shutdown_args(
      int status)
    {
      this();
      this.status = status;
      this.__isset.status = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof shutdown_args)
        return this.equals((shutdown_args)that);
      return false;
    }

    public boolean equals(shutdown_args that) {
      if (that == null)
        return false;

      boolean this_present_status = true;
      boolean that_present_status = true;
      if (this_present_status || that_present_status) {
        if (!(this_present_status && that_present_status))
          return false;
        if (this.status != that.status)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.I32) {
              this.status = iprot.readI32();
              this.__isset.status = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("shutdown_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      field.name = "status";
      field.type = TType.I32;
      field.id = 1;
      oprot.writeFieldBegin(field);
      oprot.writeI32(this.status);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("shutdown_args(");
      sb.append("status:");
      sb.append(this.status);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class shutdown_result implements TBase, java.io.Serializable   {
    public shutdown_result() {
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof shutdown_result)
        return this.equals((shutdown_result)that);
      return false;
    }

    public boolean equals(shutdown_result that) {
      if (that == null)
        return false;

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("shutdown_result");
      oprot.writeStructBegin(struct);

      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("shutdown_result(");
      sb.append(")");
      return sb.toString();
    }

  }

  public static class create_args implements TBase, java.io.Serializable   {
    public Pathname path;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
    }

    public create_args() {
    }

    public create_args(
      Pathname path)
    {
      this();
      this.path = path;
      this.__isset.path = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof create_args)
        return this.equals((create_args)that);
      return false;
    }

    public boolean equals(create_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("create_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("create_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class create_result implements TBase, java.io.Serializable   {
    public ThriftHandle success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public create_result() {
    }

    public create_result(
      ThriftHandle success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof create_result)
        return this.equals((create_result)that);
      return false;
    }

    public boolean equals(create_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRUCT) {
              this.success = new ThriftHandle();
              this.success.read(iprot);
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("create_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRUCT;
          field.id = 0;
          oprot.writeFieldBegin(field);
          this.success.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("create_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class createFile_args implements TBase, java.io.Serializable   {
    public Pathname path;
    public short mode;
    public boolean overwrite;
    public int bufferSize;
    public short block_replication;
    public long blocksize;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
      public boolean mode = false;
      public boolean overwrite = false;
      public boolean bufferSize = false;
      public boolean block_replication = false;
      public boolean blocksize = false;
    }

    public createFile_args() {
    }

    public createFile_args(
      Pathname path,
      short mode,
      boolean overwrite,
      int bufferSize,
      short block_replication,
      long blocksize)
    {
      this();
      this.path = path;
      this.__isset.path = true;
      this.mode = mode;
      this.__isset.mode = true;
      this.overwrite = overwrite;
      this.__isset.overwrite = true;
      this.bufferSize = bufferSize;
      this.__isset.bufferSize = true;
      this.block_replication = block_replication;
      this.__isset.block_replication = true;
      this.blocksize = blocksize;
      this.__isset.blocksize = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createFile_args)
        return this.equals((createFile_args)that);
      return false;
    }

    public boolean equals(createFile_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_mode = true;
      boolean that_present_mode = true;
      if (this_present_mode || that_present_mode) {
        if (!(this_present_mode && that_present_mode))
          return false;
        if (this.mode != that.mode)
          return false;
      }

      boolean this_present_overwrite = true;
      boolean that_present_overwrite = true;
      if (this_present_overwrite || that_present_overwrite) {
        if (!(this_present_overwrite && that_present_overwrite))
          return false;
        if (this.overwrite != that.overwrite)
          return false;
      }

      boolean this_present_bufferSize = true;
      boolean that_present_bufferSize = true;
      if (this_present_bufferSize || that_present_bufferSize) {
        if (!(this_present_bufferSize && that_present_bufferSize))
          return false;
        if (this.bufferSize != that.bufferSize)
          return false;
      }

      boolean this_present_block_replication = true;
      boolean that_present_block_replication = true;
      if (this_present_block_replication || that_present_block_replication) {
        if (!(this_present_block_replication && that_present_block_replication))
          return false;
        if (this.block_replication != that.block_replication)
          return false;
      }

      boolean this_present_blocksize = true;
      boolean that_present_blocksize = true;
      if (this_present_blocksize || that_present_blocksize) {
        if (!(this_present_blocksize && that_present_blocksize))
          return false;
        if (this.blocksize != that.blocksize)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.I16) {
              this.mode = iprot.readI16();
              this.__isset.mode = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.BOOL) {
              this.overwrite = iprot.readBool();
              this.__isset.overwrite = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 4:
            if (field.type == TType.I32) {
              this.bufferSize = iprot.readI32();
              this.__isset.bufferSize = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 5:
            if (field.type == TType.I16) {
              this.block_replication = iprot.readI16();
              this.__isset.block_replication = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 6:
            if (field.type == TType.I64) {
              this.blocksize = iprot.readI64();
              this.__isset.blocksize = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("createFile_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      field.name = "mode";
      field.type = TType.I16;
      field.id = 2;
      oprot.writeFieldBegin(field);
      oprot.writeI16(this.mode);
      oprot.writeFieldEnd();
      field.name = "overwrite";
      field.type = TType.BOOL;
      field.id = 3;
      oprot.writeFieldBegin(field);
      oprot.writeBool(this.overwrite);
      oprot.writeFieldEnd();
      field.name = "bufferSize";
      field.type = TType.I32;
      field.id = 4;
      oprot.writeFieldBegin(field);
      oprot.writeI32(this.bufferSize);
      oprot.writeFieldEnd();
      field.name = "block_replication";
      field.type = TType.I16;
      field.id = 5;
      oprot.writeFieldBegin(field);
      oprot.writeI16(this.block_replication);
      oprot.writeFieldEnd();
      field.name = "blocksize";
      field.type = TType.I64;
      field.id = 6;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.blocksize);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("createFile_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(",mode:");
      sb.append(this.mode);
      sb.append(",overwrite:");
      sb.append(this.overwrite);
      sb.append(",bufferSize:");
      sb.append(this.bufferSize);
      sb.append(",block_replication:");
      sb.append(this.block_replication);
      sb.append(",blocksize:");
      sb.append(this.blocksize);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class createFile_result implements TBase, java.io.Serializable   {
    public ThriftHandle success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public createFile_result() {
    }

    public createFile_result(
      ThriftHandle success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof createFile_result)
        return this.equals((createFile_result)that);
      return false;
    }

    public boolean equals(createFile_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRUCT) {
              this.success = new ThriftHandle();
              this.success.read(iprot);
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("createFile_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRUCT;
          field.id = 0;
          oprot.writeFieldBegin(field);
          this.success.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("createFile_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class open_args implements TBase, java.io.Serializable   {
    public Pathname path;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
    }

    public open_args() {
    }

    public open_args(
      Pathname path)
    {
      this();
      this.path = path;
      this.__isset.path = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof open_args)
        return this.equals((open_args)that);
      return false;
    }

    public boolean equals(open_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("open_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("open_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class open_result implements TBase, java.io.Serializable   {
    public ThriftHandle success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public open_result() {
    }

    public open_result(
      ThriftHandle success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof open_result)
        return this.equals((open_result)that);
      return false;
    }

    public boolean equals(open_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRUCT) {
              this.success = new ThriftHandle();
              this.success.read(iprot);
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("open_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRUCT;
          field.id = 0;
          oprot.writeFieldBegin(field);
          this.success.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("open_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class append_args implements TBase, java.io.Serializable   {
    public Pathname path;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
    }

    public append_args() {
    }

    public append_args(
      Pathname path)
    {
      this();
      this.path = path;
      this.__isset.path = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof append_args)
        return this.equals((append_args)that);
      return false;
    }

    public boolean equals(append_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("append_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("append_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class append_result implements TBase, java.io.Serializable   {
    public ThriftHandle success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public append_result() {
    }

    public append_result(
      ThriftHandle success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof append_result)
        return this.equals((append_result)that);
      return false;
    }

    public boolean equals(append_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRUCT) {
              this.success = new ThriftHandle();
              this.success.read(iprot);
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("append_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRUCT;
          field.id = 0;
          oprot.writeFieldBegin(field);
          this.success.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("append_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class write_args implements TBase, java.io.Serializable   {
    public ThriftHandle handle;
    public String data;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean handle = false;
      public boolean data = false;
    }

    public write_args() {
    }

    public write_args(
      ThriftHandle handle,
      String data)
    {
      this();
      this.handle = handle;
      this.__isset.handle = true;
      this.data = data;
      this.__isset.data = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof write_args)
        return this.equals((write_args)that);
      return false;
    }

    public boolean equals(write_args that) {
      if (that == null)
        return false;

      boolean this_present_handle = true && (this.handle != null);
      boolean that_present_handle = true && (that.handle != null);
      if (this_present_handle || that_present_handle) {
        if (!(this_present_handle && that_present_handle))
          return false;
        if (!this.handle.equals(that.handle))
          return false;
      }

      boolean this_present_data = true && (this.data != null);
      boolean that_present_data = true && (that.data != null);
      if (this_present_data || that_present_data) {
        if (!(this_present_data && that_present_data))
          return false;
        if (!this.data.equals(that.data))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.handle = new ThriftHandle();
              this.handle.read(iprot);
              this.__isset.handle = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case -1:
            if (field.type == TType.STRING) {
              this.data = iprot.readString();
              this.__isset.data = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("write_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.handle != null) {
        field.name = "handle";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.handle.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.data != null) {
        field.name = "data";
        field.type = TType.STRING;
        field.id = -1;
        oprot.writeFieldBegin(field);
        oprot.writeString(this.data);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("write_args(");
      sb.append("handle:");
      sb.append(this.handle);
      sb.append(",data:");
      sb.append(this.data);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class write_result implements TBase, java.io.Serializable   {
    public boolean success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public write_result() {
    }

    public write_result(
      boolean success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof write_result)
        return this.equals((write_result)that);
      return false;
    }

    public boolean equals(write_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.BOOL) {
              this.success = iprot.readBool();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("write_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.BOOL;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeBool(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("write_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class read_args implements TBase, java.io.Serializable   {
    public ThriftHandle handle;
    public long offset;
    public int size;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean handle = false;
      public boolean offset = false;
      public boolean size = false;
    }

    public read_args() {
    }

    public read_args(
      ThriftHandle handle,
      long offset,
      int size)
    {
      this();
      this.handle = handle;
      this.__isset.handle = true;
      this.offset = offset;
      this.__isset.offset = true;
      this.size = size;
      this.__isset.size = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof read_args)
        return this.equals((read_args)that);
      return false;
    }

    public boolean equals(read_args that) {
      if (that == null)
        return false;

      boolean this_present_handle = true && (this.handle != null);
      boolean that_present_handle = true && (that.handle != null);
      if (this_present_handle || that_present_handle) {
        if (!(this_present_handle && that_present_handle))
          return false;
        if (!this.handle.equals(that.handle))
          return false;
      }

      boolean this_present_offset = true;
      boolean that_present_offset = true;
      if (this_present_offset || that_present_offset) {
        if (!(this_present_offset && that_present_offset))
          return false;
        if (this.offset != that.offset)
          return false;
      }

      boolean this_present_size = true;
      boolean that_present_size = true;
      if (this_present_size || that_present_size) {
        if (!(this_present_size && that_present_size))
          return false;
        if (this.size != that.size)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.handle = new ThriftHandle();
              this.handle.read(iprot);
              this.__isset.handle = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case -1:
            if (field.type == TType.I64) {
              this.offset = iprot.readI64();
              this.__isset.offset = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case -2:
            if (field.type == TType.I32) {
              this.size = iprot.readI32();
              this.__isset.size = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("read_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.handle != null) {
        field.name = "handle";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.handle.write(oprot);
        oprot.writeFieldEnd();
      }
      field.name = "offset";
      field.type = TType.I64;
      field.id = -1;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.offset);
      oprot.writeFieldEnd();
      field.name = "size";
      field.type = TType.I32;
      field.id = -2;
      oprot.writeFieldBegin(field);
      oprot.writeI32(this.size);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("read_args(");
      sb.append("handle:");
      sb.append(this.handle);
      sb.append(",offset:");
      sb.append(this.offset);
      sb.append(",size:");
      sb.append(this.size);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class read_result implements TBase, java.io.Serializable   {
    public String success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public read_result() {
    }

    public read_result(
      String success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof read_result)
        return this.equals((read_result)that);
      return false;
    }

    public boolean equals(read_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRING) {
              this.success = iprot.readString();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("read_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRING;
          field.id = 0;
          oprot.writeFieldBegin(field);
          oprot.writeString(this.success);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("read_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class close_args implements TBase, java.io.Serializable   {
    public ThriftHandle out;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean out = false;
    }

    public close_args() {
    }

    public close_args(
      ThriftHandle out)
    {
      this();
      this.out = out;
      this.__isset.out = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof close_args)
        return this.equals((close_args)that);
      return false;
    }

    public boolean equals(close_args that) {
      if (that == null)
        return false;

      boolean this_present_out = true && (this.out != null);
      boolean that_present_out = true && (that.out != null);
      if (this_present_out || that_present_out) {
        if (!(this_present_out && that_present_out))
          return false;
        if (!this.out.equals(that.out))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.out = new ThriftHandle();
              this.out.read(iprot);
              this.__isset.out = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("close_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.out != null) {
        field.name = "out";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.out.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("close_args(");
      sb.append("out:");
      sb.append(this.out);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class close_result implements TBase, java.io.Serializable   {
    public boolean success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public close_result() {
    }

    public close_result(
      boolean success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof close_result)
        return this.equals((close_result)that);
      return false;
    }

    public boolean equals(close_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.BOOL) {
              this.success = iprot.readBool();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("close_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.BOOL;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeBool(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("close_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class rm_args implements TBase, java.io.Serializable   {
    public Pathname path;
    public boolean recursive;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
      public boolean recursive = false;
    }

    public rm_args() {
    }

    public rm_args(
      Pathname path,
      boolean recursive)
    {
      this();
      this.path = path;
      this.__isset.path = true;
      this.recursive = recursive;
      this.__isset.recursive = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rm_args)
        return this.equals((rm_args)that);
      return false;
    }

    public boolean equals(rm_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_recursive = true;
      boolean that_present_recursive = true;
      if (this_present_recursive || that_present_recursive) {
        if (!(this_present_recursive && that_present_recursive))
          return false;
        if (this.recursive != that.recursive)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.BOOL) {
              this.recursive = iprot.readBool();
              this.__isset.recursive = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("rm_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      field.name = "recursive";
      field.type = TType.BOOL;
      field.id = 2;
      oprot.writeFieldBegin(field);
      oprot.writeBool(this.recursive);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("rm_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(",recursive:");
      sb.append(this.recursive);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class rm_result implements TBase, java.io.Serializable   {
    public boolean success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public rm_result() {
    }

    public rm_result(
      boolean success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rm_result)
        return this.equals((rm_result)that);
      return false;
    }

    public boolean equals(rm_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.BOOL) {
              this.success = iprot.readBool();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("rm_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.BOOL;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeBool(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("rm_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class rename_args implements TBase, java.io.Serializable   {
    public Pathname path;
    public Pathname dest;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
      public boolean dest = false;
    }

    public rename_args() {
    }

    public rename_args(
      Pathname path,
      Pathname dest)
    {
      this();
      this.path = path;
      this.__isset.path = true;
      this.dest = dest;
      this.__isset.dest = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rename_args)
        return this.equals((rename_args)that);
      return false;
    }

    public boolean equals(rename_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_dest = true && (this.dest != null);
      boolean that_present_dest = true && (that.dest != null);
      if (this_present_dest || that_present_dest) {
        if (!(this_present_dest && that_present_dest))
          return false;
        if (!this.dest.equals(that.dest))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRUCT) {
              this.dest = new Pathname();
              this.dest.read(iprot);
              this.__isset.dest = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("rename_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.dest != null) {
        field.name = "dest";
        field.type = TType.STRUCT;
        field.id = 2;
        oprot.writeFieldBegin(field);
        this.dest.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("rename_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(",dest:");
      sb.append(this.dest);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class rename_result implements TBase, java.io.Serializable   {
    public boolean success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public rename_result() {
    }

    public rename_result(
      boolean success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof rename_result)
        return this.equals((rename_result)that);
      return false;
    }

    public boolean equals(rename_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.BOOL) {
              this.success = iprot.readBool();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("rename_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.BOOL;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeBool(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("rename_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mkdirs_args implements TBase, java.io.Serializable   {
    public Pathname path;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
    }

    public mkdirs_args() {
    }

    public mkdirs_args(
      Pathname path)
    {
      this();
      this.path = path;
      this.__isset.path = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mkdirs_args)
        return this.equals((mkdirs_args)that);
      return false;
    }

    public boolean equals(mkdirs_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mkdirs_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mkdirs_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class mkdirs_result implements TBase, java.io.Serializable   {
    public boolean success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public mkdirs_result() {
    }

    public mkdirs_result(
      boolean success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof mkdirs_result)
        return this.equals((mkdirs_result)that);
      return false;
    }

    public boolean equals(mkdirs_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.BOOL) {
              this.success = iprot.readBool();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("mkdirs_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.BOOL;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeBool(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("mkdirs_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class exists_args implements TBase, java.io.Serializable   {
    public Pathname path;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
    }

    public exists_args() {
    }

    public exists_args(
      Pathname path)
    {
      this();
      this.path = path;
      this.__isset.path = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof exists_args)
        return this.equals((exists_args)that);
      return false;
    }

    public boolean equals(exists_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("exists_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("exists_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class exists_result implements TBase, java.io.Serializable   {
    public boolean success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public exists_result() {
    }

    public exists_result(
      boolean success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof exists_result)
        return this.equals((exists_result)that);
      return false;
    }

    public boolean equals(exists_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true;
      boolean that_present_success = true;
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (this.success != that.success)
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.BOOL) {
              this.success = iprot.readBool();
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("exists_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        field.name = "success";
        field.type = TType.BOOL;
        field.id = 0;
        oprot.writeFieldBegin(field);
        oprot.writeBool(this.success);
        oprot.writeFieldEnd();
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("exists_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class stat_args implements TBase, java.io.Serializable   {
    public Pathname path;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
    }

    public stat_args() {
    }

    public stat_args(
      Pathname path)
    {
      this();
      this.path = path;
      this.__isset.path = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof stat_args)
        return this.equals((stat_args)that);
      return false;
    }

    public boolean equals(stat_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("stat_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("stat_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class stat_result implements TBase, java.io.Serializable   {
    public FileStatus success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public stat_result() {
    }

    public stat_result(
      FileStatus success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof stat_result)
        return this.equals((stat_result)that);
      return false;
    }

    public boolean equals(stat_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.STRUCT) {
              this.success = new FileStatus();
              this.success.read(iprot);
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("stat_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.STRUCT;
          field.id = 0;
          oprot.writeFieldBegin(field);
          this.success.write(oprot);
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("stat_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class listStatus_args implements TBase, java.io.Serializable   {
    public Pathname path;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
    }

    public listStatus_args() {
    }

    public listStatus_args(
      Pathname path)
    {
      this();
      this.path = path;
      this.__isset.path = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof listStatus_args)
        return this.equals((listStatus_args)that);
      return false;
    }

    public boolean equals(listStatus_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("listStatus_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("listStatus_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class listStatus_result implements TBase, java.io.Serializable   {
    public List<FileStatus> success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public listStatus_result() {
    }

    public listStatus_result(
      List<FileStatus> success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof listStatus_result)
        return this.equals((listStatus_result)that);
      return false;
    }

    public boolean equals(listStatus_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.LIST) {
              {
                TList _list8 = iprot.readListBegin();
                this.success = new ArrayList<FileStatus>(_list8.size);
                for (int _i9 = 0; _i9 < _list8.size; ++_i9)
                {
                  FileStatus _elem10 = new FileStatus();
                  _elem10 = new FileStatus();
                  _elem10.read(iprot);
                  this.success.add(_elem10);
                }
                iprot.readListEnd();
              }
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("listStatus_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.LIST;
          field.id = 0;
          oprot.writeFieldBegin(field);
          {
            oprot.writeListBegin(new TList(TType.STRUCT, this.success.size()));
            for (FileStatus _iter11 : this.success)            {
              _iter11.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("listStatus_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class chmod_args implements TBase, java.io.Serializable   {
    public Pathname path;
    public short mode;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
      public boolean mode = false;
    }

    public chmod_args() {
    }

    public chmod_args(
      Pathname path,
      short mode)
    {
      this();
      this.path = path;
      this.__isset.path = true;
      this.mode = mode;
      this.__isset.mode = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof chmod_args)
        return this.equals((chmod_args)that);
      return false;
    }

    public boolean equals(chmod_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_mode = true;
      boolean that_present_mode = true;
      if (this_present_mode || that_present_mode) {
        if (!(this_present_mode && that_present_mode))
          return false;
        if (this.mode != that.mode)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.I16) {
              this.mode = iprot.readI16();
              this.__isset.mode = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("chmod_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      field.name = "mode";
      field.type = TType.I16;
      field.id = 2;
      oprot.writeFieldBegin(field);
      oprot.writeI16(this.mode);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("chmod_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(",mode:");
      sb.append(this.mode);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class chmod_result implements TBase, java.io.Serializable   {
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean ouch = false;
    }

    public chmod_result() {
    }

    public chmod_result(
      ThriftIOException ouch)
    {
      this();
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof chmod_result)
        return this.equals((chmod_result)that);
      return false;
    }

    public boolean equals(chmod_result that) {
      if (that == null)
        return false;

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("chmod_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("chmod_result(");
      sb.append("ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class chown_args implements TBase, java.io.Serializable   {
    public Pathname path;
    public String owner;
    public String group;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
      public boolean owner = false;
      public boolean group = false;
    }

    public chown_args() {
    }

    public chown_args(
      Pathname path,
      String owner,
      String group)
    {
      this();
      this.path = path;
      this.__isset.path = true;
      this.owner = owner;
      this.__isset.owner = true;
      this.group = group;
      this.__isset.group = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof chown_args)
        return this.equals((chown_args)that);
      return false;
    }

    public boolean equals(chown_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_owner = true && (this.owner != null);
      boolean that_present_owner = true && (that.owner != null);
      if (this_present_owner || that_present_owner) {
        if (!(this_present_owner && that_present_owner))
          return false;
        if (!this.owner.equals(that.owner))
          return false;
      }

      boolean this_present_group = true && (this.group != null);
      boolean that_present_group = true && (that.group != null);
      if (this_present_group || that_present_group) {
        if (!(this_present_group && that_present_group))
          return false;
        if (!this.group.equals(that.group))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.STRING) {
              this.owner = iprot.readString();
              this.__isset.owner = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.STRING) {
              this.group = iprot.readString();
              this.__isset.group = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("chown_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      if (this.owner != null) {
        field.name = "owner";
        field.type = TType.STRING;
        field.id = 2;
        oprot.writeFieldBegin(field);
        oprot.writeString(this.owner);
        oprot.writeFieldEnd();
      }
      if (this.group != null) {
        field.name = "group";
        field.type = TType.STRING;
        field.id = 3;
        oprot.writeFieldBegin(field);
        oprot.writeString(this.group);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("chown_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(",owner:");
      sb.append(this.owner);
      sb.append(",group:");
      sb.append(this.group);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class chown_result implements TBase, java.io.Serializable   {
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean ouch = false;
    }

    public chown_result() {
    }

    public chown_result(
      ThriftIOException ouch)
    {
      this();
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof chown_result)
        return this.equals((chown_result)that);
      return false;
    }

    public boolean equals(chown_result that) {
      if (that == null)
        return false;

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("chown_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("chown_result(");
      sb.append("ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class setReplication_args implements TBase, java.io.Serializable   {
    public Pathname path;
    public short replication;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
      public boolean replication = false;
    }

    public setReplication_args() {
    }

    public setReplication_args(
      Pathname path,
      short replication)
    {
      this();
      this.path = path;
      this.__isset.path = true;
      this.replication = replication;
      this.__isset.replication = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setReplication_args)
        return this.equals((setReplication_args)that);
      return false;
    }

    public boolean equals(setReplication_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_replication = true;
      boolean that_present_replication = true;
      if (this_present_replication || that_present_replication) {
        if (!(this_present_replication && that_present_replication))
          return false;
        if (this.replication != that.replication)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.I16) {
              this.replication = iprot.readI16();
              this.__isset.replication = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("setReplication_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      field.name = "replication";
      field.type = TType.I16;
      field.id = 2;
      oprot.writeFieldBegin(field);
      oprot.writeI16(this.replication);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("setReplication_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(",replication:");
      sb.append(this.replication);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class setReplication_result implements TBase, java.io.Serializable   {
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean ouch = false;
    }

    public setReplication_result() {
    }

    public setReplication_result(
      ThriftIOException ouch)
    {
      this();
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof setReplication_result)
        return this.equals((setReplication_result)that);
      return false;
    }

    public boolean equals(setReplication_result that) {
      if (that == null)
        return false;

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("setReplication_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("setReplication_result(");
      sb.append("ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getFileBlockLocations_args implements TBase, java.io.Serializable   {
    public Pathname path;
    public long start;
    public long length;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean path = false;
      public boolean start = false;
      public boolean length = false;
    }

    public getFileBlockLocations_args() {
    }

    public getFileBlockLocations_args(
      Pathname path,
      long start,
      long length)
    {
      this();
      this.path = path;
      this.__isset.path = true;
      this.start = start;
      this.__isset.start = true;
      this.length = length;
      this.__isset.length = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getFileBlockLocations_args)
        return this.equals((getFileBlockLocations_args)that);
      return false;
    }

    public boolean equals(getFileBlockLocations_args that) {
      if (that == null)
        return false;

      boolean this_present_path = true && (this.path != null);
      boolean that_present_path = true && (that.path != null);
      if (this_present_path || that_present_path) {
        if (!(this_present_path && that_present_path))
          return false;
        if (!this.path.equals(that.path))
          return false;
      }

      boolean this_present_start = true;
      boolean that_present_start = true;
      if (this_present_start || that_present_start) {
        if (!(this_present_start && that_present_start))
          return false;
        if (this.start != that.start)
          return false;
      }

      boolean this_present_length = true;
      boolean that_present_length = true;
      if (this_present_length || that_present_length) {
        if (!(this_present_length && that_present_length))
          return false;
        if (this.length != that.length)
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 1:
            if (field.type == TType.STRUCT) {
              this.path = new Pathname();
              this.path.read(iprot);
              this.__isset.path = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 2:
            if (field.type == TType.I64) {
              this.start = iprot.readI64();
              this.__isset.start = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 3:
            if (field.type == TType.I64) {
              this.length = iprot.readI64();
              this.__isset.length = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getFileBlockLocations_args");
      oprot.writeStructBegin(struct);
      TField field = new TField();
      if (this.path != null) {
        field.name = "path";
        field.type = TType.STRUCT;
        field.id = 1;
        oprot.writeFieldBegin(field);
        this.path.write(oprot);
        oprot.writeFieldEnd();
      }
      field.name = "start";
      field.type = TType.I64;
      field.id = 2;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.start);
      oprot.writeFieldEnd();
      field.name = "length";
      field.type = TType.I64;
      field.id = 3;
      oprot.writeFieldBegin(field);
      oprot.writeI64(this.length);
      oprot.writeFieldEnd();
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getFileBlockLocations_args(");
      sb.append("path:");
      sb.append(this.path);
      sb.append(",start:");
      sb.append(this.start);
      sb.append(",length:");
      sb.append(this.length);
      sb.append(")");
      return sb.toString();
    }

  }

  public static class getFileBlockLocations_result implements TBase, java.io.Serializable   {
    public List<BlockLocation> success;
    public ThriftIOException ouch;

    public final Isset __isset = new Isset();
    public static final class Isset implements java.io.Serializable {
      public boolean success = false;
      public boolean ouch = false;
    }

    public getFileBlockLocations_result() {
    }

    public getFileBlockLocations_result(
      List<BlockLocation> success,
      ThriftIOException ouch)
    {
      this();
      this.success = success;
      this.__isset.success = true;
      this.ouch = ouch;
      this.__isset.ouch = true;
    }

    public boolean equals(Object that) {
      if (that == null)
        return false;
      if (that instanceof getFileBlockLocations_result)
        return this.equals((getFileBlockLocations_result)that);
      return false;
    }

    public boolean equals(getFileBlockLocations_result that) {
      if (that == null)
        return false;

      boolean this_present_success = true && (this.success != null);
      boolean that_present_success = true && (that.success != null);
      if (this_present_success || that_present_success) {
        if (!(this_present_success && that_present_success))
          return false;
        if (!this.success.equals(that.success))
          return false;
      }

      boolean this_present_ouch = true && (this.ouch != null);
      boolean that_present_ouch = true && (that.ouch != null);
      if (this_present_ouch || that_present_ouch) {
        if (!(this_present_ouch && that_present_ouch))
          return false;
        if (!this.ouch.equals(that.ouch))
          return false;
      }

      return true;
    }

    public int hashCode() {
      return 0;
    }

    public void read(TProtocol iprot) throws TException {
      TField field;
      iprot.readStructBegin();
      while (true)
      {
        field = iprot.readFieldBegin();
        if (field.type == TType.STOP) { 
          break;
        }
        switch (field.id)
        {
          case 0:
            if (field.type == TType.LIST) {
              {
                TList _list12 = iprot.readListBegin();
                this.success = new ArrayList<BlockLocation>(_list12.size);
                for (int _i13 = 0; _i13 < _list12.size; ++_i13)
                {
                  BlockLocation _elem14 = new BlockLocation();
                  _elem14 = new BlockLocation();
                  _elem14.read(iprot);
                  this.success.add(_elem14);
                }
                iprot.readListEnd();
              }
              this.__isset.success = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          case 1:
            if (field.type == TType.STRUCT) {
              this.ouch = new ThriftIOException();
              this.ouch.read(iprot);
              this.__isset.ouch = true;
            } else { 
              TProtocolUtil.skip(iprot, field.type);
            }
            break;
          default:
            TProtocolUtil.skip(iprot, field.type);
            break;
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();
    }

    public void write(TProtocol oprot) throws TException {
      TStruct struct = new TStruct("getFileBlockLocations_result");
      oprot.writeStructBegin(struct);
      TField field = new TField();

      if (this.__isset.success) {
        if (this.success != null) {
          field.name = "success";
          field.type = TType.LIST;
          field.id = 0;
          oprot.writeFieldBegin(field);
          {
            oprot.writeListBegin(new TList(TType.STRUCT, this.success.size()));
            for (BlockLocation _iter15 : this.success)            {
              _iter15.write(oprot);
            }
            oprot.writeListEnd();
          }
          oprot.writeFieldEnd();
        }
      } else if (this.__isset.ouch) {
        if (this.ouch != null) {
          field.name = "ouch";
          field.type = TType.STRUCT;
          field.id = 1;
          oprot.writeFieldBegin(field);
          this.ouch.write(oprot);
          oprot.writeFieldEnd();
        }
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

    public String toString() {
      StringBuilder sb = new StringBuilder("getFileBlockLocations_result(");
      sb.append("success:");
      sb.append(this.success);
      sb.append(",ouch:");
      sb.append(this.ouch);
      sb.append(")");
      return sb.toString();
    }

  }

}
