/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hadoop.contrib.index.lucene.RAMDirectoryUtil;
import org.apache.hadoop.contrib.index.mapred.DocumentAndOp;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateConfiguration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class IntermediateForm
implements Writable {
    private IndexUpdateConfiguration iconf = null;
    private final Collection<Term> deleteList = new ConcurrentLinkedQueue<Term>();
    private RAMDirectory dir = new RAMDirectory();
    private IndexWriter writer = null;
    private int numDocs = 0;

    public void configure(IndexUpdateConfiguration iconf) {
        this.iconf = iconf;
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public Iterator<Term> deleteTermIterator() {
        return this.deleteList.iterator();
    }

    public void process(DocumentAndOp doc, Analyzer analyzer) throws IOException {
        if (doc.getOp() == DocumentAndOp.Op.DELETE || doc.getOp() == DocumentAndOp.Op.UPDATE) {
            this.deleteList.add(doc.getTerm());
        }
        if (doc.getOp() == DocumentAndOp.Op.INSERT || doc.getOp() == DocumentAndOp.Op.UPDATE) {
            if (this.writer == null) {
                this.writer = this.createWriter();
            }
            this.writer.addDocument(doc.getDocument(), analyzer);
            ++this.numDocs;
        }
    }

    public void process(IntermediateForm form) throws IOException {
        if (form.deleteList.size() > 0) {
            this.deleteList.addAll(form.deleteList);
        }
        if (form.dir.sizeInBytes() > 0L) {
            if (this.writer == null) {
                this.writer = this.createWriter();
            }
            this.writer.addIndexesNoOptimize(new Directory[]{form.dir});
            ++this.numDocs;
        }
    }

    public void closeWriter() throws IOException {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("[numDocs=");
        buffer.append(this.numDocs);
        buffer.append(", numDeletes=");
        buffer.append(this.deleteList.size());
        if (this.deleteList.size() > 0) {
            buffer.append("(");
            Iterator<Term> iter = this.deleteTermIterator();
            while (iter.hasNext()) {
                buffer.append(iter.next());
                buffer.append(" ");
            }
            buffer.append(")");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private IndexWriter createWriter() throws IOException {
        int maxFieldLength;
        IndexWriter writer = new IndexWriter((Directory)this.dir, false, null, (IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy());
        writer.setUseCompoundFile(false);
        if (this.iconf != null && (maxFieldLength = this.iconf.getIndexMaxFieldLength()) > 0) {
            writer.setMaxFieldLength(maxFieldLength);
        }
        return writer;
    }

    private void resetForm() throws IOException {
        this.deleteList.clear();
        if (this.dir.sizeInBytes() > 0L) {
            this.dir.close();
            this.dir = new RAMDirectory();
        }
        assert (this.writer == null);
        this.numDocs = 0;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.deleteList.size());
        for (Term term : this.deleteList) {
            Text.writeString((DataOutput)out, (String)term.field());
            Text.writeString((DataOutput)out, (String)term.text());
        }
        String[] files = this.dir.list();
        RAMDirectoryUtil.writeRAMFiles(out, this.dir, files);
    }

    public void readFields(DataInput in) throws IOException {
        this.resetForm();
        int numDeleteTerms = in.readInt();
        for (int i = 0; i < numDeleteTerms; ++i) {
            String field = Text.readString((DataInput)in);
            String text = Text.readString((DataInput)in);
            this.deleteList.add(new Term(field, text));
        }
        RAMDirectoryUtil.readRAMFiles(in, this.dir);
    }
}

