/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.lucene.FileSystemDirectory;
import org.apache.hadoop.contrib.index.lucene.LuceneUtil;
import org.apache.hadoop.contrib.index.mapred.IIndexUpdater;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateCombiner;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateConfiguration;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateMapper;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateOutputFormat;
import org.apache.hadoop.contrib.index.mapred.IndexUpdatePartitioner;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateReducer;
import org.apache.hadoop.contrib.index.mapred.Shard;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;

public class IndexUpdater
implements IIndexUpdater {
    public static final Log LOG = LogFactory.getLog(IndexUpdater.class);

    @Override
    public void run(Configuration conf, Path[] inputPaths, Path outputPath, int numMapTasks, Shard[] shards) throws IOException {
        JobConf jobConf = this.createJob(conf, inputPaths, outputPath, numMapTasks, shards);
        JobClient.runJob((JobConf)jobConf);
    }

    JobConf createJob(Configuration conf, Path[] inputPaths, Path outputPath, int numMapTasks, Shard[] shards) throws IOException {
        this.setShardGeneration(conf, shards);
        IndexUpdateConfiguration iconf = new IndexUpdateConfiguration(conf);
        Shard.setIndexShards(iconf, shards);
        iconf.setIOSortMB(iconf.getIOSortMB() / 2);
        JobConf jobConf = new JobConf(conf, IndexUpdater.class);
        jobConf.setJobName(this.getClass().getName() + "_" + System.currentTimeMillis());
        FileInputFormat.setInputPaths((JobConf)jobConf, (Path[])inputPaths);
        FileOutputFormat.setOutputPath((JobConf)jobConf, (Path)outputPath);
        jobConf.setNumMapTasks(numMapTasks);
        jobConf.setNumReduceTasks(shards.length);
        jobConf.setInputFormat(iconf.getIndexInputFormatClass());
        Path[] inputs = FileInputFormat.getInputPaths((JobConf)jobConf);
        StringBuilder buffer = new StringBuilder(inputs[0].toString());
        for (int i = 1; i < inputs.length; ++i) {
            buffer.append(",");
            buffer.append(inputs[i].toString());
        }
        LOG.info((Object)("mapred.input.dir = " + buffer.toString()));
        LOG.info((Object)("mapred.output.dir = " + FileOutputFormat.getOutputPath((JobConf)jobConf).toString()));
        LOG.info((Object)("mapred.map.tasks = " + jobConf.getNumMapTasks()));
        LOG.info((Object)("mapred.reduce.tasks = " + jobConf.getNumReduceTasks()));
        LOG.info((Object)(shards.length + " shards = " + iconf.getIndexShards()));
        LOG.info((Object)("mapred.input.format.class = " + jobConf.getInputFormat().getClass().getName()));
        jobConf.setMapOutputKeyClass(IndexUpdateMapper.getMapOutputKeyClass());
        jobConf.setMapOutputValueClass(IndexUpdateMapper.getMapOutputValueClass());
        jobConf.setOutputKeyClass(IndexUpdateReducer.getOutputKeyClass());
        jobConf.setOutputValueClass(IndexUpdateReducer.getOutputValueClass());
        jobConf.setMapperClass(IndexUpdateMapper.class);
        jobConf.setPartitionerClass(IndexUpdatePartitioner.class);
        jobConf.setCombinerClass(IndexUpdateCombiner.class);
        jobConf.setReducerClass(IndexUpdateReducer.class);
        jobConf.setOutputFormat(IndexUpdateOutputFormat.class);
        return jobConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShardGeneration(Configuration conf, Shard[] shards) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        for (int i = 0; i < shards.length; ++i) {
            Path path = new Path(shards[i].getDirectory());
            long generation = -1L;
            if (fs.exists(path)) {
                FileSystemDirectory dir = null;
                try {
                    dir = new FileSystemDirectory(fs, path, false, conf);
                    generation = LuceneUtil.getCurrentSegmentGeneration(dir);
                }
                finally {
                    if (dir != null) {
                        dir.close();
                    }
                }
            }
            if (generation == shards[i].getGeneration()) continue;
            shards[i] = new Shard(shards[i].getVersion(), shards[i].getDirectory(), generation);
        }
    }
}

