/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateConfiguration;
import org.apache.hadoop.contrib.index.mapred.IntermediateForm;
import org.apache.hadoop.contrib.index.mapred.Shard;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Partitioner;

public class IndexUpdatePartitioner
implements Partitioner<Shard, IntermediateForm> {
    private Shard[] shards;
    private Map<Shard, Integer> map;

    public int getPartition(Shard key, IntermediateForm value, int numPartitions) {
        int partition = this.map.get(key);
        if (partition < numPartitions) {
            return partition;
        }
        return numPartitions - 1;
    }

    public void configure(JobConf job) {
        this.shards = Shard.getIndexShards(new IndexUpdateConfiguration((Configuration)job));
        this.map = new HashMap<Shard, Integer>();
        for (int i = 0; i < this.shards.length; ++i) {
            this.map.put(this.shards[i], i);
        }
    }
}

