/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateConfiguration;
import org.apache.hadoop.contrib.index.mapred.IntermediateForm;
import org.apache.hadoop.contrib.index.mapred.Shard;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;

public class IndexUpdateCombiner
extends MapReduceBase
implements Reducer<Shard, IntermediateForm, Shard, IntermediateForm> {
    static final Log LOG = LogFactory.getLog(IndexUpdateCombiner.class);
    IndexUpdateConfiguration iconf;

    public void reduce(Shard key, Iterator<IntermediateForm> values, OutputCollector<Shard, IntermediateForm> output, Reporter reporter) throws IOException {
        LOG.info((Object)("Construct a form writer for " + key));
        IntermediateForm form = new IntermediateForm();
        form.configure(this.iconf);
        while (values.hasNext()) {
            IntermediateForm singleDocForm = values.next();
            form.process(singleDocForm);
        }
        form.closeWriter();
        LOG.info((Object)("Closed the form writer for " + key + ", form = " + form));
        output.collect((Object)key, (Object)form);
    }

    public void configure(JobConf job) {
        this.iconf = new IndexUpdateConfiguration((Configuration)job);
    }

    public void close() throws IOException {
    }
}

