/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;

public class DocumentAndOp
implements Writable {
    private Op op;
    private Document doc;
    private Term term;

    public DocumentAndOp() {
    }

    public DocumentAndOp(Op op, Document doc) {
        assert (op == Op.INSERT);
        this.op = op;
        this.doc = doc;
        this.term = null;
    }

    public DocumentAndOp(Op op, Term term) {
        assert (op == Op.DELETE);
        this.op = op;
        this.doc = null;
        this.term = term;
    }

    public DocumentAndOp(Op op, Document doc, Term term) {
        if (op == Op.INSERT) {
            assert (doc != null);
            assert (term == null);
        } else if (op == Op.DELETE) {
            assert (doc == null);
            assert (term != null);
        } else {
            assert (op == Op.UPDATE);
            assert (doc != null);
            assert (term != null);
        }
        this.op = op;
        this.doc = doc;
        this.term = term;
    }

    public void setInsert(Document doc) {
        this.op = Op.INSERT;
        this.doc = doc;
        this.term = null;
    }

    public void setDelete(Term term) {
        this.op = Op.DELETE;
        this.doc = null;
        this.term = term;
    }

    public void setUpdate(Document doc, Term term) {
        this.op = Op.UPDATE;
        this.doc = doc;
        this.term = term;
    }

    public Op getOp() {
        return this.op;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Term getTerm() {
        return this.term;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getName());
        buffer.append("[op=");
        buffer.append(this.op);
        buffer.append(", doc=");
        if (this.doc != null) {
            buffer.append(this.doc);
        } else {
            buffer.append("null");
        }
        buffer.append(", term=");
        if (this.term != null) {
            buffer.append(this.term);
        } else {
            buffer.append("null");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public void write(DataOutput out) throws IOException {
        throw new IOException(this.getClass().getName() + ".write should never be called");
    }

    public void readFields(DataInput in) throws IOException {
        throw new IOException(this.getClass().getName() + ".readFields should never be called");
    }

    public static final class Op {
        public static final Op INSERT = new Op("INSERT");
        public static final Op DELETE = new Op("DELETE");
        public static final Op UPDATE = new Op("UPDATE");
        private String name;

        private Op(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

