/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.main;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.mapred.IIndexUpdater;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateConfiguration;
import org.apache.hadoop.contrib.index.mapred.Shard;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;

public class UpdateIndex {
    public static final Log LOG = LogFactory.getLog(UpdateIndex.class);
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();

    private static long now() {
        return System.currentTimeMillis();
    }

    private static void printUsage(String cmd) {
        System.err.println("Usage: java " + UpdateIndex.class.getName() + "\n" + "                        -inputPaths <inputPath,inputPath>\n" + "                        -outputPath <outputPath>\n" + "                        -shards     <shardDir,shardDir>\n" + "                        -indexPath  <indexPath>\n" + "                        -numShards  <num>\n" + "                        -numMapTasks <num>\n" + "                        -conf       <confPath>\n" + "Note: Do not use both -shards option and -indexPath option.");
    }

    private static String getIndexPath(Configuration conf) {
        return conf.get("sea.index.path");
    }

    private static int getNumShards(Configuration conf) {
        return conf.getInt("sea.num.shards", 1);
    }

    private static Shard[] createShards(String indexPath, int numShards, Configuration conf) throws IOException {
        Path path;
        String parent = Shard.normalizePath(indexPath) + "/";
        long versionNumber = -1L;
        long generation = -1L;
        FileSystem fs = FileSystem.get((Configuration)conf);
        if (fs.exists(path = new Path(indexPath))) {
            FileStatus[] fileStatus = fs.listStatus(path);
            Object[] shardNames = new String[fileStatus.length];
            int count = 0;
            for (int i = 0; i < fileStatus.length; ++i) {
                if (!fileStatus[i].isDir()) continue;
                shardNames[count] = fileStatus[i].getPath().getName();
                ++count;
            }
            Arrays.sort(shardNames, 0, count);
            Shard[] shards = new Shard[count >= numShards ? count : numShards];
            for (int i = 0; i < count; ++i) {
                shards[i] = new Shard(versionNumber, parent + (String)shardNames[i], generation);
            }
            int number = count;
            for (int i = count; i < numShards; ++i) {
                String shardPath;
                while (fs.exists(new Path(shardPath = parent + NUMBER_FORMAT.format(number++)))) {
                }
                shards[i] = new Shard(versionNumber, shardPath, generation);
            }
            return shards;
        }
        Shard[] shards = new Shard[numShards];
        for (int i = 0; i < shards.length; ++i) {
            shards[i] = new Shard(versionNumber, parent + NUMBER_FORMAT.format(i), generation);
        }
        return shards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        if (argv.length == 0) {
            UpdateIndex.printUsage("");
            System.exit(-1);
        }
        String inputPathsString = null;
        Path outputPath = null;
        String shardsString = null;
        String indexPath = null;
        int numShards = -1;
        int numMapTasks = -1;
        Configuration conf = new Configuration();
        String confPath = null;
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-inputPaths")) {
                inputPathsString = argv[++i];
                continue;
            }
            if (argv[i].equals("-outputPath")) {
                outputPath = new Path(argv[++i]);
                continue;
            }
            if (argv[i].equals("-shards")) {
                shardsString = argv[++i];
                continue;
            }
            if (argv[i].equals("-indexPath")) {
                indexPath = argv[++i];
                continue;
            }
            if (argv[i].equals("-numShards")) {
                numShards = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-numMapTasks")) {
                numMapTasks = Integer.parseInt(argv[++i]);
                continue;
            }
            if (argv[i].equals("-conf")) {
                confPath = argv[++i];
                conf.addResource(new Path(confPath));
                continue;
            }
            System.out.println("Unknown option " + argv[i] + " w/ value " + argv[++i]);
        }
        LOG.info((Object)("inputPaths = " + inputPathsString));
        LOG.info((Object)("outputPath = " + outputPath));
        LOG.info((Object)("shards     = " + shardsString));
        LOG.info((Object)("indexPath  = " + indexPath));
        LOG.info((Object)("numShards  = " + numShards));
        LOG.info((Object)("numMapTasks= " + numMapTasks));
        LOG.info((Object)("confPath   = " + confPath));
        Path[] inputPaths = null;
        Shard[] shards = null;
        JobConf jobConf = new JobConf(conf);
        IndexUpdateConfiguration iconf = new IndexUpdateConfiguration((Configuration)jobConf);
        if (inputPathsString != null) {
            jobConf.set("mapred.input.dir", inputPathsString);
        }
        if ((inputPaths = FileInputFormat.getInputPaths((JobConf)jobConf)).length == 0) {
            inputPaths = null;
        }
        if (outputPath == null) {
            outputPath = FileOutputFormat.getOutputPath((JobConf)jobConf);
        }
        if (inputPaths == null || outputPath == null) {
            System.err.println("InputPaths and outputPath must be specified.");
            UpdateIndex.printUsage("");
            System.exit(-1);
        }
        if (shardsString != null) {
            iconf.setIndexShards(shardsString);
        }
        if ((shards = Shard.getIndexShards(iconf)) != null && shards.length == 0) {
            shards = null;
        }
        if (indexPath == null) {
            indexPath = UpdateIndex.getIndexPath(conf);
        }
        if (numShards <= 0) {
            numShards = UpdateIndex.getNumShards(conf);
        }
        if (shards == null && indexPath == null) {
            System.err.println("Either shards or indexPath must be specified.");
            UpdateIndex.printUsage("");
            System.exit(-1);
        }
        if (numMapTasks <= 0) {
            numMapTasks = jobConf.getNumMapTasks();
        }
        try {
            if (shards == null) {
                shards = UpdateIndex.createShards(indexPath, numShards, conf);
            }
            long startTime = UpdateIndex.now();
            try {
                IIndexUpdater updater = (IIndexUpdater)ReflectionUtils.newInstance(iconf.getIndexUpdaterClass(), (Configuration)conf);
                LOG.info((Object)("sea.index.updater = " + iconf.getIndexUpdaterClass().getName()));
                updater.run(conf, inputPaths, outputPath, numMapTasks, shards);
                LOG.info((Object)"Index update job is done");
            }
            finally {
                long elapsedTime = UpdateIndex.now() - startTime;
                LOG.info((Object)("Elapsed time is  " + elapsedTime / 1000L + "s"));
                System.out.println("Elapsed time is " + elapsedTime / 1000L + "s");
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

