/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.lucene;

import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.lucene.LuceneIndexFileNameFilter;
import org.apache.hadoop.contrib.index.lucene.LuceneUtil;
import org.apache.hadoop.contrib.index.lucene.MixedDeletionPolicy;
import org.apache.hadoop.contrib.index.lucene.MixedDirectory;
import org.apache.hadoop.contrib.index.mapred.IndexUpdateConfiguration;
import org.apache.hadoop.contrib.index.mapred.IntermediateForm;
import org.apache.hadoop.contrib.index.mapred.Shard;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;

public class ShardWriter {
    static final Log LOG = LogFactory.getLog(ShardWriter.class);
    private final FileSystem fs;
    private final FileSystem localFs;
    private final Path perm;
    private final Path temp;
    private final Directory dir;
    private final IndexWriter writer;
    private int maxNumSegments;
    private long numForms = 0L;

    public ShardWriter(FileSystem fs, Shard shard, String tempDir, IndexUpdateConfiguration iconf) throws IOException {
        LOG.info((Object)"Construct a shard writer");
        this.fs = fs;
        this.localFs = FileSystem.getLocal((Configuration)iconf.getConfiguration());
        this.perm = new Path(shard.getDirectory());
        this.temp = new Path(tempDir);
        long initGeneration = shard.getGeneration();
        if (!fs.exists(this.perm)) {
            assert (initGeneration < 0L);
            fs.mkdirs(this.perm);
        } else {
            this.restoreGeneration(fs, this.perm, initGeneration);
        }
        this.dir = new MixedDirectory(fs, this.perm, this.localFs, fs.startLocalOutput(this.perm, this.temp), iconf.getConfiguration());
        this.writer = new IndexWriter(this.dir, false, null, (IndexDeletionPolicy)(initGeneration < 0L ? new KeepOnlyLastCommitDeletionPolicy() : new MixedDeletionPolicy()));
        this.setParameters(iconf);
    }

    public void process(IntermediateForm form) throws IOException {
        Iterator<Term> iter = form.deleteTermIterator();
        while (iter.hasNext()) {
            this.writer.deleteDocuments(iter.next());
        }
        this.writer.addIndexesNoOptimize(new Directory[]{form.getDirectory()});
        ++this.numForms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        LOG.info((Object)("Closing the shard writer, processed " + this.numForms + " forms"));
        try {
            try {
                if (this.maxNumSegments > 0) {
                    this.writer.optimize(this.maxNumSegments);
                    LOG.info((Object)("Optimized the shard into at most " + this.maxNumSegments + " segments"));
                }
            }
            finally {
                this.writer.close();
                LOG.info((Object)"Closed Lucene index writer");
            }
            this.moveFromTempToPerm();
            LOG.info((Object)("Moved new index files to " + this.perm));
        }
        finally {
            this.dir.close();
            LOG.info((Object)"Closed the shard writer");
        }
    }

    public String toString() {
        return this.getClass().getName() + "@" + this.perm + "&" + this.temp;
    }

    private void setParameters(IndexUpdateConfiguration iconf) {
        int maxFieldLength = iconf.getIndexMaxFieldLength();
        if (maxFieldLength > 0) {
            this.writer.setMaxFieldLength(maxFieldLength);
        }
        this.writer.setUseCompoundFile(iconf.getIndexUseCompoundFile());
        this.maxNumSegments = iconf.getIndexMaxNumSegments();
        if (maxFieldLength > 0) {
            LOG.info((Object)("sea.max.field.length = " + this.writer.getMaxFieldLength()));
        }
        LOG.info((Object)("sea.use.compound.file = " + this.writer.getUseCompoundFile()));
        LOG.info((Object)("sea.max.num.segments = " + this.maxNumSegments));
    }

    private void restoreGeneration(FileSystem fs, Path perm, long startGen) throws IOException {
        FileStatus[] fileStatus = fs.listStatus(perm, new PathFilter(){

            public boolean accept(Path path) {
                return LuceneUtil.isSegmentsFile(path.getName());
            }
        });
        for (int i = 0; i < fileStatus.length; ++i) {
            Path path = fileStatus[i].getPath();
            if (startGen >= LuceneUtil.generationFromSegmentsFileName(path.getName())) continue;
            fs.delete(path);
        }
        Path segmentsGenFile = new Path("segments.gen");
        if (fs.exists(segmentsGenFile)) {
            fs.delete(segmentsGenFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFromTempToPerm() throws IOException {
        try {
            FileStatus[] fileStatus = this.localFs.listStatus(this.temp, (PathFilter)LuceneIndexFileNameFilter.getFilter());
            Path segmentsPath = null;
            Path segmentsGenPath = null;
            for (int i = 0; i < fileStatus.length; ++i) {
                Path path = fileStatus[i].getPath();
                String name = path.getName();
                if (LuceneUtil.isSegmentsGenFile(name)) {
                    assert (segmentsGenPath == null);
                    segmentsGenPath = path;
                    continue;
                }
                if (LuceneUtil.isSegmentsFile(name)) {
                    assert (segmentsPath == null);
                    segmentsPath = path;
                    continue;
                }
                this.fs.completeLocalOutput(new Path(this.perm, name), path);
            }
            if (segmentsPath != null) {
                this.fs.completeLocalOutput(new Path(this.perm, segmentsPath.getName()), segmentsPath);
            }
            if (segmentsGenPath != null) {
                this.fs.completeLocalOutput(new Path(this.perm, segmentsGenPath.getName()), segmentsGenPath);
            }
        }
        finally {
            this.localFs.delete(this.temp);
        }
    }
}

