/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.lucene;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Text;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMDirectory;

public class RAMDirectoryUtil {
    private static final int BUFFER_SIZE = 1024;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeRAMFiles(DataOutput out, RAMDirectory dir, String[] names) throws IOException {
        out.writeInt(names.length);
        for (int i = 0; i < names.length; ++i) {
            Text.writeString((DataOutput)out, (String)names[i]);
            long length = dir.fileLength(names[i]);
            out.writeLong(length);
            if (length <= 0L) continue;
            IndexInput input = null;
            try {
                input = dir.openInput(names[i], 1024);
                int position = 0;
                byte[] buffer = new byte[1024];
                while ((long)position < length) {
                    int len = (long)(position + 1024) <= length ? 1024 : (int)(length - (long)position);
                    input.readBytes(buffer, 0, len);
                    out.write(buffer, 0, len);
                    position += len;
                }
                continue;
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readRAMFiles(DataInput in, RAMDirectory dir) throws IOException {
        int numFiles = in.readInt();
        for (int i = 0; i < numFiles; ++i) {
            String name = Text.readString((DataInput)in);
            long length = in.readLong();
            if (length <= 0L) continue;
            IndexOutput output = null;
            try {
                output = dir.createOutput(name);
                int position = 0;
                byte[] buffer = new byte[1024];
                while ((long)position < length) {
                    int len = (long)(position + 1024) <= length ? 1024 : (int)(length - (long)position);
                    in.readFully(buffer, 0, len);
                    output.writeBytes(buffer, 0, len);
                    position += len;
                }
                continue;
            }
            finally {
                if (output != null) {
                    output.close();
                }
            }
        }
    }
}

