/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.lucene;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.lucene.FileSystemDirectory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.NoLockFactory;

class MixedDirectory
extends Directory {
    private final Directory readDir;
    private final Directory writeDir;

    public MixedDirectory(FileSystem readFs, Path readPath, FileSystem writeFs, Path writePath, Configuration conf) throws IOException {
        try {
            this.readDir = new FileSystemDirectory(readFs, readPath, false, conf);
            this.writeDir = FSDirectory.getDirectory((String)writePath.toString());
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            throw e;
        }
        this.lockFactory = new NoLockFactory();
    }

    MixedDirectory(Directory readDir, Directory writeDir) throws IOException {
        this.readDir = readDir;
        this.writeDir = writeDir;
        this.lockFactory = new NoLockFactory();
    }

    public String[] list() throws IOException {
        String[] readFiles = this.readDir.list();
        String[] writeFiles = this.writeDir.list();
        if (readFiles == null || readFiles.length == 0) {
            return writeFiles;
        }
        if (writeFiles == null || writeFiles.length == 0) {
            return readFiles;
        }
        String[] result = new String[readFiles.length + writeFiles.length];
        System.arraycopy(readFiles, 0, result, 0, readFiles.length);
        System.arraycopy(writeFiles, 0, result, readFiles.length, writeFiles.length);
        return result;
    }

    public void deleteFile(String name) throws IOException {
        if (this.writeDir.fileExists(name)) {
            this.writeDir.deleteFile(name);
        }
        if (this.readDir.fileExists(name)) {
            this.readDir.deleteFile(name);
        }
    }

    public boolean fileExists(String name) throws IOException {
        return this.writeDir.fileExists(name) || this.readDir.fileExists(name);
    }

    public long fileLength(String name) throws IOException {
        if (this.writeDir.fileExists(name)) {
            return this.writeDir.fileLength(name);
        }
        return this.readDir.fileLength(name);
    }

    public long fileModified(String name) throws IOException {
        if (this.writeDir.fileExists(name)) {
            return this.writeDir.fileModified(name);
        }
        return this.readDir.fileModified(name);
    }

    public void renameFile(String from, String to) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void touchFile(String name) throws IOException {
        if (this.writeDir.fileExists(name)) {
            this.writeDir.touchFile(name);
        } else {
            this.readDir.touchFile(name);
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        return this.writeDir.createOutput(name);
    }

    public IndexInput openInput(String name) throws IOException {
        if (this.writeDir.fileExists(name)) {
            return this.writeDir.openInput(name);
        }
        return this.readDir.openInput(name);
    }

    public IndexInput openInput(String name, int bufferSize) throws IOException {
        if (this.writeDir.fileExists(name)) {
            return this.writeDir.openInput(name, bufferSize);
        }
        return this.readDir.openInput(name, bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            if (this.readDir != null) {
                this.readDir.close();
            }
        }
        finally {
            if (this.writeDir != null) {
                this.writeDir.close();
            }
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "@" + this.readDir + "&" + this.writeDir;
    }
}

