/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.contrib.index.example;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.contrib.index.example.LineDocTextAndOp;
import org.apache.hadoop.contrib.index.mapred.DocumentAndOp;
import org.apache.hadoop.contrib.index.mapred.DocumentID;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.RecordReader;

public class LineDocRecordReader
implements RecordReader<DocumentID, LineDocTextAndOp> {
    private static final char SPACE = ' ';
    private static final char EOL = '\n';
    private long start;
    private long pos;
    private long end;
    private BufferedInputStream in;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream(256);
    private TextStuffer bridge = new TextStuffer();

    public LineDocRecordReader(Configuration job, FileSplit split) throws IOException {
        FSDataInputStream fileIn;
        long start = split.getStart();
        long end = start + split.getLength();
        Path file = split.getPath();
        FileSystem fs = file.getFileSystem(job);
        FSDataInputStream in = fileIn = fs.open(split.getPath());
        boolean skipFirstLine = false;
        if (start != 0L) {
            skipFirstLine = true;
            fileIn.seek(--start);
        }
        this.in = new BufferedInputStream((InputStream)in);
        if (skipFirstLine) {
            start += LineDocRecordReader.readData(this.in, null, '\n');
        }
        this.start = start;
        this.pos = start;
        this.end = end;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public DocumentID createKey() {
        return new DocumentID();
    }

    public LineDocTextAndOp createValue() {
        return new LineDocTextAndOp();
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public float getProgress() throws IOException {
        if (this.start == this.end) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)(this.pos - this.start) / (float)(this.end - this.start));
    }

    public synchronized boolean next(DocumentID key, LineDocTextAndOp value) throws IOException {
        if (this.pos >= this.end) {
            return false;
        }
        if (!this.readInto(key.getText(), ' ')) {
            return false;
        }
        Text opText = new Text();
        if (!this.readInto(opText, ' ')) {
            return false;
        }
        String opStr = opText.toString();
        DocumentAndOp.Op op = opStr.equals("i") || opStr.equals("ins") || opStr.equals("insert") ? DocumentAndOp.Op.INSERT : (opStr.equals("d") || opStr.equals("del") || opStr.equals("delete") ? DocumentAndOp.Op.DELETE : (opStr.equals("u") || opStr.equals("upd") || opStr.equals("update") ? DocumentAndOp.Op.UPDATE : DocumentAndOp.Op.INSERT));
        value.setOp(op);
        if (op == DocumentAndOp.Op.DELETE) {
            return true;
        }
        return this.readInto(value.getText(), '\n');
    }

    private boolean readInto(Text text, char delimiter) throws IOException {
        this.buffer.reset();
        long bytesRead = LineDocRecordReader.readData(this.in, this.buffer, delimiter);
        if (bytesRead == 0L) {
            return false;
        }
        this.pos += bytesRead;
        this.bridge.target = text;
        this.buffer.writeTo(this.bridge);
        return true;
    }

    private static long readData(InputStream in, OutputStream out, char delimiter) throws IOException {
        int b;
        long bytes = 0L;
        while ((b = in.read()) != -1) {
            ++bytes;
            byte c = (byte)b;
            if (c == 10 || c == delimiter) break;
            if (c == 13) {
                in.mark(1);
                byte nextC = (byte)in.read();
                if (nextC != 10 || c == delimiter) {
                    in.reset();
                    break;
                }
                ++bytes;
                break;
            }
            if (out == null) continue;
            out.write(c);
        }
        return bytes;
    }

    private static class TextStuffer
    extends OutputStream {
        public Text target;

        private TextStuffer() {
        }

        @Override
        public void write(int b) {
            throw new UnsupportedOperationException("write(byte) not supported");
        }

        @Override
        public void write(byte[] data, int offset, int len) throws IOException {
            this.target.set(data, offset, len);
        }
    }
}

